/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.appexp.me.strategy;

import appeng.api.behaviors.ContainerItemStrategy;
import appeng.api.config.Actionable;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.google.common.base.Preconditions;
import es.degrassi.appexp.me.key.ExperienceKey;
import es.degrassi.experiencelib.api.capability.ExperienceLibCapabilities;
import es.degrassi.experiencelib.api.capability.IExperienceHandler;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class ExperienceContainerItemStrategy
implements ContainerItemStrategy<ExperienceKey, Context> {
    private long getExperience(ItemStack stack) {
        Preconditions.checkArgument((boolean)this.isExperienced(stack), (Object)"Stack must have Experience capability");
        return ((IExperienceHandler)stack.getCapability(ExperienceLibCapabilities.EXPERIENCE.item())).getExperience();
    }

    private long getCapacity(ItemStack stack) {
        Preconditions.checkArgument((boolean)this.isExperienced(stack), (Object)"Stack must have Experience capability");
        return ((IExperienceHandler)stack.getCapability(ExperienceLibCapabilities.EXPERIENCE.item())).getExperienceCapacity();
    }

    private boolean isExperienced(ItemStack stack) {
        return stack.getCapability(ExperienceLibCapabilities.EXPERIENCE.item()) != null;
    }

    private boolean isCreative(ItemStack stack) {
        return this.isExperienced(stack) && this.getExperience(stack) >= Integer.MAX_VALUE;
    }

    private void changeExperience(long amount, ItemStack stack) {
        Preconditions.checkArgument((boolean)this.isExperienced(stack), (Object)"Stack must have Experience capability");
        if (this.isCreative(stack)) {
            return;
        }
        ((IExperienceHandler)stack.getCapability(ExperienceLibCapabilities.EXPERIENCE.item())).setExperience(0, Math.min(10000L, Math.max(this.getExperience(stack) + amount, 0L)));
    }

    @Nullable
    public GenericStack getContainedStack(ItemStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        IExperienceHandler handler = (IExperienceHandler)stack.getCapability(ExperienceLibCapabilities.EXPERIENCE.item());
        if (handler != null) {
            return new GenericStack((AEKey)ExperienceKey.KEY, handler.getExperience());
        }
        return null;
    }

    @Nullable
    public Context findCarriedContext(Player player, AbstractContainerMenu menu) {
        ItemStack carried = menu.getCarried();
        if (carried.getCapability(ExperienceLibCapabilities.EXPERIENCE.item()) != null) {
            return new CarriedContext(player, menu);
        }
        return null;
    }

    @Nullable
    public Context findPlayerSlotContext(Player player, int slot) {
        ItemStack carried = player.getInventory().getItem(slot);
        if (carried.getCapability(ExperienceLibCapabilities.EXPERIENCE.item()) != null) {
            return new PlayerInvContext(player, slot);
        }
        return null;
    }

    public long extract(Context context, ExperienceKey what, long amount, Actionable mode) {
        long extracted;
        ItemStack stackCopy = context.getStack().copy();
        stackCopy.setCount(1);
        long l = extracted = stackCopy.is(Items.EXPERIENCE_BOTTLE) ? this.getExperience(stackCopy) : Math.min(amount, this.getExperience(stackCopy));
        if (extracted > 0L && mode == Actionable.MODULATE) {
            if (stackCopy.is(Items.EXPERIENCE_BOTTLE)) {
                stackCopy = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
            } else {
                this.changeExperience(-extracted, stackCopy);
            }
            context.getStack().shrink(1);
            context.addOverflow(stackCopy);
        }
        return extracted;
    }

    public long insert(Context context, ExperienceKey what, long amount, Actionable mode) {
        long inserted;
        ItemStack stackCopy = context.getStack().copy();
        stackCopy.setCount(1);
        long l = inserted = stackCopy.is(Items.GLASS_BOTTLE) ? this.getCapacity(stackCopy) : Math.min(amount, 10000L - this.getExperience(stackCopy));
        if (inserted > 0L && mode == Actionable.MODULATE) {
            if (stackCopy.is(Items.GLASS_BOTTLE)) {
                stackCopy = new ItemStack((ItemLike)Items.EXPERIENCE_BOTTLE);
            } else {
                this.changeExperience(inserted, stackCopy);
            }
            context.getStack().shrink(1);
            context.addOverflow(stackCopy);
        }
        return inserted;
    }

    public void playFillSound(Player player, ExperienceKey what) {
    }

    public void playEmptySound(Player player, ExperienceKey what) {
    }

    @Nullable
    public GenericStack getExtractableContent(Context context) {
        return this.getContainedStack(context.getStack());
    }

    private record CarriedContext(Player player, AbstractContainerMenu menu) implements Context
    {
        @Override
        public ItemStack getStack() {
            return this.menu.getCarried();
        }

        @Override
        public void addOverflow(ItemStack stack) {
            if (this.menu.getCarried().isEmpty()) {
                this.menu.setCarried(stack);
            } else {
                this.player.getInventory().placeItemBackInInventory(stack);
            }
        }
    }

    private record PlayerInvContext(Player player, int slot) implements Context
    {
        @Override
        public ItemStack getStack() {
            return this.player.getInventory().getItem(this.slot);
        }

        @Override
        public void addOverflow(ItemStack stack) {
            this.player.getInventory().placeItemBackInInventory(stack);
        }
    }

    public static interface Context {
        public ItemStack getStack();

        public void addOverflow(ItemStack var1);
    }
}

