/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.appexp.me.strategy;

import appeng.api.behaviors.StackExportStrategy;
import appeng.api.behaviors.StackTransferContext;
import appeng.api.config.Actionable;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import es.degrassi.appexp.me.key.ExperienceKey;
import es.degrassi.experiencelib.api.capability.ExperienceLibCapabilities;
import es.degrassi.experiencelib.api.capability.IExperienceHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperienceStackExportStrategy
implements StackExportStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExperienceStackExportStrategy.class);
    private final BlockCapabilityCache<IExperienceHandler, Direction> cache;

    public ExperienceStackExportStrategy(ServerLevel level, BlockPos fromPos, Direction fromSide) {
        this.cache = BlockCapabilityCache.create((BlockCapability)ExperienceLibCapabilities.EXPERIENCE.block(), (ServerLevel)level, (BlockPos)fromPos, (Object)fromSide);
    }

    public long transfer(StackTransferContext context, AEKey what, long amount) {
        if (!(what instanceof ExperienceKey)) {
            return 0L;
        }
        IExperienceHandler handler = (IExperienceHandler)this.cache.getCapability();
        if (handler != null) {
            long insert;
            long insertable = 0L;
            for (int i = 0; i < handler.getTanks() && amount > 0L; amount -= insert, ++i) {
                insert = handler.receiveExperience(i, amount, true);
                insertable += insert;
            }
            long extracted = StorageHelper.poweredExtraction((IEnergySource)context.getEnergySource(), (MEStorage)context.getInternalStorage().getInventory(), (AEKey)ExperienceKey.KEY, (long)insertable, (IActionSource)context.getActionSource(), (Actionable)Actionable.MODULATE);
            if (extracted > 0L) {
                for (int i = 0; i < handler.getTanks() && extracted > 0L; extracted -= handler.receiveExperience(i, extracted, false), ++i) {
                }
            }
            return extracted;
        }
        return 0L;
    }

    public long push(AEKey what, long amount, Actionable mode) {
        if (!(what instanceof ExperienceKey)) {
            return 0L;
        }
        IExperienceHandler handler = (IExperienceHandler)this.cache.getCapability();
        if (handler != null) {
            long ins;
            long inserted = 0L;
            for (int i = 0; i < handler.getTanks() && amount > 0L; amount -= ins, ++i) {
                ins = handler.receiveExperience(i, amount, mode.isSimulate());
                inserted += ins;
            }
            return inserted;
        }
        return 0L;
    }
}

