/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.appexp.network.client;

import es.degrassi.appexp.AppliedExperienced;
import es.degrassi.appexp.block.entity.ExperienceConverterEntity;
import es.degrassi.appexp.client.screen.ExperienceConverterScreen;
import es.degrassi.experiencelib.api.capability.IExperienceHandler;
import es.degrassi.experiencelib.util.ExperienceUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record CExperienceButtonClickedPacket(BlockPos entityPos, ExperienceConverterScreen.Amount amount, boolean extraction) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CExperienceButtonClickedPacket> TYPE = new CustomPacketPayload.Type(AppliedExperienced.id("experience_button_clicked"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CExperienceButtonClickedPacket> CODEC = new StreamCodec<RegistryFriendlyByteBuf, CExperienceButtonClickedPacket>(){

        public CExperienceButtonClickedPacket decode(RegistryFriendlyByteBuf buffer) {
            return new CExperienceButtonClickedPacket(buffer.readBlockPos(), (ExperienceConverterScreen.Amount)buffer.readEnum(ExperienceConverterScreen.Amount.class), buffer.readBoolean());
        }

        public void encode(RegistryFriendlyByteBuf buffer, CExperienceButtonClickedPacket value) {
            buffer.writeBlockPos(value.entityPos);
            buffer.writeEnum((Enum)value.amount);
            buffer.writeBoolean(value.extraction);
        }
    };

    public CustomPacketPayload.Type<CExperienceButtonClickedPacket> type() {
        return TYPE;
    }

    public static void handle(CExperienceButtonClickedPacket packet, IPayloadContext context) {
        ServerPlayer player;
        BlockEntity blockEntity;
        Player player2 = context.player();
        if (player2 instanceof ServerPlayer && (blockEntity = (player = (ServerPlayer)player2).level().getBlockEntity(packet.entityPos)) instanceof ExperienceConverterEntity) {
            ExperienceConverterEntity entity = (ExperienceConverterEntity)blockEntity;
            if (packet.amount.isAll()) {
                ExperienceUtils.addAllLevelToPlayer((IExperienceHandler)entity.getExperienceTank(), (boolean)packet.extraction, (Player)player);
            } else {
                ExperienceUtils.addLevelToPlayer((IExperienceHandler)entity.getExperienceTank(), (int)packet.amount.getAmount(packet.extraction), (Player)player);
            }
        }
    }
}

