/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.config;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import fudge.notenoughcrashes.config.EntryInfo;
import fudge.notenoughcrashes.config.MidnightConfigListWidget;
import fudge.notenoughcrashes.config.MidnightConfigScreen;
import fudge.notenoughcrashes.platform.NecPlatform;
import java.awt.Color;
import java.io.IOException;
import java.io.Reader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7291;
import org.jetbrains.annotations.Nullable;

public abstract class MidnightConfig {
    private static final Pattern INTEGER_ONLY = Pattern.compile("(-?[0-9]*)");
    private static final Pattern DECIMAL_ONLY = Pattern.compile("-?(\\d+\\.?\\d*|\\d*\\.?\\d+|\\.)");
    private static final Pattern HEXADECIMAL_ONLY = Pattern.compile("(-?[#0-9a-fA-F]*)");
    private static final Gson gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).excludeFieldsWithModifiers(new int[]{2}).excludeFieldsWithModifiers(new int[]{16}).addSerializationExclusionStrategy(new ExclusionStrategy(){

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }

        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            return fieldAttributes.getAnnotation(Entry.class) == null;
        }
    }).registerTypeAdapter(class_2960.class, (Object)new TypeAdapter<class_2960>(){

        public void write(JsonWriter out, class_2960 id) throws IOException {
            out.value(id.toString());
        }

        public class_2960 read(JsonReader in) throws IOException {
            return class_2960.method_60654((String)in.nextString());
        }
    }).setPrettyPrinting().create();
    protected static final LinkedHashMap<String, EntryInfo> entries = new LinkedHashMap();
    public static final Map<String, MidnightConfig> configInstances = new HashMap<String, MidnightConfig>();
    protected String modid;
    protected boolean reloadScreen = false;
    public Class<? extends MidnightConfig> configClass;

    public static <T extends MidnightConfig> T createInstance(String modid, Class<? extends MidnightConfig> configClass) {
        try {
            MidnightConfig instance = configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            instance.modid = modid;
            instance.configClass = configClass;
            configInstances.put(modid, instance);
            return (T)instance;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void init(String modid, Class<? extends MidnightConfig> config) {
        Object instance = MidnightConfig.createInstance(modid, config);
        for (Field field : config.getFields()) {
            if (!field.isAnnotationPresent(Entry.class) && !field.isAnnotationPresent(Comment.class) || field.isAnnotationPresent(Server.class) || field.isAnnotationPresent(Hidden.class) || !NecPlatform.instance().isClientEnv()) continue;
            ((MidnightConfig)instance).addClientEntry(field, new EntryInfo(field, modid));
        }
        ((MidnightConfig)instance).loadValuesFromJson();
    }

    public void addClientEntry(Field field, EntryInfo info) {
        Entry e = info.entry;
        if (e != null && info.dataType != null) {
            if (info.dataType == Integer.TYPE) {
                MidnightConfig.textField(info, Integer::parseInt, INTEGER_ONLY, (int)e.min(), (int)e.max(), true);
            } else if (info.dataType == Float.TYPE) {
                MidnightConfig.textField(info, Float::parseFloat, DECIMAL_ONLY, (float)e.min(), (float)e.max(), false);
            } else if (info.dataType == Double.TYPE) {
                MidnightConfig.textField(info, Double::parseDouble, DECIMAL_ONLY, e.min(), e.max(), false);
            } else if (info.dataType == String.class || info.dataType == class_2960.class) {
                MidnightConfig.textField(info, String::length, null, Math.min(e.min(), 0.0), Math.max(e.max(), 1.0), true);
            } else if (info.dataType == Boolean.TYPE) {
                Function<Object, class_2561> func = value -> class_2561.method_43471((String)((Boolean)value != false ? "gui.yes" : "gui.no")).method_27692((Boolean)value != false ? class_124.field_1060 : class_124.field_1061);
                info.function = new AbstractMap.SimpleEntry<class_4185.class_4241, Function<Object, class_2561>>(button -> {
                    info.setValue((Boolean)info.value == false);
                    button.method_25355((class_2561)func.apply(info.value));
                }, func);
            } else if (info.dataType.isEnum()) {
                List<?> values = Arrays.asList(field.getType().getEnumConstants());
                Function<Object, class_2561> func = value -> this.getEnumTranslatableText(value, info);
                info.function = new AbstractMap.SimpleEntry<class_4185.class_4241, Function<Object, class_2561>>(button -> {
                    int index = values.indexOf(info.value) + 1;
                    info.setValue(values.get(index >= values.size() ? 0 : index));
                    button.method_25355((class_2561)func.apply(info.value));
                }, func);
            }
            try {
                info.defaultValue = field.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        entries.put(this.modid + ":" + field.getName(), info);
    }

    public static Class<?> getUnderlyingType(Field field) {
        Class rawType = field.getType();
        if (field.getType() == List.class) {
            rawType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
        }
        try {
            return (Class)rawType.getField("TYPE").get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException ignored) {
            return rawType;
        }
    }

    private static void textField(EntryInfo info, Function<String, Number> f, Pattern pattern, double min, double max, boolean cast) {
        boolean isNumber = pattern != null;
        info.function = (t, b) -> s -> {
            if (!((String)(s = ((String)s).trim())).isEmpty() && isNumber && !pattern.matcher((CharSequence)s).matches() || info.dataType == class_2960.class && class_2960.method_29186((String)s).isError()) {
                return false;
            }
            Number value = 0;
            boolean inLimits = false;
            info.error = null;
            if (!(isNumber && ((String)s).isEmpty() || ((String)s).equals("-") || ((String)s).equals("."))) {
                try {
                    value = (Number)f.apply((String)s);
                }
                catch (NumberFormatException e2) {
                    return false;
                }
                boolean bl = inLimits = value.doubleValue() >= min && value.doubleValue() <= max;
                info.error = inLimits ? null : class_2561.method_43470((String)(value.doubleValue() < min ? "\u00a7cMinimum " + (isNumber ? "value" : "length") + (cast ? " is " + (int)min : " is " + min) : "\u00a7cMaximum " + (isNumber ? "value" : "length") + (cast ? " is " + (int)max : " is " + max))).method_27692(class_124.field_1061);
                t.method_47400(info.getTooltip(true));
            }
            info.tempValue = s;
            t.method_1868(inLimits ? -1 : -34953);
            info.inLimits = inLimits;
            b.field_22763 = entries.values().stream().allMatch(e -> e.inLimits);
            if (inLimits) {
                if (info.dataType == class_2960.class) {
                    info.setValue(class_2960.method_12829((String)s));
                } else {
                    info.setValue(isNumber ? value : s);
                }
            }
            if (info.entry.isColor()) {
                if (!((String)s).contains("#")) {
                    s = "#" + (String)s;
                }
                if (!HEXADECIMAL_ONLY.matcher((CharSequence)s).matches()) {
                    return false;
                }
                try {
                    info.actionButton.method_25355((class_2561)class_2561.method_43470((String)"\u2b1b").method_10862(class_2583.field_24360.method_36139(Color.decode(info.tempValue).getRGB())));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        };
    }

    protected class_2561 getEnumTranslatableText(Object value, EntryInfo info) {
        if (value instanceof class_7291) {
            class_7291 translatableOption = (class_7291)value;
            return translatableOption.method_42627();
        }
        String translationKey = "%s.midnightconfig.enum.%s.%s".formatted(this.modid, info.dataType.getSimpleName(), info.toTemporaryValue());
        return class_1074.method_4663((String)translationKey) ? class_2561.method_43471((String)translationKey) : class_2561.method_43470((String)info.toTemporaryValue());
    }

    public void loadValuesFromJson() {
        try {
            gson.fromJson((Reader)Files.newBufferedReader(this.getJsonFilePath()), this.configClass);
        }
        catch (Exception e) {
            MidnightConfig.write(this.modid);
        }
        entries.values().forEach(info -> {
            if (info.field != null && info.entry != null) {
                try {
                    info.value = info.field.get(null) == null ? info.defaultValue : info.field.get(null);
                    info.tempValue = info.toTemporaryValue();
                    info.updateConditions();
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        });
    }

    public static void write(String modid) {
        configInstances.get(modid).writeChanges(modid);
    }

    @Deprecated
    public void writeChanges(String modid) {
        this.writeChanges();
    }

    public void writeChanges() {
        try {
            Path path = this.getJsonFilePath();
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createFile(path, new FileAttribute[0]);
            }
            Files.write(path, gson.toJson((Object)this).getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            e.fillInStackTrace();
        }
    }

    public Path getJsonFilePath() {
        return NecPlatform.instance().getConfigDirectory().resolve(this.modid + ".json");
    }

    @Nullable
    public static Object getDefaultValue(String modid, String entry) {
        String key = modid + ":" + entry;
        return entries.containsKey(key) ? MidnightConfig.entries.get((Object)key).defaultValue : null;
    }

    public void onTabInit(String tabName, MidnightConfigListWidget list, MidnightConfigScreen screen) {
    }

    public static MidnightConfigScreen getScreen(class_437 parent, String modid) {
        return configInstances.get(modid).getScreen(parent);
    }

    public MidnightConfigScreen getScreen(class_437 parent) {
        return new MidnightConfigScreen(parent, this.modid);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Entry {
        public int width() default 400;

        public double min() default 2.2250738585072014E-308;

        public double max() default 1.7976931348623157E308;

        public String name() default "";

        public int selectionMode() default -1;

        public int fileChooserType() default 0;

        public String[] fileExtensions() default {"*"};

        public int idMode() default -1;

        public boolean isColor() default false;

        public boolean isSlider() default false;

        public int precision() default 100;

        public String category() default "default";

        @Deprecated
        public String requiredMod() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Comment {
        public boolean centered() default false;

        public String category() default "default";

        public String name() default "";

        public String url() default "";

        @Deprecated
        public String requiredMod() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Server {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Hidden {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Conditions {
        public Condition[] value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Repeatable(value=Conditions.class)
    @Target(value={ElementType.FIELD})
    public static @interface Condition {
        public String requiredModId() default "";

        public String requiredOption() default "";

        public String[] requiredValue() default {"true"};

        public boolean visibleButLocked() default false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Client {
    }
}

