/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.mixinhandlers;

import fudge.notenoughcrashes.config.NecConfig;
import fudge.notenoughcrashes.gui.CrashScreen;
import fudge.notenoughcrashes.mixinhandlers.EntryPointCatcher;
import fudge.notenoughcrashes.patches.MinecraftClientAccess;
import fudge.notenoughcrashes.stacktrace.CrashUtils;
import fudge.notenoughcrashes.utils.GlUtil;
import fudge.notenoughcrashes.utils.NecLocalization;
import net.minecraft.class_1132;
import net.minecraft.class_128;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_424;
import net.minecraft.class_437;
import net.minecraft.class_5963;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InGameCatcher {
    private static final Logger LOGGER = LogManager.getLogger((String)"Not Enough Crashes In Game Crashes");
    private static int clientCrashCount = 0;
    private static int serverCrashCount = 0;
    public static boolean crashScreenActive = false;

    public static void handleClientCrash(class_128 report) {
        InGameCatcher.addInfoToCrash(report);
        InGameCatcher.resetStates();
        InGameCatcher.displayCrashScreen(report, ++clientCrashCount, true);
        InGameCatcher.getClient().method_1514();
    }

    private static void resetStates() {
        GlUtil.resetState();
        InGameCatcher.resetModState();
        InGameCatcher.resetCriticalGameState();
    }

    public static void cleanupBeforeMinecraft() {
        if (InGameCatcher.getClient().method_1562() != null) {
            InGameCatcher.getClient().method_1562().method_48296().method_10747(class_2561.method_30163((String)String.format("[%s] Client crashed", "Not Enough Crashes")));
        }
        InGameCatcher.getClient().method_18096((class_437)new class_424(NecLocalization.translatedText("menu.savingLevel")), false);
    }

    private static void resetCriticalGameState() {
        class_310 client = InGameCatcher.getClient();
        if (((MinecraftClientAccess)client).getRecorder().method_34773()) {
            client.method_34745(null);
            ((MinecraftClientAccess)client).setRecorder(class_5963.field_29594);
        }
        client.field_1724 = null;
        client.field_1687 = null;
        class_1132 server = client.method_1576();
        if (server != null) {
            server.method_3747(true);
        }
    }

    private static void resetModState() {
    }

    public static void handleServerCrash(class_128 report) {
        InGameCatcher.addInfoToCrash(report);
        InGameCatcher.displayCrashScreen(report, ++serverCrashCount, false);
    }

    private static class_310 getClient() {
        return class_310.method_1551();
    }

    public static void addInfoToCrash(class_128 report) {
        report.method_567().method_37123("Client Crashes Since Restart", () -> String.valueOf(clientCrashCount));
        report.method_567().method_37123("Integrated Server Crashes Since Restart", () -> String.valueOf(serverCrashCount));
    }

    public static void displayCrashScreen(class_128 report, int crashCount, boolean clientCrash) {
        crashScreenActive = true;
        try {
            if (EntryPointCatcher.crashedDuringStartup()) {
                throw new IllegalStateException("Could not initialize startup crash screen");
            }
            if (crashCount > NecConfig.getCurrent().crashLimit()) {
                throw new IllegalStateException("The game has crashed an excessive amount of times");
            }
            CrashUtils.outputReport(report, clientCrash);
            InGameCatcher.getClient().field_1705.method_1743().method_1808(true);
            InGameCatcher.getClient().method_1507((class_437)new CrashScreen(report));
        }
        catch (Throwable t) {
            crashScreenActive = false;
            LOGGER.error("An uncaught exception occured while displaying the crash screen, making normal report instead", t);
            InGameCatcher.getClient().method_54580(report);
            System.exit(report.method_572() != null ? -1 : -2);
        }
    }
}

