/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.config;

import com.google.common.collect.Lists;
import com.mojang.brigadier.Message;
import fudge.notenoughcrashes.config.EntryInfo;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class ButtonEntry
extends ContainerObjectSelectionList.Entry<ButtonEntry> {
    private static final Font textRenderer = Minecraft.getInstance().font;
    public final Component text;
    public final List<AbstractWidget> buttons;
    public final EntryInfo info;
    public boolean centered = false;
    public MultiLineTextWidget title;

    public ButtonEntry(List<AbstractWidget> buttons, Component text, EntryInfo info) {
        this.buttons = buttons;
        this.text = text;
        this.info = info;
        if (info != null && info.comment != null) {
            this.centered = info.comment.centered();
        }
        int scaledWidth = Minecraft.getInstance().getWindow().getGuiScaledWidth();
        if (!(text == null || text.getString().contains("spacer") && buttons.isEmpty())) {
            this.title = new MultiLineTextWidget(12, 0, Component.translationArg((Message)text), textRenderer).setCentered(this.centered);
            if (info != null) {
                this.title.setTooltip(info.getTooltip(false));
            }
            this.title.setMaxWidth(!buttons.isEmpty() ? buttons.get(buttons.size() > 2 ? buttons.size() - 1 : 0).getX() - 16 : scaledWidth - 24);
            if (this.centered) {
                this.title.setX(scaledWidth / 2 - this.title.getWidth() / 2);
            }
        }
    }

    public void renderContent(GuiGraphics context, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        this.buttons.forEach(b -> {
            b.setY(this.getY());
            b.render(context, mouseX, mouseY, tickDelta);
        });
        if (this.title != null) {
            AbstractWidget abstractWidget;
            this.title.setY(this.getY() + 5);
            this.title.render(context, mouseX, mouseY, tickDelta);
            if (this.info.entry != null && !this.buttons.isEmpty() && (abstractWidget = this.buttons.getFirst()) instanceof AbstractWidget) {
                AbstractWidget widget = abstractWidget;
                int idMode = this.info.entry.idMode();
                if (idMode != -1) {
                    context.renderItem(idMode == 0 ? ((Item)BuiltInRegistries.ITEM.getValue(ResourceLocation.tryParse((String)this.info.tempValue))).getDefaultInstance() : ((Block)BuiltInRegistries.BLOCK.getValue(ResourceLocation.tryParse((String)this.info.tempValue))).asItem().getDefaultInstance(), widget.getX() + widget.getWidth() - 18, this.getY() + 2);
                }
            }
        }
    }

    public boolean mouseClicked(MouseButtonEvent click, boolean doubled) {
        if (this.info != null && this.info.comment != null && !this.info.comment.url().isBlank()) {
            ConfirmLinkScreen.confirmLinkNow((Screen)Minecraft.getInstance().screen, (String)this.info.comment.url(), (boolean)true);
        }
        return super.mouseClicked(click, doubled);
    }

    public List<? extends GuiEventListener> children() {
        return Lists.newArrayList(this.buttons);
    }

    public List<? extends NarratableEntry> narratables() {
        return Lists.newArrayList(this.buttons);
    }
}

