/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.gui;

import fudge.notenoughcrashes.config.NecConfig;
import fudge.notenoughcrashes.gui.ProblemScreen;
import fudge.notenoughcrashes.mixinhandlers.InGameCatcher;
import fudge.notenoughcrashes.utils.NecLocalization;
import net.minecraft.CrashReport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CrashScreen
extends ProblemScreen {
    private static final int BODY_TEXT_COLOR = 0xD0D0D0;

    public CrashScreen(CrashReport report) {
        super(report);
    }

    @Override
    public void init() {
        super.init();
        Button mainMenuButton = Button.builder((Component)NecLocalization.translatedText("gui.toTitle"), btn -> {
            InGameCatcher.crashScreenActive = true;
            Minecraft.getInstance().setScreen((Screen)new TitleScreen());
        }).bounds(this.width / 2 - 155, this.height / 4 + 120 + 12, 150, 20).build();
        if (NecConfig.getCurrent().disableReturnToMainMenu()) {
            mainMenuButton.active = false;
            mainMenuButton.setMessage(NecLocalization.translatedText("notenoughcrashes.gui.disabledByConfig"));
        }
        this.addRenderableWidget((GuiEventListener)mainMenuButton);
        int paragraphStartX = this.width / 2;
        int y = this.height / 4 - 51;
        this.addRenderableWidget((GuiEventListener)this.centeredText(paragraphStartX, y, (Component)Component.translatable((String)"notenoughcrashes.crashscreen.title"), 0xFFFFFF));
        y = this.addBodyLine(paragraphStartX, y + 40, 18, "notenoughcrashes.crashscreen.summary");
        y = this.addBodyLine(paragraphStartX, y, 11, "notenoughcrashes.crashscreen.paragraph1.line1");
        y += 11;
        y = this.addBodyLine(paragraphStartX, y, 11, "notenoughcrashes.crashscreen.paragraph2.line1");
        y = this.addBodyLine(paragraphStartX, y, 9, "notenoughcrashes.crashscreen.paragraph2.line2");
        String fileName = this.getFileNameString();
        y = this.addBodyLine(paragraphStartX, y, 11, fileName, 65280);
        y = this.addBodyLine(paragraphStartX, y, 12, "notenoughcrashes.crashscreen.paragraph3.line1");
        y = this.addBodyLine(paragraphStartX, y, 9, "notenoughcrashes.crashscreen.paragraph3.line2");
        y = this.addBodyLine(paragraphStartX, y, 9, "notenoughcrashes.crashscreen.paragraph3.line3");
        this.addBodyLine(paragraphStartX, y, 9, "notenoughcrashes.crashscreen.paragraph3.line4");
    }

    private StringWidget centeredText(int centreX, int y, Component text, int color) {
        StringWidget w = new StringWidget(text, this.font);
        w.setX(centreX - this.font.width(text.getString()) / 2);
        w.setY(y);
        w.setColor(color);
        return w;
    }

    private StringWidget centeredText(int centreX, int y, String translationKey, int color) {
        return this.centeredText(centreX, y, (Component)Component.translatable((String)translationKey), color);
    }

    private int addBodyLine(int centreX, int currentY, int offset, String keyOrLiteral) {
        return this.addBodyLine(centreX, currentY, offset, keyOrLiteral, 0xD0D0D0);
    }

    private int addBodyLine(int centreX, int currentY, int offset, String keyOrLiteral, int color) {
        int y = currentY + offset;
        this.addRenderableWidget((GuiEventListener)this.centeredText(centreX, y, keyOrLiteral, color));
        return y;
    }
}

