/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.gui;

import fudge.notenoughcrashes.gui.ProblemScreen;
import net.minecraft.CrashReport;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class InitErrorScreen
extends ProblemScreen {
    private static final int BODY_TEXT_COLOR = 0xD0D0D0;

    public InitErrorScreen(CrashReport report) {
        super(report);
    }

    @Override
    public void init() {
        super.init();
        Button exitButton = Button.builder((Component)Component.translatable((String)"menu.quit"), btn -> System.exit(-1)).bounds(this.width / 2 - 155, this.height / 4 + 120 + 12, 150, 20).build();
        this.addRenderableWidget((GuiEventListener)exitButton);
        int paragraphStartX = this.width / 2;
        int y = this.height / 4 - 40;
        this.addRenderableWidget((GuiEventListener)this.centeredText(paragraphStartX, y, (Component)Component.translatable((String)"notenoughcrashes.initerrorscreen.title"), 0xFFFFFF));
        y = this.addBodyLine(paragraphStartX, y + 40, 0, "notenoughcrashes.initerrorscreen.summary");
        y = this.addBodyLine(paragraphStartX, y, 18, "notenoughcrashes.crashscreen.paragraph1.line1");
        y = this.addBodyLine(paragraphStartX, y, 22, "notenoughcrashes.crashscreen.paragraph2.line1");
        y = this.addBodyLine(paragraphStartX, y, 9, "notenoughcrashes.crashscreen.paragraph2.line2");
        String fileName = this.getFileNameString();
        y = this.addBodyLine(paragraphStartX, y, 11, fileName, 65280);
        y = this.addBodyLine(paragraphStartX, y, 12, "notenoughcrashes.initerrorscreen.paragraph3.line1");
        y = this.addBodyLine(paragraphStartX, y, 9, "notenoughcrashes.initerrorscreen.paragraph3.line2");
        y = this.addBodyLine(paragraphStartX, y, 9, "notenoughcrashes.initerrorscreen.paragraph3.line3");
        this.addBodyLine(paragraphStartX, y, 9, "notenoughcrashes.initerrorscreen.paragraph3.line4");
    }

    private StringWidget centeredText(int centreX, int y, Component text, int color) {
        StringWidget w = new StringWidget(text, this.font);
        w.setX(centreX - this.font.width(text.getString()) / 2);
        w.setY(y);
        w.setColor(color);
        return w;
    }

    private StringWidget centeredText(int centreX, int y, String keyOrLiteral, int color) {
        return this.centeredText(centreX, y, (Component)Component.translatable((String)keyOrLiteral), color);
    }

    private int addBodyLine(int centreX, int currentY, int offset, String keyOrLiteral) {
        return this.addBodyLine(centreX, currentY, offset, keyOrLiteral, 0xD0D0D0);
    }

    private int addBodyLine(int centreX, int currentY, int offset, String keyOrLiteral, int color) {
        int y = currentY + offset;
        this.addRenderableWidget((GuiEventListener)this.centeredText(centreX, y, keyOrLiteral, color));
        return y;
    }
}

