/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.gui;

import fudge.notenoughcrashes.NotEnoughCrashes;
import fudge.notenoughcrashes.platform.CommonModMetadata;
import fudge.notenoughcrashes.stacktrace.ModIdentifier;
import fudge.notenoughcrashes.upload.LegacyCrashLogUpload;
import fudge.notenoughcrashes.utils.NecLocalization;
import java.net.URI;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.CrashReport;
import net.minecraft.ReportType;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class ProblemScreen
extends Screen {
    private static final Set<String> IGNORED_MODS = new HashSet<String>(Arrays.asList("minecraft", "fabricloader", "loadcatcher", "jumploader", "quilt_loader", "forge", "notenoughcrashes"));
    protected CrashReport report;
    private String uploadedCrashLink = null;
    protected int xLeft = Integer.MAX_VALUE;
    protected int xRight = Integer.MIN_VALUE;
    protected int yTop = Integer.MAX_VALUE;
    protected int yBottom = Integer.MIN_VALUE;
    protected int x;
    protected int y;

    protected ProblemScreen(CrashReport report) {
        super(Component.nullToEmpty((String)""));
        this.report = report;
    }

    private Component getSuspectedModsText() {
        Set<CommonModMetadata> suspectedMods = ModIdentifier.getSuspectedModsOf(this.report);
        suspectedMods.removeIf(mod -> IGNORED_MODS.contains(mod.id()));
        if (suspectedMods.isEmpty()) {
            return NecLocalization.translatedText("notenoughcrashes.crashscreen.noModsErrored");
        }
        return (Component)suspectedMods.stream().sorted(Comparator.comparing(CommonModMetadata::name)).map(mod -> {
            String issuesPage = mod.issuesPage();
            MutableComponent modText = Component.literal((String)mod.name());
            if (issuesPage != null) {
                modText.withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.OpenUrl(URI.create(issuesPage))));
            }
            return modText;
        }).reduce((existing, next) -> existing.append(Component.nullToEmpty((String)", ")).append((Component)next)).get();
    }

    private void addSuspectedModsWidget() {
        StringWidget widget = new StringWidget(this.getSuspectedModsText(), this.font);
        widget.setX(this.width / 2 - this.font.width(this.getSuspectedModsText().getString()) / 2);
        widget.setColor(0xE0E000);
        widget.setY(this.y + 29);
        this.addRenderableWidget((GuiEventListener)widget);
    }

    private void handleLegacyLinkClick(Button buttonWidget) {
        try {
            if (this.uploadedCrashLink == null) {
                this.uploadedCrashLink = LegacyCrashLogUpload.upload(this.report.getFriendlyReport(ReportType.CRASH));
            }
            Util.getPlatform().openUri(this.uploadedCrashLink);
        }
        catch (Throwable e) {
            NotEnoughCrashes.getLogger().error("Exception when crash menu button clicked:", e);
            buttonWidget.setMessage(NecLocalization.translatedText("notenoughcrashes.gui.failed"));
            buttonWidget.active = false;
        }
    }

    public void init() {
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)NecLocalization.translatedText("notenoughcrashes.gui.getLink"), this::handleLegacyLinkClick).bounds(this.width / 2 - 155 + 160, this.height / 4 + 120 + 12, 150, 20).build());
        this.x = this.width / 2 - 155;
        this.y = this.height / 4;
        this.addSuspectedModsWidget();
    }

    public boolean mouseClicked(MouseButtonEvent click, boolean doubled) {
        Path file;
        if (this.x >= this.xLeft && this.x <= this.xRight && this.y >= this.yTop && this.y <= this.yBottom && (file = this.report.getSaveFile()) != null) {
            Util.getPlatform().openPath(file);
        }
        return super.mouseClicked(click, doubled);
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    String getFileNameString() {
        return this.report.getSaveFile() != null ? "\u00a7n" + String.valueOf(this.report.getSaveFile().getFileName()) : NecLocalization.localize("notenoughcrashes.crashscreen.reportSaveFailed");
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
    }
}

