/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.gui;

import fudge.notenoughcrashes.NotEnoughCrashes;
import fudge.notenoughcrashes.platform.CommonModMetadata;
import fudge.notenoughcrashes.stacktrace.ModIdentifier;
import fudge.notenoughcrashes.upload.LegacyCrashLogUpload;
import fudge.notenoughcrashes.utils.NecLocalization;
import java.net.URI;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11909;
import net.minecraft.class_128;
import net.minecraft.class_156;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7842;
import net.minecraft.class_9813;

@Environment(value=EnvType.CLIENT)
public abstract class ProblemScreen
extends class_437 {
    private static final Set<String> IGNORED_MODS = new HashSet<String>(Arrays.asList("minecraft", "fabricloader", "loadcatcher", "jumploader", "quilt_loader", "forge", "notenoughcrashes"));
    protected class_128 report;
    private String uploadedCrashLink = null;
    protected int xLeft = Integer.MAX_VALUE;
    protected int xRight = Integer.MIN_VALUE;
    protected int yTop = Integer.MAX_VALUE;
    protected int yBottom = Integer.MIN_VALUE;
    protected int x;
    protected int y;

    protected ProblemScreen(class_128 report) {
        super(class_2561.method_30163((String)""));
        this.report = report;
    }

    private class_2561 getSuspectedModsText() {
        Set<CommonModMetadata> suspectedMods = ModIdentifier.getSuspectedModsOf(this.report);
        suspectedMods.removeIf(mod -> IGNORED_MODS.contains(mod.id()));
        if (suspectedMods.isEmpty()) {
            return NecLocalization.translatedText("notenoughcrashes.crashscreen.noModsErrored");
        }
        return (class_2561)suspectedMods.stream().sorted(Comparator.comparing(CommonModMetadata::name)).map(mod -> {
            String issuesPage = mod.issuesPage();
            class_5250 modText = class_2561.method_43470((String)mod.name());
            if (issuesPage != null) {
                modText.method_27694(style -> style.method_10958((class_2558)new class_2558.class_10608(URI.create(issuesPage))));
            }
            return modText;
        }).reduce((existing, next) -> existing.method_10852(class_2561.method_30163((String)", ")).method_10852((class_2561)next)).get();
    }

    private void addSuspectedModsWidget() {
        class_7842 widget = new class_7842(this.getSuspectedModsText(), this.field_22793);
        widget.method_46421(this.field_22789 / 2 - this.field_22793.method_1727(this.getSuspectedModsText().getString()) / 2);
        widget.method_46438(0xE0E000);
        widget.method_46419(this.y + 29);
        this.method_37063((class_364)widget);
    }

    private void handleLegacyLinkClick(class_4185 buttonWidget) {
        try {
            if (this.uploadedCrashLink == null) {
                this.uploadedCrashLink = LegacyCrashLogUpload.upload(this.report.method_60920(class_9813.field_52181));
            }
            class_156.method_668().method_670(this.uploadedCrashLink);
        }
        catch (Throwable e) {
            NotEnoughCrashes.getLogger().error("Exception when crash menu button clicked:", e);
            buttonWidget.method_25355(NecLocalization.translatedText("notenoughcrashes.gui.failed"));
            buttonWidget.field_22763 = false;
        }
    }

    public void method_25426() {
        this.method_37063((class_364)class_4185.method_46430((class_2561)NecLocalization.translatedText("notenoughcrashes.gui.getLink"), this::handleLegacyLinkClick).method_46434(this.field_22789 / 2 - 155 + 160, this.field_22790 / 4 + 120 + 12, 150, 20).method_46431());
        this.x = this.field_22789 / 2 - 155;
        this.y = this.field_22790 / 4;
        this.addSuspectedModsWidget();
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        Path file;
        if (this.x >= this.xLeft && this.x <= this.xRight && this.y >= this.yTop && this.y <= this.yBottom && (file = this.report.method_572()) != null) {
            class_156.method_668().method_60932(file);
        }
        return super.method_25402(click, doubled);
    }

    public boolean method_25422() {
        return false;
    }

    String getFileNameString() {
        return this.report.method_572() != null ? "\u00a7n" + String.valueOf(this.report.method_572().getFileName()) : NecLocalization.localize("notenoughcrashes.crashscreen.reportSaveFailed");
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
    }
}

