/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.mixinhandlers;

import fudge.notenoughcrashes.config.NecConfig;
import fudge.notenoughcrashes.gui.CrashScreen;
import fudge.notenoughcrashes.mixinhandlers.EntryPointCatcher;
import fudge.notenoughcrashes.patches.MinecraftClientAccess;
import fudge.notenoughcrashes.stacktrace.CrashUtils;
import fudge.notenoughcrashes.utils.GlUtil;
import fudge.notenoughcrashes.utils.NecLocalization;
import net.minecraft.CrashReport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.GenericMessageScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.profiling.metrics.profiling.InactiveMetricsRecorder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InGameCatcher {
    private static final Logger LOGGER = LogManager.getLogger((String)"Not Enough Crashes In Game Crashes");
    private static int clientCrashCount = 0;
    private static int serverCrashCount = 0;
    public static boolean crashScreenActive = false;

    public static void handleClientCrash(CrashReport report) {
        InGameCatcher.addInfoToCrash(report);
        InGameCatcher.resetStates();
        InGameCatcher.displayCrashScreen(report, ++clientCrashCount, true);
        InGameCatcher.getClient().run();
    }

    private static void resetStates() {
        GlUtil.resetState();
        InGameCatcher.resetModState();
        InGameCatcher.resetCriticalGameState();
    }

    public static void cleanupBeforeMinecraft() {
        if (InGameCatcher.getClient().getConnection() != null) {
            InGameCatcher.getClient().getConnection().getConnection().disconnect(Component.nullToEmpty((String)String.format("[%s] Client crashed", "Not Enough Crashes")));
        }
        InGameCatcher.getClient().disconnect((Screen)new GenericMessageScreen(NecLocalization.translatedText("menu.savingLevel")), false);
    }

    private static void resetCriticalGameState() {
        Minecraft client = InGameCatcher.getClient();
        if (((MinecraftClientAccess)client).getRecorder().isRecording()) {
            client.debugClientMetricsStart(null);
            ((MinecraftClientAccess)client).setRecorder(InactiveMetricsRecorder.INSTANCE);
        }
        client.player = null;
        client.level = null;
        IntegratedServer server = client.getSingleplayerServer();
        if (server != null) {
            server.halt(true);
        }
    }

    private static void resetModState() {
    }

    public static void handleServerCrash(CrashReport report) {
        InGameCatcher.addInfoToCrash(report);
        InGameCatcher.displayCrashScreen(report, ++serverCrashCount, false);
    }

    private static Minecraft getClient() {
        return Minecraft.getInstance();
    }

    public static void addInfoToCrash(CrashReport report) {
        report.getSystemReport().setDetail("Client Crashes Since Restart", () -> String.valueOf(clientCrashCount));
        report.getSystemReport().setDetail("Integrated Server Crashes Since Restart", () -> String.valueOf(serverCrashCount));
    }

    public static void displayCrashScreen(CrashReport report, int crashCount, boolean clientCrash) {
        crashScreenActive = true;
        try {
            if (EntryPointCatcher.crashedDuringStartup()) {
                throw new IllegalStateException("Could not initialize startup crash screen");
            }
            if (crashCount > NecConfig.getCurrent().crashLimit()) {
                throw new IllegalStateException("The game has crashed an excessive amount of times");
            }
            CrashUtils.outputReport(report, clientCrash);
            InGameCatcher.getClient().gui.getChat().clearMessages(true);
            InGameCatcher.getClient().setScreen((Screen)new CrashScreen(report));
        }
        catch (Throwable t) {
            crashScreenActive = false;
            LOGGER.error("An uncaught exception occured while displaying the crash screen, making normal report instead", t);
            InGameCatcher.getClient().emergencySaveAndCrash(report);
            System.exit(report.getSaveFile() != null ? -1 : -2);
        }
    }
}

