/*
 * Decompiled with CFR 0.152.
 */
package xyz.bluspring.modernnetworking.api;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.bluspring.modernnetworking.api.NetworkCodec;
import xyz.bluspring.modernnetworking.api.NetworkPacket;
import xyz.bluspring.modernnetworking.api.PacketDefinition;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\b\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u00019B\u0011\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007JM\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u000f\"\b\b\u0002\u0010\t*\u00020\b\"\b\b\u0003\u0010\u000b*\u00020\n2\u0006\u0010\f\u001a\u00020\u00042\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\b\u0000\u0012\u00028\u00030\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011JC\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u000f\"\b\b\u0002\u0010\t*\u00020\b\"\b\b\u0003\u0010\u000b*\u00020\n2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0013JM\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u000f\"\b\b\u0002\u0010\t*\u00020\b\"\b\b\u0003\u0010\u000b*\u00020\n2\u0006\u0010\f\u001a\u00020\u00042\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\b\u0000\u0012\u00028\u00030\rH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0011JC\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u000f\"\b\b\u0002\u0010\t*\u00020\b\"\b\b\u0003\u0010\u000b*\u00020\n2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u000fH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0013JM\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u000f\"\b\b\u0002\u0010\t*\u00020\b\"\b\b\u0003\u0010\u000b*\u00020\n2\u0006\u0010\f\u001a\u00020\u00042\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0006\b\u0000\u0012\u00028\u00030\rH\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0011JC\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u000f\"\b\b\u0002\u0010\t*\u00020\b\"\b\b\u0003\u0010\u000b*\u00020\n2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u000fH\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0013JK\u0010\u0019\u001a\u00020\u0018\"\b\b\u0002\u0010\t*\u00020\b\"\b\b\u0003\u0010\u000b*\u00020\n2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u000f2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJK\u0010\u001b\u001a\u00020\u0018\"\b\b\u0002\u0010\t*\u00020\b\"\b\b\u0003\u0010\u000b*\u00020\n2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u000f2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001aJG\u0010\u001f\u001a\u00020\u001e\"\b\b\u0002\u0010\t*\u00020\b\"\b\b\u0003\u0010\u000b*\u00020\n2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u000f2\u0006\u0010\u001c\u001a\u00028\u00032\u0006\u0010\u001d\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u001f\u0010 JG\u0010\u001f\u001a\u00020\u001e\"\b\b\u0002\u0010\t*\u00020\b\"\b\b\u0003\u0010\u000b*\u00020\n2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u000f2\u0006\u0010!\u001a\u00028\u00022\u0006\u0010\u001d\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u001f\u0010\"JG\u0010#\u001a\u00020\u001e\"\b\b\u0002\u0010\t*\u00020\b\"\b\b\u0003\u0010\u000b*\u00020\n2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u000f2\u0006\u0010\u001c\u001a\u00028\u00032\u0006\u0010\u001d\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b#\u0010 JG\u0010#\u001a\u00020\u001e\"\b\b\u0002\u0010\t*\u00020\b\"\b\b\u0003\u0010\u000b*\u00020\n2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u000f2\u0006\u0010!\u001a\u00028\u00022\u0006\u0010\u001d\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b#\u0010\"J1\u0010%\u001a\u0012\u0012\u0006\b\u0001\u0012\u00020\b\u0012\u0004\u0012\u00028\u0002\u0018\u00010\u000f\"\b\b\u0002\u0010\u000b*\u00020\n2\u0006\u0010$\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b%\u0010&J1\u0010'\u001a\u0012\u0012\u0006\b\u0001\u0012\u00020\b\u0012\u0004\u0012\u00028\u0002\u0018\u00010\u000f\"\b\b\u0002\u0010\u000b*\u00020\n2\u0006\u0010$\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b'\u0010&R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010(\u001a\u0004\b)\u0010*R,\u0010,\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\b\u0012\u0002\b\u00030\u000f0+8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/R,\u00100\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\b\u0012\u0002\b\u00030\u000f0+8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b0\u0010-\u001a\u0004\b1\u0010/RF\u00103\u001a.\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\b\u0012\u0002\b\u00030\u000f\u0012\u0018\u0012\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u00020\b0\u00160+028\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b3\u00104\u001a\u0004\b5\u00106RF\u00107\u001a.\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\b\u0012\u0002\b\u00030\u000f\u0012\u0018\u0012\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0001\u0012\u0006\b\u0001\u0012\u00020\b0\u00160+028\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b7\u00104\u001a\u0004\b8\u00106\u00a8\u0006:"}, d2={"Lxyz/bluspring/modernnetworking/api/AbstractNetworkRegistry;", "CLIENT", "SERVER", "", "", "namespace", "<init>", "(Ljava/lang/String;)V", "Lxyz/bluspring/modernnetworking/api/NetworkPacket;", "T", "Lio/netty/buffer/ByteBuf;", "B", "id", "Lxyz/bluspring/modernnetworking/api/NetworkCodec;", "codec", "Lxyz/bluspring/modernnetworking/api/PacketDefinition;", "registerClientbound", "(Ljava/lang/String;Lxyz/bluspring/modernnetworking/api/NetworkCodec;)Lxyz/bluspring/modernnetworking/api/PacketDefinition;", "definition", "(Lxyz/bluspring/modernnetworking/api/PacketDefinition;)Lxyz/bluspring/modernnetworking/api/PacketDefinition;", "registerServerbound", "registerDual", "Lxyz/bluspring/modernnetworking/api/AbstractNetworkRegistry$NetworkHandler;", "handler", "", "addClientboundHandler", "(Lxyz/bluspring/modernnetworking/api/PacketDefinition;Lxyz/bluspring/modernnetworking/api/AbstractNetworkRegistry$NetworkHandler;)V", "addServerboundHandler", "buffer", "ctx", "", "handleClientPacket", "(Lxyz/bluspring/modernnetworking/api/PacketDefinition;Lio/netty/buffer/ByteBuf;Ljava/lang/Object;)Z", "packet", "(Lxyz/bluspring/modernnetworking/api/PacketDefinition;Lxyz/bluspring/modernnetworking/api/NetworkPacket;Ljava/lang/Object;)Z", "handleServerPacket", "path", "getClientboundDefinition", "(Ljava/lang/String;)Lxyz/bluspring/modernnetworking/api/PacketDefinition;", "getServerboundDefinition", "Ljava/lang/String;", "getNamespace", "()Ljava/lang/String;", "", "clientboundPackets", "Ljava/util/List;", "getClientboundPackets", "()Ljava/util/List;", "serverboundPackets", "getServerboundPackets", "", "clientHandlers", "Ljava/util/Map;", "getClientHandlers", "()Ljava/util/Map;", "serverHandlers", "getServerHandlers", "NetworkHandler", "modernnetworking-api"})
@SourceDebugExtension(value={"SMAP\nAbstractNetworkRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractNetworkRegistry.kt\nxyz/bluspring/modernnetworking/api/AbstractNetworkRegistry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n1761#2,3:137\n1761#2,3:140\n1761#2,3:143\n1761#2,3:146\n295#2,2:149\n295#2,2:151\n*S KotlinDebug\n*F\n+ 1 AbstractNetworkRegistry.kt\nxyz/bluspring/modernnetworking/api/AbstractNetworkRegistry\n*L\n19#1:137,3\n30#1:140,3\n41#1:143,3\n52#1:146,3\n126#1:149,2\n130#1:151,2\n*E\n"})
public abstract class AbstractNetworkRegistry<CLIENT, SERVER> {
    @NotNull
    private final String namespace;
    @NotNull
    private final List<PacketDefinition<? extends NetworkPacket, ?>> clientboundPackets;
    @NotNull
    private final List<PacketDefinition<? extends NetworkPacket, ?>> serverboundPackets;
    @NotNull
    private final Map<PacketDefinition<? extends NetworkPacket, ?>, List<NetworkHandler<CLIENT, ? extends NetworkPacket>>> clientHandlers;
    @NotNull
    private final Map<PacketDefinition<? extends NetworkPacket, ?>, List<NetworkHandler<SERVER, ? extends NetworkPacket>>> serverHandlers;

    protected AbstractNetworkRegistry(@NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        this.namespace = namespace;
        this.clientboundPackets = new ArrayList();
        this.serverboundPackets = new ArrayList();
        this.clientHandlers = new LinkedHashMap();
        this.serverHandlers = new LinkedHashMap();
    }

    @NotNull
    public final String getNamespace() {
        return this.namespace;
    }

    @NotNull
    protected final List<PacketDefinition<? extends NetworkPacket, ?>> getClientboundPackets() {
        return this.clientboundPackets;
    }

    @NotNull
    protected final List<PacketDefinition<? extends NetworkPacket, ?>> getServerboundPackets() {
        return this.serverboundPackets;
    }

    @NotNull
    protected final Map<PacketDefinition<? extends NetworkPacket, ?>, List<NetworkHandler<CLIENT, ? extends NetworkPacket>>> getClientHandlers() {
        return this.clientHandlers;
    }

    @NotNull
    protected final Map<PacketDefinition<? extends NetworkPacket, ?>, List<NetworkHandler<SERVER, ? extends NetworkPacket>>> getServerHandlers() {
        return this.serverHandlers;
    }

    @NotNull
    public <T extends NetworkPacket, B extends ByteBuf> PacketDefinition<T, B> registerClientbound(@NotNull String id, @NotNull NetworkCodec<T, ? super B> codec) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter(codec, (String)"codec");
            Iterable $this$any$iv = this.clientboundPackets;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PacketDefinition it = (PacketDefinition)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getNamespace(), (Object)this.namespace) && Intrinsics.areEqual((Object)it.getId(), (Object)id))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new IllegalArgumentException("Clientbound packet " + id + " already exists!");
        }
        PacketDefinition<T, ? super B> definition = new PacketDefinition<T, B>(this.namespace, id, codec);
        return this.registerClientbound(definition);
    }

    @NotNull
    public <T extends NetworkPacket, B extends ByteBuf> PacketDefinition<T, B> registerClientbound(@NotNull PacketDefinition<T, B> definition) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(definition, (String)"definition");
            Iterable $this$any$iv = this.clientboundPackets;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PacketDefinition it = (PacketDefinition)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getNamespace(), (Object)definition.getNamespace()) && Intrinsics.areEqual((Object)it.getId(), (Object)definition.getId()))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new IllegalArgumentException("Clientbound packet " + definition.getNamespace() + ':' + definition.getId() + " already exists!");
        }
        this.clientboundPackets.add(definition);
        return definition;
    }

    @NotNull
    public <T extends NetworkPacket, B extends ByteBuf> PacketDefinition<T, B> registerServerbound(@NotNull String id, @NotNull NetworkCodec<T, ? super B> codec) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter(codec, (String)"codec");
            Iterable $this$any$iv = this.serverboundPackets;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PacketDefinition it = (PacketDefinition)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getNamespace(), (Object)this.namespace) && Intrinsics.areEqual((Object)it.getId(), (Object)id))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new IllegalArgumentException("Serverbound packet " + id + " already exists!");
        }
        PacketDefinition<T, ? super B> definition = new PacketDefinition<T, B>(this.namespace, id, codec);
        return this.registerServerbound(definition);
    }

    @NotNull
    public <T extends NetworkPacket, B extends ByteBuf> PacketDefinition<T, B> registerServerbound(@NotNull PacketDefinition<T, B> definition) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(definition, (String)"definition");
            Iterable $this$any$iv = this.clientboundPackets;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PacketDefinition it = (PacketDefinition)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getNamespace(), (Object)definition.getNamespace()) && Intrinsics.areEqual((Object)it.getId(), (Object)definition.getId()))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new IllegalArgumentException("Serverbound packet " + definition.getNamespace() + ':' + definition.getId() + " already exists!");
        }
        this.serverboundPackets.add(definition);
        return definition;
    }

    @NotNull
    public <T extends NetworkPacket, B extends ByteBuf> PacketDefinition<T, B> registerDual(@NotNull String id, @NotNull NetworkCodec<T, ? super B> codec) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(codec, (String)"codec");
        return this.registerClientbound(this.registerServerbound(id, codec));
    }

    @NotNull
    public <T extends NetworkPacket, B extends ByteBuf> PacketDefinition<T, B> registerDual(@NotNull PacketDefinition<T, B> definition) {
        Intrinsics.checkNotNullParameter(definition, (String)"definition");
        return this.registerClientbound(this.registerServerbound(definition));
    }

    public <T extends NetworkPacket, B extends ByteBuf> void addClientboundHandler(@NotNull PacketDefinition<T, B> definition, @NotNull NetworkHandler<CLIENT, T> handler) {
        Intrinsics.checkNotNullParameter(definition, (String)"definition");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.clientHandlers.computeIfAbsent(definition, arg_0 -> AbstractNetworkRegistry.addClientboundHandler$lambda$1(AbstractNetworkRegistry::addClientboundHandler$lambda$0, arg_0)).add(handler);
    }

    public <T extends NetworkPacket, B extends ByteBuf> void addServerboundHandler(@NotNull PacketDefinition<T, B> definition, @NotNull NetworkHandler<SERVER, T> handler) {
        Intrinsics.checkNotNullParameter(definition, (String)"definition");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.serverHandlers.computeIfAbsent(definition, arg_0 -> AbstractNetworkRegistry.addServerboundHandler$lambda$1(AbstractNetworkRegistry::addServerboundHandler$lambda$0, arg_0)).add(handler);
    }

    public <T extends NetworkPacket, B extends ByteBuf> boolean handleClientPacket(@NotNull PacketDefinition<T, B> definition, @NotNull B buffer, CLIENT ctx) {
        Intrinsics.checkNotNullParameter(definition, (String)"definition");
        Intrinsics.checkNotNullParameter(buffer, (String)"buffer");
        NetworkPacket packet = (NetworkPacket)definition.getCodec().decode(buffer);
        return this.handleClientPacket(definition, packet, ctx);
    }

    public <T extends NetworkPacket, B extends ByteBuf> boolean handleClientPacket(@NotNull PacketDefinition<T, B> definition, @NotNull T packet, CLIENT ctx) {
        Intrinsics.checkNotNullParameter(definition, (String)"definition");
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        List<NetworkHandler<CLIENT, NetworkPacket>> list = this.clientHandlers.get(definition);
        if (list == null) {
            return false;
        }
        List<NetworkHandler<CLIENT, NetworkPacket>> handlers = list;
        for (NetworkHandler<CLIENT, NetworkPacket> handler : handlers) {
            handler.handle(packet, ctx);
        }
        return true;
    }

    public <T extends NetworkPacket, B extends ByteBuf> boolean handleServerPacket(@NotNull PacketDefinition<T, B> definition, @NotNull B buffer, SERVER ctx) {
        Intrinsics.checkNotNullParameter(definition, (String)"definition");
        Intrinsics.checkNotNullParameter(buffer, (String)"buffer");
        NetworkPacket packet = (NetworkPacket)definition.getCodec().decode(buffer);
        return this.handleServerPacket(definition, packet, ctx);
    }

    public <T extends NetworkPacket, B extends ByteBuf> boolean handleServerPacket(@NotNull PacketDefinition<T, B> definition, @NotNull T packet, SERVER ctx) {
        Intrinsics.checkNotNullParameter(definition, (String)"definition");
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        List<NetworkHandler<SERVER, NetworkPacket>> list = this.serverHandlers.get(definition);
        if (list == null) {
            return false;
        }
        List<NetworkHandler<SERVER, NetworkPacket>> handlers = list;
        for (NetworkHandler<SERVER, NetworkPacket> handler : handlers) {
            handler.handle(packet, ctx);
        }
        return true;
    }

    @Nullable
    public <B extends ByteBuf> PacketDefinition<? extends NetworkPacket, B> getClientboundDefinition(@NotNull String path) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Iterable $this$firstOrNull$iv = this.clientboundPackets;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PacketDefinition it = (PacketDefinition)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)path)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public <B extends ByteBuf> PacketDefinition<? extends NetworkPacket, B> getServerboundDefinition(@NotNull String path) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Iterable $this$firstOrNull$iv = this.serverboundPackets;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PacketDefinition it = (PacketDefinition)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)path)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final List addClientboundHandler$lambda$0(PacketDefinition packetDefinition) {
        Intrinsics.checkNotNullParameter((Object)packetDefinition, (String)"<unused var>");
        return new ArrayList();
    }

    private static final List addClientboundHandler$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final List addServerboundHandler$lambda$0(PacketDefinition packetDefinition) {
        Intrinsics.checkNotNullParameter((Object)packetDefinition, (String)"<unused var>");
        return new ArrayList();
    }

    private static final List addServerboundHandler$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00e6\u0080\u0001\u0018\u0000*\u0004\b\u0002\u0010\u0001*\b\b\u0003\u0010\u0003*\u00020\u00022\u00020\u0004J\u001f\u0010\b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00028\u00032\u0006\u0010\u0006\u001a\u00028\u0002H&\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\n\u00c0\u0006\u0003"}, d2={"Lxyz/bluspring/modernnetworking/api/AbstractNetworkRegistry$NetworkHandler;", "C", "Lxyz/bluspring/modernnetworking/api/NetworkPacket;", "T", "", "packet", "ctx", "", "handle", "(Lxyz/bluspring/modernnetworking/api/NetworkPacket;Ljava/lang/Object;)V", "modernnetworking-api"})
    public static interface NetworkHandler<C, T extends NetworkPacket> {
        public void handle(@NotNull T var1, C var2);
    }
}

