/*
 * Decompiled with CFR 0.152.
 */
package xyz.bluspring.modernnetworking.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u001a\u0011\u0010\u0002\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0019\u0010\u0006\u001a\u00020\u0005*\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u0011\u0010\t\u001a\u00020\b*\u00020\u0000\u00a2\u0006\u0004\b\t\u0010\n\u001a\u0019\u0010\u000b\u001a\u00020\u0005*\u00020\u00002\u0006\u0010\u0004\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\f\u001a\u001b\u0010\u000f\u001a\u00020\u000e*\u00020\u00002\b\b\u0002\u0010\r\u001a\u00020\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a#\u0010\u0012\u001a\u00020\u0005*\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u000e2\b\b\u0002\u0010\r\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a\u0019\u0010\u0016\u001a\u00020\u0005*\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017\u001a\u0011\u0010\u0019\u001a\u00020\u0018*\u00020\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001a\u001a\u0019\u0010\u001c\u001a\u00020\u0005*\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001c\u0010\u001d\u001a\u001b\u0010\u001f\u001a\u00020\u001e*\u00020\u00002\b\b\u0002\u0010\r\u001a\u00020\u0001\u00a2\u0006\u0004\b\u001f\u0010 \u001a\u0019\u0010\"\u001a\u00020\u0005*\u00020\u00002\u0006\u0010!\u001a\u00020\u001e\u00a2\u0006\u0004\b\"\u0010#\u001a\u0019\u0010&\u001a\u00020%*\u00020\u00002\u0006\u0010$\u001a\u00020\u0001\u00a2\u0006\u0004\b&\u0010'\u001a!\u0010)\u001a\u00020\u0005*\u00020\u00002\u0006\u0010(\u001a\u00020%2\u0006\u0010$\u001a\u00020\u0001\u00a2\u0006\u0004\b)\u0010*\u001a=\u00101\u001a\u00020\u0005\"\u000e\b\u0000\u0010,*\b\u0012\u0004\u0012\u00028\u00000+*\u00020\u00002\f\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00000-2\f\u00100\u001a\b\u0012\u0004\u0012\u00028\u00000/\u00a2\u0006\u0004\b1\u00102\u001a5\u00103\u001a\b\u0012\u0004\u0012\u00028\u00000-\"\u000e\b\u0000\u0010,*\b\u0012\u0004\u0012\u00028\u00000+*\u00020\u00002\f\u00100\u001a\b\u0012\u0004\u0012\u00028\u00000/\u00a2\u0006\u0004\b3\u00104\"\u0014\u00105\u001a\u00020\u00018\u0000X\u0080T\u00a2\u0006\u0006\n\u0004\b5\u00106\"\u0014\u00107\u001a\u00020\u00018\u0000X\u0080T\u00a2\u0006\u0006\n\u0004\b7\u00106\u00a8\u00068"}, d2={"Lio/netty/buffer/ByteBuf;", "", "readVarInt", "(Lio/netty/buffer/ByteBuf;)I", "value", "", "writeVarInt", "(Lio/netty/buffer/ByteBuf;I)V", "", "readVarLong", "(Lio/netty/buffer/ByteBuf;)J", "writeVarLong", "(Lio/netty/buffer/ByteBuf;J)V", "maxLength", "", "readUtf", "(Lio/netty/buffer/ByteBuf;I)Ljava/lang/String;", "text", "writeUtf", "(Lio/netty/buffer/ByteBuf;Ljava/lang/String;I)V", "", "byte", "writeByteActual", "(Lio/netty/buffer/ByteBuf;B)V", "Ljava/util/UUID;", "readUUID", "(Lio/netty/buffer/ByteBuf;)Ljava/util/UUID;", "uuid", "writeUUID", "(Lio/netty/buffer/ByteBuf;Ljava/util/UUID;)V", "", "readByteArray", "(Lio/netty/buffer/ByteBuf;I)[B", "byteArray", "writeByteArray", "(Lio/netty/buffer/ByteBuf;[B)V", "size", "Ljava/util/BitSet;", "readFixedBitSet", "(Lio/netty/buffer/ByteBuf;I)Ljava/util/BitSet;", "bitSet", "writeFixedBitSet", "(Lio/netty/buffer/ByteBuf;Ljava/util/BitSet;I)V", "", "E", "Ljava/util/EnumSet;", "enumSet", "Ljava/lang/Class;", "enumClass", "writeEnumSet", "(Lio/netty/buffer/ByteBuf;Ljava/util/EnumSet;Ljava/lang/Class;)V", "readEnumSet", "(Lio/netty/buffer/ByteBuf;Ljava/lang/Class;)Ljava/util/EnumSet;", "SEGMENT_BITS", "I", "CONTINUE_BIT", "modernnetworking-api"})
public final class ByteBufExtensionsKt {
    public static final int SEGMENT_BITS = 127;
    public static final int CONTINUE_BIT = 128;

    public static final int readVarInt(@NotNull ByteBuf $this$readVarInt) {
        int value;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$readVarInt, (String)"<this>");
            value = 0;
            int position = 0;
            do {
                byte currentByte = $this$readVarInt.readByte();
                value |= (byte)(currentByte & 0x7F) << position;
                if ((byte)(currentByte & 0xFFFFFF80) == 0) break block1;
            } while ((position += 7) < 32);
            throw new RuntimeException("VarInt too big!");
        }
        return value;
    }

    public static final void writeVarInt(@NotNull ByteBuf $this$writeVarInt, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$writeVarInt, (String)"<this>");
        int value2 = value;
        while (true) {
            if ((value2 & 0xFFFFFF80) == 0) {
                $this$writeVarInt.writeByte(value2);
                return;
            }
            $this$writeVarInt.writeByte(value2 & 0x7F | 0x80);
            value2 >>>= 7;
        }
    }

    public static final long readVarLong(@NotNull ByteBuf $this$readVarLong) {
        long value;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$readVarLong, (String)"<this>");
            value = 0L;
            int position = 0;
            do {
                byte currentByte = $this$readVarLong.readByte();
                value |= (long)((byte)(currentByte & 0x7F)) << position;
                if ((long)((byte)(currentByte & 0xFFFFFF80)) == 0L) break block1;
            } while ((position += 7) < 64);
            throw new RuntimeException("VarLong too big!");
        }
        return value;
    }

    public static final void writeVarLong(@NotNull ByteBuf $this$writeVarLong, long value) {
        Intrinsics.checkNotNullParameter((Object)$this$writeVarLong, (String)"<this>");
        long value2 = value;
        while (true) {
            if ((value2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
                $this$writeVarLong.writeByte((int)value2);
                return;
            }
            $this$writeVarLong.writeByte((int)(value2 & 0x7FL | 0x80L));
            value2 >>>= 7;
        }
    }

    @NotNull
    public static final String readUtf(@NotNull ByteBuf $this$readUtf, int maxLength) {
        Intrinsics.checkNotNullParameter((Object)$this$readUtf, (String)"<this>");
        int maxBytes = ByteBufUtil.utf8MaxBytes((int)maxLength);
        int totalLength = ByteBufExtensionsKt.readVarInt($this$readUtf);
        if (totalLength > maxBytes) {
            throw new RuntimeException("The received encoded string buffer length is longer than maximum allowed (" + totalLength + " > " + maxBytes + ')');
        }
        if (totalLength < 0) {
            throw new RuntimeException("The received encoded string buffer length is less than zero! Weird string!");
        }
        int readable = $this$readUtf.readableBytes();
        if (totalLength > readable) {
            throw new RuntimeException("Not enough bytes in buffer, expected " + totalLength + " but got " + readable + '!');
        }
        String string = $this$readUtf.toString($this$readUtf.readerIndex(), totalLength, Charsets.UTF_8);
        $this$readUtf.readerIndex($this$readUtf.readerIndex() + totalLength);
        if (string.length() > maxLength) {
            throw new RuntimeException("The received string length is longer than maximum allowed (" + string.length() + " > " + maxLength + ')');
        }
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    public static /* synthetic */ String readUtf$default(ByteBuf byteBuf, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = Short.MAX_VALUE;
        }
        return ByteBufExtensionsKt.readUtf(byteBuf, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeUtf(@NotNull ByteBuf $this$writeUtf, @NotNull String text, int maxLength) {
        Intrinsics.checkNotNullParameter((Object)$this$writeUtf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (text.length() > maxLength) {
            throw new RuntimeException("String too big (was " + text.length() + " characters, max " + maxLength + ')');
        }
        int maxBytes = ByteBufUtil.utf8MaxBytes((CharSequence)text);
        ByteBuf byteBuf = $this$writeUtf.alloc().buffer(maxBytes);
        try {
            int written = ByteBufUtil.writeUtf8((ByteBuf)byteBuf, (CharSequence)text);
            int max = ByteBufUtil.utf8MaxBytes((int)maxLength);
            if (written > max) {
                throw new RuntimeException("String too big (was " + written + " bytes encoded, max " + max + ')');
            }
            ByteBufExtensionsKt.writeVarInt($this$writeUtf, written);
            $this$writeUtf.writeBytes(byteBuf);
        }
        finally {
            byteBuf.release();
        }
    }

    public static /* synthetic */ void writeUtf$default(ByteBuf byteBuf, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Short.MAX_VALUE;
        }
        ByteBufExtensionsKt.writeUtf(byteBuf, string, n);
    }

    public static final void writeByteActual(@NotNull ByteBuf $this$writeByteActual, byte by) {
        Intrinsics.checkNotNullParameter((Object)$this$writeByteActual, (String)"<this>");
        $this$writeByteActual.writeByte((int)by);
    }

    @NotNull
    public static final UUID readUUID(@NotNull ByteBuf $this$readUUID) {
        Intrinsics.checkNotNullParameter((Object)$this$readUUID, (String)"<this>");
        return new UUID($this$readUUID.readLong(), $this$readUUID.readLong());
    }

    public static final void writeUUID(@NotNull ByteBuf $this$writeUUID, @NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)$this$writeUUID, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        $this$writeUUID.writeLong(uuid.getMostSignificantBits());
        $this$writeUUID.writeLong(uuid.getLeastSignificantBits());
    }

    @NotNull
    public static final byte[] readByteArray(@NotNull ByteBuf $this$readByteArray, int maxLength) {
        Intrinsics.checkNotNullParameter((Object)$this$readByteArray, (String)"<this>");
        int length = ByteBufExtensionsKt.readVarInt($this$readByteArray);
        if (length > maxLength) {
            throw new RuntimeException("ByteArray with size " + length + " is bigger than allowed " + maxLength + '!');
        }
        byte[] byteArray = new byte[length];
        $this$readByteArray.readBytes(byteArray);
        return byteArray;
    }

    public static /* synthetic */ byte[] readByteArray$default(ByteBuf byteBuf, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = byteBuf.readableBytes();
        }
        return ByteBufExtensionsKt.readByteArray(byteBuf, n);
    }

    public static final void writeByteArray(@NotNull ByteBuf $this$writeByteArray, @NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter((Object)$this$writeByteArray, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        ByteBufExtensionsKt.writeVarInt($this$writeByteArray, byteArray.length);
        $this$writeByteArray.writeBytes(byteArray);
    }

    @NotNull
    public static final BitSet readFixedBitSet(@NotNull ByteBuf $this$readFixedBitSet, int size) {
        Intrinsics.checkNotNullParameter((Object)$this$readFixedBitSet, (String)"<this>");
        byte[] bytes = new byte[-Math.floorDiv(-size, 8)];
        $this$readFixedBitSet.readBytes(bytes);
        BitSet bitSet = BitSet.valueOf(bytes);
        Intrinsics.checkNotNullExpressionValue((Object)bitSet, (String)"valueOf(...)");
        return bitSet;
    }

    public static final void writeFixedBitSet(@NotNull ByteBuf $this$writeFixedBitSet, @NotNull BitSet bitSet, int size) {
        Intrinsics.checkNotNullParameter((Object)$this$writeFixedBitSet, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)bitSet, (String)"bitSet");
        if (bitSet.length() > size) {
            throw new IndexOutOfBoundsException("BitSet is larger than expected size (" + bitSet.length() + " > " + size + ')');
        }
        byte[] bytes = bitSet.toByteArray();
        Intrinsics.checkNotNull((Object)bytes);
        byte[] byArray = Arrays.copyOf(bytes, -Math.floorDiv(-size, 8));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        $this$writeFixedBitSet.writeBytes(byArray);
    }

    public static final <E extends Enum<E>> void writeEnumSet(@NotNull ByteBuf $this$writeEnumSet, @NotNull EnumSet<E> enumSet, @NotNull Class<E> enumClass) {
        Intrinsics.checkNotNullParameter((Object)$this$writeEnumSet, (String)"<this>");
        Intrinsics.checkNotNullParameter(enumSet, (String)"enumSet");
        Intrinsics.checkNotNullParameter(enumClass, (String)"enumClass");
        Enum[] enums = (Enum[])enumClass.getEnumConstants();
        BitSet bitSet = new BitSet(enums.length);
        Intrinsics.checkNotNull((Object)enums);
        Enum[] enumArray = enums;
        int n = enumArray.length;
        for (int i = 0; i < n; ++i) {
            int i2 = i;
            Enum e = enumArray[i];
            bitSet.set(i2, enumSet.contains(e));
        }
        ByteBufExtensionsKt.writeFixedBitSet($this$writeEnumSet, bitSet, enums.length);
    }

    @NotNull
    public static final <E extends Enum<E>> EnumSet<E> readEnumSet(@NotNull ByteBuf $this$readEnumSet, @NotNull Class<E> enumClass) {
        Intrinsics.checkNotNullParameter((Object)$this$readEnumSet, (String)"<this>");
        Intrinsics.checkNotNullParameter(enumClass, (String)"enumClass");
        Enum[] enums = (Enum[])enumClass.getEnumConstants();
        BitSet bitSet = ByteBufExtensionsKt.readFixedBitSet($this$readEnumSet, enums.length);
        EnumSet<Enum> enumSet = EnumSet.noneOf(enumClass);
        Intrinsics.checkNotNull((Object)enums);
        Enum[] enumArray = enums;
        int n = enumArray.length;
        for (int i = 0; i < n; ++i) {
            int i2 = i;
            Enum e = enumArray[i];
            if (!bitSet.get(i2)) continue;
            enumSet.add(e);
        }
        Intrinsics.checkNotNull(enumSet);
        return enumSet;
    }
}

