/*
 * Decompiled with CFR 0.152.
 */
package xyz.bluspring.modernnetworking.api;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.bluspring.modernnetworking.api.NetworkCodec;
import xyz.bluspring.modernnetworking.api.NetworkPacket;
import xyz.bluspring.modernnetworking.api.PacketDefinition;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u00012B\u0011\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007JF\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u001b0\f\"\b\b\u0002\u0010\u001a*\u00020\r\"\b\b\u0003\u0010\u001b*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00052\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u0002H\u001a\u0012\u0006\b\u0000\u0012\u0002H\u001b0\u001fH\u0016J<\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u001b0\f\"\b\b\u0002\u0010\u001a*\u00020\r\"\b\b\u0003\u0010\u001b*\u00020\u001c2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u001b0\fH\u0016JF\u0010!\u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u001b0\f\"\b\b\u0002\u0010\u001a*\u00020\r\"\b\b\u0003\u0010\u001b*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00052\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u0002H\u001a\u0012\u0006\b\u0000\u0012\u0002H\u001b0\u001fH\u0016J<\u0010!\u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u001b0\f\"\b\b\u0002\u0010\u001a*\u00020\r\"\b\b\u0003\u0010\u001b*\u00020\u001c2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u001b0\fH\u0016JF\u0010\"\u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u001b0\f\"\b\b\u0002\u0010\u001a*\u00020\r\"\b\b\u0003\u0010\u001b*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00052\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u0002H\u001a\u0012\u0006\b\u0000\u0012\u0002H\u001b0\u001fH\u0016J<\u0010\"\u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u001b0\f\"\b\b\u0002\u0010\u001a*\u00020\r\"\b\b\u0003\u0010\u001b*\u00020\u001c2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u001b0\fH\u0016JD\u0010#\u001a\u00020$\"\b\b\u0002\u0010\u001a*\u00020\r\"\b\b\u0003\u0010\u001b*\u00020\u001c2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u001b0\f2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u001a0\u0014H\u0016JD\u0010&\u001a\u00020$\"\b\b\u0002\u0010\u001a*\u00020\r\"\b\b\u0003\u0010\u001b*\u00020\u001c2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u001b0\f2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u0002H\u001a0\u0014H\u0016JE\u0010'\u001a\u00020(\"\b\b\u0002\u0010\u001a*\u00020\r\"\b\b\u0003\u0010\u001b*\u00020\u001c2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u001b0\f2\u0006\u0010)\u001a\u0002H\u001b2\u0006\u0010*\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010+JE\u0010'\u001a\u00020(\"\b\b\u0002\u0010\u001a*\u00020\r\"\b\b\u0003\u0010\u001b*\u00020\u001c2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u001b0\f2\u0006\u0010,\u001a\u0002H\u001a2\u0006\u0010*\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010-JE\u0010.\u001a\u00020(\"\b\b\u0002\u0010\u001a*\u00020\r\"\b\b\u0003\u0010\u001b*\u00020\u001c2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u001b0\f2\u0006\u0010)\u001a\u0002H\u001b2\u0006\u0010*\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010+JE\u0010.\u001a\u00020(\"\b\b\u0002\u0010\u001a*\u00020\r\"\b\b\u0003\u0010\u001b*\u00020\u001c2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u001b0\f2\u0006\u0010,\u001a\u0002H\u001a2\u0006\u0010*\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010-J*\u0010/\u001a\u0012\u0012\u0006\b\u0001\u0012\u00020\r\u0012\u0004\u0012\u0002H\u001b\u0018\u00010\f\"\b\b\u0002\u0010\u001b*\u00020\u001c2\u0006\u00100\u001a\u00020\u0005H\u0016J*\u00101\u001a\u0012\u0012\u0006\b\u0001\u0012\u00020\r\u0012\u0004\u0012\u0002H\u001b\u0018\u00010\f\"\b\b\u0002\u0010\u001b*\u00020\u001c2\u0006\u00100\u001a\u00020\u0005H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR&\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\r\u0012\u0002\b\u00030\f0\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR&\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\r\u0012\u0002\b\u00030\f0\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR@\u0010\u0012\u001a.\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\r\u0012\u0002\b\u00030\f\u0012\u0018\u0012\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u00020\r0\u00140\u000b0\u0013X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R@\u0010\u0017\u001a.\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\r\u0012\u0002\b\u00030\f\u0012\u0018\u0012\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0001\u0012\u0006\b\u0001\u0012\u00020\r0\u00140\u000b0\u0013X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016\u00a8\u00063"}, d2={"Lxyz/bluspring/modernnetworking/api/AbstractNetworkRegistry;", "CLIENT", "SERVER", "", "namespace", "", "<init>", "(Ljava/lang/String;)V", "getNamespace", "()Ljava/lang/String;", "clientboundPackets", "", "Lxyz/bluspring/modernnetworking/api/PacketDefinition;", "Lxyz/bluspring/modernnetworking/api/NetworkPacket;", "getClientboundPackets", "()Ljava/util/List;", "serverboundPackets", "getServerboundPackets", "clientHandlers", "", "Lxyz/bluspring/modernnetworking/api/AbstractNetworkRegistry$NetworkHandler;", "getClientHandlers", "()Ljava/util/Map;", "serverHandlers", "getServerHandlers", "registerClientbound", "T", "B", "Lio/netty/buffer/ByteBuf;", "id", "codec", "Lxyz/bluspring/modernnetworking/api/NetworkCodec;", "definition", "registerServerbound", "registerDual", "addClientboundHandler", "", "handler", "addServerboundHandler", "handleClientPacket", "", "buffer", "ctx", "(Lxyz/bluspring/modernnetworking/api/PacketDefinition;Lio/netty/buffer/ByteBuf;Ljava/lang/Object;)Z", "packet", "(Lxyz/bluspring/modernnetworking/api/PacketDefinition;Lxyz/bluspring/modernnetworking/api/NetworkPacket;Ljava/lang/Object;)Z", "handleServerPacket", "getClientboundDefinition", "path", "getServerboundDefinition", "NetworkHandler", "modernnetworking-api"})
@SourceDebugExtension(value={"SMAP\nAbstractNetworkRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractNetworkRegistry.kt\nxyz/bluspring/modernnetworking/api/AbstractNetworkRegistry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n1761#2,3:137\n1761#2,3:140\n1761#2,3:143\n1761#2,3:146\n295#2,2:149\n295#2,2:151\n*S KotlinDebug\n*F\n+ 1 AbstractNetworkRegistry.kt\nxyz/bluspring/modernnetworking/api/AbstractNetworkRegistry\n*L\n19#1:137,3\n30#1:140,3\n41#1:143,3\n52#1:146,3\n126#1:149,2\n130#1:151,2\n*E\n"})
public abstract class AbstractNetworkRegistry<CLIENT, SERVER> {
    @NotNull
    private final String namespace;
    @NotNull
    private final List<PacketDefinition<? extends NetworkPacket, ?>> clientboundPackets;
    @NotNull
    private final List<PacketDefinition<? extends NetworkPacket, ?>> serverboundPackets;
    @NotNull
    private final Map<PacketDefinition<? extends NetworkPacket, ?>, List<NetworkHandler<CLIENT, ? extends NetworkPacket>>> clientHandlers;
    @NotNull
    private final Map<PacketDefinition<? extends NetworkPacket, ?>, List<NetworkHandler<SERVER, ? extends NetworkPacket>>> serverHandlers;

    protected AbstractNetworkRegistry(@NotNull String namespace) {
        Intrinsics.checkNotNullParameter(namespace, "namespace");
        this.namespace = namespace;
        this.clientboundPackets = new ArrayList();
        this.serverboundPackets = new ArrayList();
        this.clientHandlers = new LinkedHashMap();
        this.serverHandlers = new LinkedHashMap();
    }

    @NotNull
    public final String getNamespace() {
        return this.namespace;
    }

    @NotNull
    protected final List<PacketDefinition<? extends NetworkPacket, ?>> getClientboundPackets() {
        return this.clientboundPackets;
    }

    @NotNull
    protected final List<PacketDefinition<? extends NetworkPacket, ?>> getServerboundPackets() {
        return this.serverboundPackets;
    }

    @NotNull
    protected final Map<PacketDefinition<? extends NetworkPacket, ?>, List<NetworkHandler<CLIENT, ? extends NetworkPacket>>> getClientHandlers() {
        return this.clientHandlers;
    }

    @NotNull
    protected final Map<PacketDefinition<? extends NetworkPacket, ?>, List<NetworkHandler<SERVER, ? extends NetworkPacket>>> getServerHandlers() {
        return this.serverHandlers;
    }

    @NotNull
    public <T extends NetworkPacket, B extends ByteBuf> PacketDefinition<T, B> registerClientbound(@NotNull String id, @NotNull NetworkCodec<T, ? super B> codec) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(id, "id");
            Intrinsics.checkNotNullParameter(codec, "codec");
            Iterable $this$any$iv = this.clientboundPackets;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PacketDefinition it = (PacketDefinition)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual(it.getNamespace(), this.namespace) && Intrinsics.areEqual(it.getId(), id))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new IllegalArgumentException("Clientbound packet " + id + " already exists!");
        }
        PacketDefinition<T, ? super B> definition = new PacketDefinition<T, B>(this.namespace, id, codec);
        return this.registerClientbound(definition);
    }

    @NotNull
    public <T extends NetworkPacket, B extends ByteBuf> PacketDefinition<T, B> registerClientbound(@NotNull PacketDefinition<T, B> definition) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(definition, "definition");
            Iterable $this$any$iv = this.clientboundPackets;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PacketDefinition it = (PacketDefinition)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual(it.getNamespace(), definition.getNamespace()) && Intrinsics.areEqual(it.getId(), definition.getId()))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new IllegalArgumentException("Clientbound packet " + definition.getNamespace() + ':' + definition.getId() + " already exists!");
        }
        this.clientboundPackets.add(definition);
        return definition;
    }

    @NotNull
    public <T extends NetworkPacket, B extends ByteBuf> PacketDefinition<T, B> registerServerbound(@NotNull String id, @NotNull NetworkCodec<T, ? super B> codec) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(id, "id");
            Intrinsics.checkNotNullParameter(codec, "codec");
            Iterable $this$any$iv = this.serverboundPackets;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PacketDefinition it = (PacketDefinition)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual(it.getNamespace(), this.namespace) && Intrinsics.areEqual(it.getId(), id))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new IllegalArgumentException("Serverbound packet " + id + " already exists!");
        }
        PacketDefinition<T, ? super B> definition = new PacketDefinition<T, B>(this.namespace, id, codec);
        return this.registerServerbound(definition);
    }

    @NotNull
    public <T extends NetworkPacket, B extends ByteBuf> PacketDefinition<T, B> registerServerbound(@NotNull PacketDefinition<T, B> definition) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(definition, "definition");
            Iterable $this$any$iv = this.clientboundPackets;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PacketDefinition it = (PacketDefinition)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual(it.getNamespace(), definition.getNamespace()) && Intrinsics.areEqual(it.getId(), definition.getId()))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new IllegalArgumentException("Serverbound packet " + definition.getNamespace() + ':' + definition.getId() + " already exists!");
        }
        this.serverboundPackets.add(definition);
        return definition;
    }

    @NotNull
    public <T extends NetworkPacket, B extends ByteBuf> PacketDefinition<T, B> registerDual(@NotNull String id, @NotNull NetworkCodec<T, ? super B> codec) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(codec, "codec");
        return this.registerClientbound(this.registerServerbound(id, codec));
    }

    @NotNull
    public <T extends NetworkPacket, B extends ByteBuf> PacketDefinition<T, B> registerDual(@NotNull PacketDefinition<T, B> definition) {
        Intrinsics.checkNotNullParameter(definition, "definition");
        return this.registerClientbound(this.registerServerbound(definition));
    }

    public <T extends NetworkPacket, B extends ByteBuf> void addClientboundHandler(@NotNull PacketDefinition<T, B> definition, @NotNull NetworkHandler<CLIENT, T> handler) {
        Intrinsics.checkNotNullParameter(definition, "definition");
        Intrinsics.checkNotNullParameter(handler, "handler");
        this.clientHandlers.computeIfAbsent(definition, arg_0 -> AbstractNetworkRegistry.addClientboundHandler$lambda$1(AbstractNetworkRegistry::addClientboundHandler$lambda$0, arg_0)).add(handler);
    }

    public <T extends NetworkPacket, B extends ByteBuf> void addServerboundHandler(@NotNull PacketDefinition<T, B> definition, @NotNull NetworkHandler<SERVER, T> handler) {
        Intrinsics.checkNotNullParameter(definition, "definition");
        Intrinsics.checkNotNullParameter(handler, "handler");
        this.serverHandlers.computeIfAbsent(definition, arg_0 -> AbstractNetworkRegistry.addServerboundHandler$lambda$1(AbstractNetworkRegistry::addServerboundHandler$lambda$0, arg_0)).add(handler);
    }

    public <T extends NetworkPacket, B extends ByteBuf> boolean handleClientPacket(@NotNull PacketDefinition<T, B> definition, @NotNull B buffer, CLIENT ctx) {
        Intrinsics.checkNotNullParameter(definition, "definition");
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        NetworkPacket packet = (NetworkPacket)definition.getCodec().decode(buffer);
        return this.handleClientPacket(definition, packet, ctx);
    }

    public <T extends NetworkPacket, B extends ByteBuf> boolean handleClientPacket(@NotNull PacketDefinition<T, B> definition, @NotNull T packet, CLIENT ctx) {
        Intrinsics.checkNotNullParameter(definition, "definition");
        Intrinsics.checkNotNullParameter(packet, "packet");
        List<NetworkHandler<CLIENT, NetworkPacket>> list = this.clientHandlers.get(definition);
        if (list == null) {
            return false;
        }
        List<NetworkHandler<CLIENT, NetworkPacket>> handlers = list;
        for (NetworkHandler<CLIENT, NetworkPacket> handler : handlers) {
            handler.handle(packet, ctx);
        }
        return true;
    }

    public <T extends NetworkPacket, B extends ByteBuf> boolean handleServerPacket(@NotNull PacketDefinition<T, B> definition, @NotNull B buffer, SERVER ctx) {
        Intrinsics.checkNotNullParameter(definition, "definition");
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        NetworkPacket packet = (NetworkPacket)definition.getCodec().decode(buffer);
        return this.handleServerPacket(definition, packet, ctx);
    }

    public <T extends NetworkPacket, B extends ByteBuf> boolean handleServerPacket(@NotNull PacketDefinition<T, B> definition, @NotNull T packet, SERVER ctx) {
        Intrinsics.checkNotNullParameter(definition, "definition");
        Intrinsics.checkNotNullParameter(packet, "packet");
        List<NetworkHandler<SERVER, NetworkPacket>> list = this.serverHandlers.get(definition);
        if (list == null) {
            return false;
        }
        List<NetworkHandler<SERVER, NetworkPacket>> handlers = list;
        for (NetworkHandler<SERVER, NetworkPacket> handler : handlers) {
            handler.handle(packet, ctx);
        }
        return true;
    }

    @Nullable
    public <B extends ByteBuf> PacketDefinition<? extends NetworkPacket, B> getClientboundDefinition(@NotNull String path) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(path, "path");
            Iterable $this$firstOrNull$iv = this.clientboundPackets;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PacketDefinition it = (PacketDefinition)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getId(), path)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public <B extends ByteBuf> PacketDefinition<? extends NetworkPacket, B> getServerboundDefinition(@NotNull String path) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(path, "path");
            Iterable $this$firstOrNull$iv = this.serverboundPackets;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PacketDefinition it = (PacketDefinition)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getId(), path)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final List addClientboundHandler$lambda$0(PacketDefinition packetDefinition) {
        Intrinsics.checkNotNullParameter(packetDefinition, "<unused var>");
        return new ArrayList();
    }

    private static final List addClientboundHandler$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final List addServerboundHandler$lambda$0(PacketDefinition packetDefinition) {
        Intrinsics.checkNotNullParameter(packetDefinition, "<unused var>");
        return new ArrayList();
    }

    private static final List addServerboundHandler$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00e6\u0080\u0001\u0018\u0000*\u0004\b\u0002\u0010\u0001*\b\b\u0003\u0010\u0002*\u00020\u00032\u00020\u0004J\u001d\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u00032\u0006\u0010\b\u001a\u00028\u0002H&\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n\u00c0\u0006\u0003"}, d2={"Lxyz/bluspring/modernnetworking/api/AbstractNetworkRegistry$NetworkHandler;", "C", "T", "Lxyz/bluspring/modernnetworking/api/NetworkPacket;", "", "handle", "", "packet", "ctx", "(Lxyz/bluspring/modernnetworking/api/NetworkPacket;Ljava/lang/Object;)V", "modernnetworking-api"})
    public static interface NetworkHandler<C, T extends NetworkPacket> {
        public void handle(@NotNull T var1, C var2);
    }
}

