/*
 * Decompiled with CFR 0.152.
 */
package xyz.bluspring.modernnetworking.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.ChannelMessageSink;
import com.velocitypowered.api.proxy.messages.ChannelMessageSource;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import xyz.bluspring.modernnetworking.api.PacketDefinition;
import xyz.bluspring.modernnetworking.velocity.api.RegisterNetworkRegistryEvent;
import xyz.bluspring.modernnetworking.velocity.api.VelocityNetworkContext;
import xyz.bluspring.modernnetworking.velocity.api.VelocityNetworkRegistry;

@Plugin(id="modernnetworking", name="ModernNetworking", version="1.2.4", description="Multiversioned and multiloader network packet API based on 1.20.6+'s method of packets.", url="https://github.com/BluSpring/ModernNetworking", authors={"BluSpring"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lxyz/bluspring/modernnetworking/velocity/ModernNetworkingVelocity;", "", "proxy", "Lcom/velocitypowered/api/proxy/ProxyServer;", "<init>", "(Lcom/velocitypowered/api/proxy/ProxyServer;)V", "getProxy", "()Lcom/velocitypowered/api/proxy/ProxyServer;", "onProxyInitialization", "", "event", "Lcom/velocitypowered/api/event/proxy/ProxyInitializeEvent;", "onPluginMessage", "Lcom/velocitypowered/api/event/connection/PluginMessageEvent;", "modernnetworking-velocity"})
public final class ModernNetworkingVelocity {
    @NotNull
    private final ProxyServer proxy;

    @Inject
    public ModernNetworkingVelocity(@NotNull ProxyServer proxy) {
        Intrinsics.checkNotNullParameter(proxy, "proxy");
        this.proxy = proxy;
    }

    @NotNull
    public final ProxyServer getProxy() {
        return this.proxy;
    }

    @Subscribe
    public final void onProxyInitialization(@NotNull ProxyInitializeEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.proxy.getEventManager().fireAndForget((Object)new RegisterNetworkRegistryEvent(this.proxy));
    }

    @Subscribe
    public final void onPluginMessage(@NotNull PluginMessageEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        ChannelIdentifier identifier = event.getIdentifier();
        if (!(identifier instanceof MinecraftChannelIdentifier)) {
            return;
        }
        String string = ((MinecraftChannelIdentifier)identifier).getNamespace();
        Intrinsics.checkNotNullExpressionValue(string, "getNamespace(...)");
        VelocityNetworkRegistry velocityNetworkRegistry = VelocityNetworkRegistry.Companion.get(string);
        if (velocityNetworkRegistry == null) {
            return;
        }
        VelocityNetworkRegistry registry = velocityNetworkRegistry;
        if (event.getSource() instanceof Player && event.getTarget() instanceof ServerConnection) {
            String string2 = ((MinecraftChannelIdentifier)identifier).getName();
            Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
            PacketDefinition packetDefinition = registry.getServerboundDefinition(string2);
            if (packetDefinition == null) {
                return;
            }
            PacketDefinition definition = packetDefinition;
            ByteBuf buffer = Unpooled.buffer();
            if (event.getData() != null) {
                buffer.writeBytes(event.getData());
            }
            Intrinsics.checkNotNull(buffer);
            ChannelMessageSource channelMessageSource = event.getSource();
            Intrinsics.checkNotNull(channelMessageSource, "null cannot be cast to non-null type com.velocitypowered.api.proxy.Player");
            Player player = (Player)channelMessageSource;
            ChannelMessageSink channelMessageSink = event.getTarget();
            Intrinsics.checkNotNull(channelMessageSink, "null cannot be cast to non-null type com.velocitypowered.api.proxy.ServerConnection");
            registry.handleServerPacket(definition, buffer, new VelocityNetworkContext(player, this.proxy, (ServerConnection)channelMessageSink));
            event.setResult(PluginMessageEvent.ForwardResult.handled());
        } else if (event.getSource() instanceof ServerConnection && event.getTarget() instanceof Player) {
            String string3 = ((MinecraftChannelIdentifier)identifier).getName();
            Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
            PacketDefinition packetDefinition = registry.getClientboundDefinition(string3);
            if (packetDefinition == null) {
                return;
            }
            PacketDefinition definition = packetDefinition;
            ByteBuf buffer = Unpooled.buffer();
            if (event.getData() != null) {
                buffer.writeBytes(event.getData());
            }
            Intrinsics.checkNotNull(buffer);
            ChannelMessageSink channelMessageSink = event.getTarget();
            Intrinsics.checkNotNull(channelMessageSink, "null cannot be cast to non-null type com.velocitypowered.api.proxy.Player");
            Player player = (Player)channelMessageSink;
            ChannelMessageSource channelMessageSource = event.getSource();
            Intrinsics.checkNotNull(channelMessageSource, "null cannot be cast to non-null type com.velocitypowered.api.proxy.ServerConnection");
            registry.handleClientPacket(definition, buffer, new VelocityNetworkContext(player, this.proxy, (ServerConnection)channelMessageSource));
            event.setResult(PluginMessageEvent.ForwardResult.handled());
        }
    }
}

