/*
 * Decompiled with CFR 0.152.
 */
package xyz.bluspring.modernnetworking.api;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import xyz.bluspring.modernnetworking.api.NetworkCodec;
import xyz.bluspring.modernnetworking.api.NetworkCodecs;
import xyz.bluspring.modernnetworking.internal.ByteBufExtensionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ9\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0006\"\u000e\b\u0000\u0010\f*\b\u0012\u0004\u0012\u00028\u00000\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J?\u0010\u0013\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0012\u0012\u0004\u0012\u00020\b0\u0006\"\u000e\b\u0000\u0010\f*\b\u0012\u0004\u0012\u00028\u00000\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0010J)\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0006\"\u0004\b\u0000\u0010\u00142\u0006\u0010\u0015\u001a\u00028\u0000H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017JA\u0010\u001a\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0004\u0012\u00028\u00010\u0006\"\u0004\b\u0000\u0010\u0014\"\b\b\u0001\u0010\u0018*\u00020\b2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bJE\u0010\u001d\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001c\u0012\u0004\u0012\u00028\u00010\u0006\"\u0004\b\u0000\u0010\u0014\"\b\b\u0001\u0010\u0018*\u00020\b2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006H\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001bJe\u0010#\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\"\u0012\u0004\u0012\u00028\u00000\u0006\"\b\b\u0000\u0010\u0018*\u00020\b\"\u0004\b\u0001\u0010\u001e\"\u0004\b\u0002\u0010\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00000\u00062\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00000\u0006H\u0007\u00a2\u0006\u0004\b#\u0010$R \u0010&\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\b0\u00068\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R \u0010)\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\b0\u00068\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010'R \u0010+\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020\b0\u00068\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010'R \u0010-\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020\b0\u00068\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010'R \u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u00068\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010'R \u00100\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\b0\u00068\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b0\u0010'R \u00102\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020\b0\u00068\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b2\u0010'R \u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u00068\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b3\u0010'R \u00104\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\b0\u00068\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b4\u0010'R \u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00068\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b5\u0010'R \u00107\u001a\u000e\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u00020\b0\u00068\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b7\u0010'\u00a8\u00068"}, d2={"Lxyz/bluspring/modernnetworking/api/NetworkCodecs;", "", "<init>", "()V", "", "maxLength", "Lxyz/bluspring/modernnetworking/api/NetworkCodec;", "", "Lio/netty/buffer/ByteBuf;", "stringUtf8", "(I)Lxyz/bluspring/modernnetworking/api/NetworkCodec;", "", "E", "Ljava/lang/Class;", "enumClass", "enumCodec", "(Ljava/lang/Class;)Lxyz/bluspring/modernnetworking/api/NetworkCodec;", "clazz", "Ljava/util/EnumSet;", "enumSetCodec", "T", "value", "unit", "(Ljava/lang/Object;)Lxyz/bluspring/modernnetworking/api/NetworkCodec;", "B", "original", "createNullable", "(Lxyz/bluspring/modernnetworking/api/NetworkCodec;)Lxyz/bluspring/modernnetworking/api/NetworkCodec;", "", "toList", "K", "V", "keyCodec", "valueCodec", "", "createMap", "(Lxyz/bluspring/modernnetworking/api/NetworkCodec;Lxyz/bluspring/modernnetworking/api/NetworkCodec;)Lxyz/bluspring/modernnetworking/api/NetworkCodec;", "", "BOOL", "Lxyz/bluspring/modernnetworking/api/NetworkCodec;", "", "BYTE", "", "FLOAT", "", "DOUBLE", "INT", "", "LONG", "", "BYTE_ARRAY", "VAR_INT", "VAR_LONG", "STRING_UTF8", "Ljava/util/UUID;", "UUID", "modernnetworking-api"})
public final class NetworkCodecs {
    @NotNull
    public static final NetworkCodecs INSTANCE = new NetworkCodecs();
    @JvmField
    @NotNull
    public static final NetworkCodec<Boolean, ByteBuf> BOOL = new NetworkCodec(BOOL.1.INSTANCE, BOOL.2.INSTANCE);
    @JvmField
    @NotNull
    public static final NetworkCodec<Byte, ByteBuf> BYTE = new NetworkCodec(BYTE.1.INSTANCE, BYTE.2.INSTANCE);
    @JvmField
    @NotNull
    public static final NetworkCodec<Float, ByteBuf> FLOAT = new NetworkCodec(FLOAT.1.INSTANCE, FLOAT.2.INSTANCE);
    @JvmField
    @NotNull
    public static final NetworkCodec<Double, ByteBuf> DOUBLE = new NetworkCodec(DOUBLE.1.INSTANCE, DOUBLE.2.INSTANCE);
    @JvmField
    @NotNull
    public static final NetworkCodec<Integer, ByteBuf> INT = new NetworkCodec(INT.1.INSTANCE, INT.2.INSTANCE);
    @JvmField
    @NotNull
    public static final NetworkCodec<Long, ByteBuf> LONG = new NetworkCodec(LONG.1.INSTANCE, LONG.2.INSTANCE);
    @JvmField
    @NotNull
    public static final NetworkCodec<byte[], ByteBuf> BYTE_ARRAY = new NetworkCodec(BYTE_ARRAY.1.INSTANCE, BYTE_ARRAY.2.INSTANCE);
    @JvmField
    @NotNull
    public static final NetworkCodec<Integer, ByteBuf> VAR_INT = new NetworkCodec(VAR_INT.1.INSTANCE, VAR_INT.2.INSTANCE);
    @JvmField
    @NotNull
    public static final NetworkCodec<Long, ByteBuf> VAR_LONG = new NetworkCodec(VAR_LONG.1.INSTANCE, VAR_LONG.2.INSTANCE);
    @JvmField
    @NotNull
    public static final NetworkCodec<String, ByteBuf> STRING_UTF8 = new NetworkCodec(STRING_UTF8.1.INSTANCE, STRING_UTF8.2.INSTANCE);
    @JvmField
    @NotNull
    public static final NetworkCodec<UUID, ByteBuf> UUID = new NetworkCodec(UUID.1.INSTANCE, UUID.2.INSTANCE);

    private NetworkCodecs() {
    }

    @JvmStatic
    @NotNull
    public static final NetworkCodec<String, ByteBuf> stringUtf8(int maxLength) {
        return new NetworkCodec<String, ByteBuf>((arg_0, arg_1) -> NetworkCodecs.stringUtf8$lambda$0(maxLength, arg_0, arg_1), arg_0 -> NetworkCodecs.stringUtf8$lambda$1(maxLength, arg_0));
    }

    @JvmStatic
    @NotNull
    public static final <E extends Enum<E>> NetworkCodec<E, ByteBuf> enumCodec(@NotNull Class<E> enumClass) {
        Intrinsics.checkNotNullParameter(enumClass, (String)"enumClass");
        Enum[] enumValues = (Enum[])enumClass.getEnumConstants();
        return new NetworkCodec<Enum, ByteBuf>(NetworkCodecs::enumCodec$lambda$0, arg_0 -> NetworkCodecs.enumCodec$lambda$1(enumValues, arg_0));
    }

    @JvmStatic
    @NotNull
    public static final <E extends Enum<E>> NetworkCodec<EnumSet<E>, ByteBuf> enumSetCodec(@NotNull Class<E> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return new NetworkCodec<EnumSet<E>, ByteBuf>((arg_0, arg_1) -> NetworkCodecs.enumSetCodec$lambda$0(clazz, arg_0, arg_1), arg_0 -> NetworkCodecs.enumSetCodec$lambda$1(clazz, arg_0));
    }

    @JvmStatic
    @NotNull
    public static final <T> NetworkCodec<T, ByteBuf> unit(T value) {
        return new NetworkCodec<Object, ByteBuf>(NetworkCodecs::unit$lambda$0, arg_0 -> NetworkCodecs.unit$lambda$1(value, arg_0));
    }

    @JvmStatic
    @NotNull
    public static final <T, B extends ByteBuf> NetworkCodec<T, B> createNullable(@NotNull NetworkCodec<T, B> original) {
        Intrinsics.checkNotNullParameter(original, (String)"original");
        return new NetworkCodec<Object, ByteBuf>((arg_0, arg_1) -> NetworkCodecs.createNullable$lambda$0(original, arg_0, arg_1), arg_0 -> NetworkCodecs.createNullable$lambda$1(original, arg_0));
    }

    @JvmStatic
    @NotNull
    public static final <T, B extends ByteBuf> NetworkCodec<List<T>, B> toList(@NotNull NetworkCodec<T, B> original) {
        Intrinsics.checkNotNullParameter(original, (String)"original");
        return new NetworkCodec<List, ByteBuf>((arg_0, arg_1) -> NetworkCodecs.toList$lambda$0(original, arg_0, arg_1), arg_0 -> NetworkCodecs.toList$lambda$1(original, arg_0));
    }

    @JvmStatic
    @NotNull
    public static final <B extends ByteBuf, K, V> NetworkCodec<Map<K, V>, B> createMap(@NotNull NetworkCodec<K, B> keyCodec, @NotNull NetworkCodec<V, B> valueCodec) {
        Intrinsics.checkNotNullParameter(keyCodec, (String)"keyCodec");
        Intrinsics.checkNotNullParameter(valueCodec, (String)"valueCodec");
        return new NetworkCodec<Map, ByteBuf>((arg_0, arg_1) -> NetworkCodecs.createMap$lambda$0(keyCodec, valueCodec, arg_0, arg_1), arg_0 -> NetworkCodecs.createMap$lambda$1(keyCodec, valueCodec, arg_0));
    }

    private static final void stringUtf8$lambda$0(int $maxLength, ByteBuf buf, String value) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ByteBufExtensionsKt.writeUtf(buf, value, $maxLength);
    }

    private static final String stringUtf8$lambda$1(int $maxLength, ByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        return ByteBufExtensionsKt.readUtf(buf, $maxLength);
    }

    private static final void enumCodec$lambda$0(ByteBuf buf, Enum value) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ByteBufExtensionsKt.writeVarInt(buf, value.ordinal());
    }

    private static final Enum enumCodec$lambda$1(Enum[] $enumValues, ByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Enum enum_ = $enumValues[ByteBufExtensionsKt.readVarInt(buf)];
        Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"get(...)");
        return enum_;
    }

    private static final void enumSetCodec$lambda$0(Class $clazz, ByteBuf buf, EnumSet value) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ByteBufExtensionsKt.writeEnumSet(buf, value, $clazz);
    }

    private static final EnumSet enumSetCodec$lambda$1(Class $clazz, ByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        return ByteBufExtensionsKt.readEnumSet(buf, $clazz);
    }

    private static final void unit$lambda$0(ByteBuf buf, Object value) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
    }

    private static final Object unit$lambda$1(Object $value, ByteBuf it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $value;
    }

    private static final void createNullable$lambda$0(NetworkCodec $original, ByteBuf buf, Object value) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        buf.writeBoolean(value != null);
        if (value != null) {
            $original.encode(buf, value);
        }
    }

    private static final Object createNullable$lambda$1(NetworkCodec $original, ByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        if (buf.readBoolean()) {
            return $original.decode(buf);
        }
        return null;
    }

    private static final void toList$lambda$0(NetworkCodec $original, ByteBuf buf, List values) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        ByteBufExtensionsKt.writeVarInt(buf, values.size());
        for (Object value : values) {
            $original.encode(buf, value);
        }
    }

    private static final List toList$lambda$1(NetworkCodec $original, ByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        List list = new ArrayList();
        int length = ByteBufExtensionsKt.readVarInt(buf);
        for (int i = 0; i < length; ++i) {
            list.add($original.decode(buf));
        }
        return CollectionsKt.toList((Iterable)list);
    }

    private static final void createMap$lambda$0(NetworkCodec $keyCodec, NetworkCodec $valueCodec, ByteBuf buf, Map value) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ByteBufExtensionsKt.writeVarInt(buf, value.size());
        for (Map.Entry entry : value.entrySet()) {
            Object key = entry.getKey();
            Object value2 = entry.getValue();
            $keyCodec.encode(buf, key);
            $valueCodec.encode(buf, value2);
        }
    }

    private static final Map createMap$lambda$1(NetworkCodec $keyCodec, NetworkCodec $valueCodec, ByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Map map = new LinkedHashMap();
        int length = ByteBufExtensionsKt.readVarInt(buf);
        for (int i = 0; i < length; ++i) {
            map.put($keyCodec.decode(buf), $valueCodec.decode(buf));
        }
        return map;
    }
}

