/*
 * Decompiled with CFR 0.152.
 */
package xyz.bluspring.modernnetworking.api;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import xyz.bluspring.modernnetworking.api.NetworkCodec;
import xyz.bluspring.modernnetworking.api.NetworkCodecs;
import xyz.bluspring.modernnetworking.internal.ByteBufExtensionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\u001b\u001a\u00020\u000fH\u0007J2\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u00020\u00070\u0005\"\u000e\b\u0000\u0010\u001d*\b\u0012\u0004\u0012\u0002H\u001d0\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001d0 H\u0007J8\u0010!\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001d0\"\u0012\u0004\u0012\u00020\u00070\u0005\"\u000e\b\u0000\u0010\u001d*\b\u0012\u0004\u0012\u0002H\u001d0\u001e2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\u001d0 H\u0007J'\u0010$\u001a\u000e\u0012\u0004\u0012\u0002H%\u0012\u0004\u0012\u00020\u00070\u0005\"\u0004\b\u0000\u0010%2\u0006\u0010&\u001a\u0002H%H\u0007\u00a2\u0006\u0002\u0010'J:\u0010(\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u0001H%\u0012\u0004\u0012\u0002H)0\u0005\"\u0004\b\u0000\u0010%\"\b\b\u0001\u0010)*\u00020\u00072\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u0002H%\u0012\u0004\u0012\u0002H)0\u0005H\u0007J>\u0010+\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H%0,\u0012\u0004\u0012\u0002H)0\u0005\"\u0004\b\u0000\u0010%\"\b\b\u0001\u0010)*\u00020\u00072\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u0002H%\u0012\u0004\u0012\u0002H)0\u0005H\u0007J^\u0010-\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H/\u0012\u0004\u0012\u0002H00.\u0012\u0004\u0012\u0002H)0\u0005\"\b\b\u0000\u0010)*\u00020\u0007\"\u0004\b\u0001\u0010/\"\u0004\b\u0002\u001002\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u0002H/\u0012\u0004\u0012\u0002H)0\u00052\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u0002H0\u0012\u0004\u0012\u0002H)0\u0005H\u0007R\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lxyz/bluspring/modernnetworking/api/NetworkCodecs;", "", "<init>", "()V", "BOOL", "Lxyz/bluspring/modernnetworking/api/NetworkCodec;", "", "Lio/netty/buffer/ByteBuf;", "BYTE", "", "FLOAT", "", "DOUBLE", "", "INT", "", "LONG", "", "BYTE_ARRAY", "", "VAR_INT", "VAR_LONG", "STRING_UTF8", "", "UUID", "Ljava/util/UUID;", "stringUtf8", "maxLength", "enumCodec", "E", "", "enumClass", "Ljava/lang/Class;", "enumSetCodec", "Ljava/util/EnumSet;", "clazz", "unit", "T", "value", "(Ljava/lang/Object;)Lxyz/bluspring/modernnetworking/api/NetworkCodec;", "createNullable", "B", "original", "toList", "", "createMap", "", "K", "V", "keyCodec", "valueCodec", "modernnetworking-api"})
public final class NetworkCodecs {
    @NotNull
    public static final NetworkCodecs INSTANCE = new NetworkCodecs();
    @JvmField
    @NotNull
    public static final NetworkCodec<Boolean, ByteBuf> BOOL = new NetworkCodec(BOOL.1.INSTANCE, BOOL.2.INSTANCE);
    @JvmField
    @NotNull
    public static final NetworkCodec<Byte, ByteBuf> BYTE = new NetworkCodec(BYTE.1.INSTANCE, BYTE.2.INSTANCE);
    @JvmField
    @NotNull
    public static final NetworkCodec<Float, ByteBuf> FLOAT = new NetworkCodec(FLOAT.1.INSTANCE, FLOAT.2.INSTANCE);
    @JvmField
    @NotNull
    public static final NetworkCodec<Double, ByteBuf> DOUBLE = new NetworkCodec(DOUBLE.1.INSTANCE, DOUBLE.2.INSTANCE);
    @JvmField
    @NotNull
    public static final NetworkCodec<Integer, ByteBuf> INT = new NetworkCodec(INT.1.INSTANCE, INT.2.INSTANCE);
    @JvmField
    @NotNull
    public static final NetworkCodec<Long, ByteBuf> LONG = new NetworkCodec(LONG.1.INSTANCE, LONG.2.INSTANCE);
    @JvmField
    @NotNull
    public static final NetworkCodec<byte[], ByteBuf> BYTE_ARRAY = new NetworkCodec(BYTE_ARRAY.1.INSTANCE, BYTE_ARRAY.2.INSTANCE);
    @JvmField
    @NotNull
    public static final NetworkCodec<Integer, ByteBuf> VAR_INT = new NetworkCodec(VAR_INT.1.INSTANCE, VAR_INT.2.INSTANCE);
    @JvmField
    @NotNull
    public static final NetworkCodec<Long, ByteBuf> VAR_LONG = new NetworkCodec(VAR_LONG.1.INSTANCE, VAR_LONG.2.INSTANCE);
    @JvmField
    @NotNull
    public static final NetworkCodec<String, ByteBuf> STRING_UTF8 = new NetworkCodec(STRING_UTF8.1.INSTANCE, STRING_UTF8.2.INSTANCE);
    @JvmField
    @NotNull
    public static final NetworkCodec<UUID, ByteBuf> UUID = new NetworkCodec(UUID.1.INSTANCE, UUID.2.INSTANCE);

    private NetworkCodecs() {
    }

    @JvmStatic
    @NotNull
    public static final NetworkCodec<String, ByteBuf> stringUtf8(int maxLength) {
        return new NetworkCodec<String, ByteBuf>((arg_0, arg_1) -> NetworkCodecs.stringUtf8$lambda$0(maxLength, arg_0, arg_1), arg_0 -> NetworkCodecs.stringUtf8$lambda$1(maxLength, arg_0));
    }

    @JvmStatic
    @NotNull
    public static final <E extends Enum<E>> NetworkCodec<E, ByteBuf> enumCodec(@NotNull Class<E> enumClass) {
        Intrinsics.checkNotNullParameter(enumClass, "enumClass");
        Enum[] enumValues = (Enum[])enumClass.getEnumConstants();
        return new NetworkCodec<Enum, ByteBuf>(NetworkCodecs::enumCodec$lambda$0, arg_0 -> NetworkCodecs.enumCodec$lambda$1(enumValues, arg_0));
    }

    @JvmStatic
    @NotNull
    public static final <E extends Enum<E>> NetworkCodec<EnumSet<E>, ByteBuf> enumSetCodec(@NotNull Class<E> clazz) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        return new NetworkCodec<EnumSet<E>, ByteBuf>((arg_0, arg_1) -> NetworkCodecs.enumSetCodec$lambda$0(clazz, arg_0, arg_1), arg_0 -> NetworkCodecs.enumSetCodec$lambda$1(clazz, arg_0));
    }

    @JvmStatic
    @NotNull
    public static final <T> NetworkCodec<T, ByteBuf> unit(T value) {
        return new NetworkCodec<Object, ByteBuf>(NetworkCodecs::unit$lambda$0, arg_0 -> NetworkCodecs.unit$lambda$1(value, arg_0));
    }

    @JvmStatic
    @NotNull
    public static final <T, B extends ByteBuf> NetworkCodec<T, B> createNullable(@NotNull NetworkCodec<T, B> original) {
        Intrinsics.checkNotNullParameter(original, "original");
        return new NetworkCodec<Object, ByteBuf>((arg_0, arg_1) -> NetworkCodecs.createNullable$lambda$0(original, arg_0, arg_1), arg_0 -> NetworkCodecs.createNullable$lambda$1(original, arg_0));
    }

    @JvmStatic
    @NotNull
    public static final <T, B extends ByteBuf> NetworkCodec<List<T>, B> toList(@NotNull NetworkCodec<T, B> original) {
        Intrinsics.checkNotNullParameter(original, "original");
        return new NetworkCodec<List, ByteBuf>((arg_0, arg_1) -> NetworkCodecs.toList$lambda$0(original, arg_0, arg_1), arg_0 -> NetworkCodecs.toList$lambda$1(original, arg_0));
    }

    @JvmStatic
    @NotNull
    public static final <B extends ByteBuf, K, V> NetworkCodec<Map<K, V>, B> createMap(@NotNull NetworkCodec<K, B> keyCodec, @NotNull NetworkCodec<V, B> valueCodec) {
        Intrinsics.checkNotNullParameter(keyCodec, "keyCodec");
        Intrinsics.checkNotNullParameter(valueCodec, "valueCodec");
        return new NetworkCodec<Map, ByteBuf>((arg_0, arg_1) -> NetworkCodecs.createMap$lambda$0(keyCodec, valueCodec, arg_0, arg_1), arg_0 -> NetworkCodecs.createMap$lambda$1(keyCodec, valueCodec, arg_0));
    }

    private static final void stringUtf8$lambda$0(int $maxLength, ByteBuf buf, String value) {
        Intrinsics.checkNotNullParameter(buf, "buf");
        Intrinsics.checkNotNullParameter(value, "value");
        ByteBufExtensionsKt.writeUtf(buf, value, $maxLength);
    }

    private static final String stringUtf8$lambda$1(int $maxLength, ByteBuf buf) {
        Intrinsics.checkNotNullParameter(buf, "buf");
        return ByteBufExtensionsKt.readUtf(buf, $maxLength);
    }

    private static final void enumCodec$lambda$0(ByteBuf buf, Enum value) {
        Intrinsics.checkNotNullParameter(buf, "buf");
        Intrinsics.checkNotNullParameter(value, "value");
        ByteBufExtensionsKt.writeVarInt(buf, value.ordinal());
    }

    private static final Enum enumCodec$lambda$1(Enum[] $enumValues, ByteBuf buf) {
        Intrinsics.checkNotNullParameter(buf, "buf");
        Enum enum_ = $enumValues[ByteBufExtensionsKt.readVarInt(buf)];
        Intrinsics.checkNotNullExpressionValue(enum_, "get(...)");
        return enum_;
    }

    private static final void enumSetCodec$lambda$0(Class $clazz, ByteBuf buf, EnumSet value) {
        Intrinsics.checkNotNullParameter(buf, "buf");
        Intrinsics.checkNotNullParameter(value, "value");
        ByteBufExtensionsKt.writeEnumSet(buf, value, $clazz);
    }

    private static final EnumSet enumSetCodec$lambda$1(Class $clazz, ByteBuf buf) {
        Intrinsics.checkNotNullParameter(buf, "buf");
        return ByteBufExtensionsKt.readEnumSet(buf, $clazz);
    }

    private static final void unit$lambda$0(ByteBuf buf, Object value) {
        Intrinsics.checkNotNullParameter(buf, "buf");
    }

    private static final Object unit$lambda$1(Object $value, ByteBuf it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $value;
    }

    private static final void createNullable$lambda$0(NetworkCodec $original, ByteBuf buf, Object value) {
        Intrinsics.checkNotNullParameter(buf, "buf");
        buf.writeBoolean(value != null);
        if (value != null) {
            $original.encode(buf, value);
        }
    }

    private static final Object createNullable$lambda$1(NetworkCodec $original, ByteBuf buf) {
        Intrinsics.checkNotNullParameter(buf, "buf");
        if (buf.readBoolean()) {
            return $original.decode(buf);
        }
        return null;
    }

    private static final void toList$lambda$0(NetworkCodec $original, ByteBuf buf, List values2) {
        Intrinsics.checkNotNullParameter(buf, "buf");
        Intrinsics.checkNotNullParameter(values2, "values");
        ByteBufExtensionsKt.writeVarInt(buf, values2.size());
        for (Object value : values2) {
            $original.encode(buf, value);
        }
    }

    private static final List toList$lambda$1(NetworkCodec $original, ByteBuf buf) {
        Intrinsics.checkNotNullParameter(buf, "buf");
        List list = new ArrayList();
        int length = ByteBufExtensionsKt.readVarInt(buf);
        for (int i = 0; i < length; ++i) {
            list.add($original.decode(buf));
        }
        return CollectionsKt.toList(list);
    }

    private static final void createMap$lambda$0(NetworkCodec $keyCodec, NetworkCodec $valueCodec, ByteBuf buf, Map value) {
        Intrinsics.checkNotNullParameter(buf, "buf");
        Intrinsics.checkNotNullParameter(value, "value");
        ByteBufExtensionsKt.writeVarInt(buf, value.size());
        for (Map.Entry entry : value.entrySet()) {
            Object key = entry.getKey();
            Object value2 = entry.getValue();
            $keyCodec.encode(buf, key);
            $valueCodec.encode(buf, value2);
        }
    }

    private static final Map createMap$lambda$1(NetworkCodec $keyCodec, NetworkCodec $valueCodec, ByteBuf buf) {
        Intrinsics.checkNotNullParameter(buf, "buf");
        Map map = new LinkedHashMap();
        int length = ByteBufExtensionsKt.readVarInt(buf);
        for (int i = 0; i < length; ++i) {
            map.put($keyCodec.decode(buf), $valueCodec.decode(buf));
        }
        return map;
    }
}

