/*
 * Decompiled with CFR 0.152.
 */
package xyz.bluspring.modernnetworking.api.minecraft;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import xyz.bluspring.modernnetworking.api.NetworkCodec;
import xyz.bluspring.modernnetworking.api.NetworkPacket;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lxyz/bluspring/modernnetworking/api/minecraft/VanillaPacketSender;", "", "<init>", "()V", "Lxyz/bluspring/modernnetworking/api/NetworkPacket;", "packet", "", "sendToServer", "(Lxyz/bluspring/modernnetworking/api/NetworkPacket;)V", "Lnet/minecraft/server/level/ServerPlayer;", "player", "sendToPlayer", "(Lnet/minecraft/server/level/ServerPlayer;Lxyz/bluspring/modernnetworking/api/NetworkPacket;)V", "modernnetworking-common"})
public final class VanillaPacketSender {
    @NotNull
    public static final VanillaPacketSender INSTANCE = new VanillaPacketSender();

    private VanillaPacketSender() {
    }

    @JvmStatic
    @Environment(value=EnvType.CLIENT)
    public static final void sendToServer(@NotNull NetworkPacket packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        NetworkCodec<? extends NetworkPacket, ? extends ByteBuf> networkCodec = packet.getDefinition().getCodec();
        Intrinsics.checkNotNull(networkCodec, (String)"null cannot be cast to non-null type xyz.bluspring.modernnetworking.api.NetworkCodec<xyz.bluspring.modernnetworking.api.NetworkPacket, net.minecraft.network.FriendlyByteBuf>");
        networkCodec.encode((ByteBuf)((ByteBuf)buf), packet);
        ClientPacketListener clientPacketListener = Minecraft.m_91087_().m_91403_();
        Intrinsics.checkNotNull((Object)clientPacketListener);
        clientPacketListener.m_104955_((Packet)new ServerboundCustomPayloadPacket(new ResourceLocation(packet.getDefinition().getNamespace(), packet.getDefinition().getId()), buf));
    }

    @JvmStatic
    public static final void sendToPlayer(@NotNull ServerPlayer player, @NotNull NetworkPacket packet) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        NetworkCodec<? extends NetworkPacket, ? extends ByteBuf> networkCodec = packet.getDefinition().getCodec();
        Intrinsics.checkNotNull(networkCodec, (String)"null cannot be cast to non-null type xyz.bluspring.modernnetworking.api.NetworkCodec<xyz.bluspring.modernnetworking.api.NetworkPacket, net.minecraft.network.FriendlyByteBuf>");
        networkCodec.encode((ByteBuf)((ByteBuf)buf), packet);
        player.f_8906_.m_141995_((Packet)new ClientboundCustomPayloadPacket(new ResourceLocation(packet.getDefinition().getNamespace(), packet.getDefinition().getId()), buf));
    }
}

