/*
 * Decompiled with CFR 0.152.
 */
package xyz.bluspring.modernnetworking.bukkit.api;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.bluspring.modernnetworking.api.AbstractNetworkRegistry;
import xyz.bluspring.modernnetworking.api.NetworkPacket;
import xyz.bluspring.modernnetworking.api.PacketDefinition;
import xyz.bluspring.modernnetworking.bukkit.api.BukkitServerContext;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u0000 \u001c2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u0001\u001cB\u001b\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ<\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u00100\u000e\"\b\b\u0000\u0010\u000f*\u00020\u0011\"\b\b\u0001\u0010\u0010*\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u00100\u000eH\u0016J<\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u00100\u000e\"\b\b\u0000\u0010\u000f*\u00020\u0011\"\b\b\u0001\u0010\u0010*\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u00100\u000eH\u0016J\"\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Lxyz/bluspring/modernnetworking/bukkit/api/BukkitNetworkRegistry;", "Lxyz/bluspring/modernnetworking/api/AbstractNetworkRegistry;", "", "Lxyz/bluspring/modernnetworking/bukkit/api/BukkitServerContext;", "Lorg/bukkit/plugin/messaging/PluginMessageListener;", "plugin", "Lorg/bukkit/plugin/Plugin;", "namespace", "", "<init>", "(Lorg/bukkit/plugin/Plugin;Ljava/lang/String;)V", "getPlugin", "()Lorg/bukkit/plugin/Plugin;", "registerClientbound", "Lxyz/bluspring/modernnetworking/api/PacketDefinition;", "T", "B", "Lxyz/bluspring/modernnetworking/api/NetworkPacket;", "Lio/netty/buffer/ByteBuf;", "definition", "registerServerbound", "onPluginMessageReceived", "", "channel", "player", "Lorg/bukkit/entity/Player;", "message", "", "Companion", "modernnetworking-bukkit"})
public final class BukkitNetworkRegistry
extends AbstractNetworkRegistry<Object, BukkitServerContext>
implements PluginMessageListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Plugin plugin;
    @NotNull
    private static final List<BukkitNetworkRegistry> registries;

    public BukkitNetworkRegistry(@NotNull Plugin plugin, @Nullable String namespace) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        String string = namespace;
        if (string == null) {
            String string2 = plugin.getName();
            Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
            String string3 = string2.toLowerCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
        }
        super(string);
        this.plugin = plugin;
        registries.add(this);
    }

    public /* synthetic */ BukkitNetworkRegistry(Plugin plugin, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        this(plugin, string);
    }

    @NotNull
    public final Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    @NotNull
    public <T extends NetworkPacket, B extends ByteBuf> PacketDefinition<T, B> registerClientbound(@NotNull PacketDefinition<T, B> definition) {
        Intrinsics.checkNotNullParameter(definition, "definition");
        PacketDefinition<T, B> definition2 = super.registerClientbound(definition);
        Bukkit.getMessenger().registerOutgoingPluginChannel(this.plugin, definition2.getNamespace() + ":" + definition2.getId());
        return definition2;
    }

    @Override
    @NotNull
    public <T extends NetworkPacket, B extends ByteBuf> PacketDefinition<T, B> registerServerbound(@NotNull PacketDefinition<T, B> definition) {
        Intrinsics.checkNotNullParameter(definition, "definition");
        PacketDefinition<T, B> definition2 = super.registerServerbound(definition);
        Bukkit.getMessenger().registerIncomingPluginChannel(this.plugin, definition2.getNamespace() + ":" + definition2.getId(), (PluginMessageListener)this);
        return definition2;
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, @Nullable byte[] message) {
        Intrinsics.checkNotNullParameter(channel, "channel");
        Intrinsics.checkNotNullParameter(player, "player");
        String[] stringArray = new String[]{":"};
        List split = StringsKt.split$default((CharSequence)channel, stringArray, false, 0, 6, null);
        String namespace = (String)split.get(0);
        if (!Intrinsics.areEqual(namespace, this.getNamespace())) {
            return;
        }
        String path = CollectionsKt.joinToString$default(CollectionsKt.drop(split, 1), ":", null, null, 0, null, null, 62, null);
        PacketDefinition packetDefinition = this.getServerboundDefinition(path);
        if (packetDefinition == null) {
            return;
        }
        PacketDefinition definition = packetDefinition;
        ByteBuf buffer = Unpooled.buffer();
        if (message != null) {
            buffer.writeBytes(message);
        }
        Intrinsics.checkNotNull(buffer);
        Server server = Bukkit.getServer();
        Intrinsics.checkNotNullExpressionValue(server, "getServer(...)");
        this.handleServerPacket(definition, buffer, new BukkitServerContext(server, player));
    }

    @JvmStatic
    @ApiStatus.Internal
    @Nullable
    public static final BukkitNetworkRegistry get(@NotNull String namespace) {
        return Companion.get(namespace);
    }

    static {
        List list = Collections.synchronizedList(new ArrayList());
        Intrinsics.checkNotNullExpressionValue(list, "synchronizedList(...)");
        registries = list;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lxyz/bluspring/modernnetworking/bukkit/api/BukkitNetworkRegistry$Companion;", "", "<init>", "()V", "registries", "", "Lxyz/bluspring/modernnetworking/bukkit/api/BukkitNetworkRegistry;", "getRegistries", "()Ljava/util/List;", "get", "namespace", "", "modernnetworking-bukkit"})
    @SourceDebugExtension(value={"SMAP\nBukkitNetworkRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BukkitNetworkRegistry.kt\nxyz/bluspring/modernnetworking/bukkit/api/BukkitNetworkRegistry$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n295#2,2:67\n*S KotlinDebug\n*F\n+ 1 BukkitNetworkRegistry.kt\nxyz/bluspring/modernnetworking/bukkit/api/BukkitNetworkRegistry$Companion\n*L\n62#1:67,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<BukkitNetworkRegistry> getRegistries() {
            return registries;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @ApiStatus.Internal
        @Nullable
        public final BukkitNetworkRegistry get(@NotNull String namespace) {
            Intrinsics.checkNotNullParameter(namespace, "namespace");
            List<BukkitNetworkRegistry> list = this.getRegistries();
            synchronized (list) {
                Object v0;
                block4: {
                    boolean bl = false;
                    Iterable $this$firstOrNull$iv = Companion.getRegistries();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        BukkitNetworkRegistry it = (BukkitNetworkRegistry)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(it.getNamespace(), namespace)) continue;
                        v0 = element$iv;
                        break block4;
                    }
                    v0 = null;
                }
                BukkitNetworkRegistry bukkitNetworkRegistry = v0;
                return bukkitNetworkRegistry;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

