/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ometweaks.integration.industrialforegoing.machine.worker.animalrancher;

import com.buuz135.industrial.proxy.BlockRegistry;
import com.tttsaurus.ometweaks.integration.industrialforegoing.machine.worker.animalrancher.AnimalRancherOutput;
import com.tttsaurus.ometweaks.render.EntityRenderer;
import com.tttsaurus.ometweaks.render.RenderUtils;
import java.awt.Color;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.EntityEntry;
import org.apache.commons.lang3.time.StopWatch;

public class AnimalRancherRecipeWrapper
implements IRecipeWrapper {
    public final EntityEntry inputEntity;
    public final AnimalRancherOutput output;
    private final ItemStack animalRancher;
    private static final int JEI_PIVOT_X = 24;
    private static final int JEI_PIVOT_Y = 18;
    private EntityRenderer entityRenderer = null;
    private StopWatch stopWatch = null;

    public AnimalRancherRecipeWrapper(EntityEntry inputEntity, AnimalRancherOutput output) {
        this.inputEntity = inputEntity;
        this.output = output;
        this.animalRancher = new ItemStack((Block)BlockRegistry.animalResourceHarvesterBlock);
    }

    public void getIngredients(IIngredients ingredients) {
        if (this.output.itemStack != null) {
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output.itemStack);
        }
        if (this.output.fluidStack != null) {
            ingredients.setOutput(VanillaTypes.FLUID, (Object)this.output.fluidStack);
        }
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        RenderUtils.storeCommonGlStates();
        RenderHelper.func_74520_c();
        minecraft.func_175599_af().func_184391_a(null, this.animalRancher, 20, 14);
        RenderHelper.func_74518_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)37.0f, (float)26.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)0.55f, (float)1.0f);
        GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderUtils.renderRoundedRect(0.0f, 0.0f, 12.0f, 12.0f, 3.0f, new Color(144, 144, 144, 144).getRGB());
        GlStateManager.func_179121_F();
        RenderUtils.restoreCommonGlStates();
        if (this.entityRenderer == null) {
            this.entityRenderer = new EntityRenderer(minecraft, this.inputEntity);
        }
        float dist = 90.0f;
        double angle = Math.atan((float)(mouseX - 36) / dist) / (double)6.28318f * 360.0;
        if (this.output.damage == 0.0f) {
            this.entityRenderer.render(37.0f + this.output.modelPosX, 32.0f + this.output.modelPosY, this.output.modelScaleX, this.output.modelScaleY, this.output.modelScaleZ, this.output.modelRotateX, (float)angle + this.output.modelRotateY, this.output.modelRotateZ, Color.WHITE.getRGB());
        } else {
            if (this.stopWatch == null) {
                this.stopWatch = new StopWatch();
            }
            if (!this.stopWatch.isStarted()) {
                this.stopWatch.start();
            }
            int color = Color.WHITE.getRGB();
            double time = (double)this.stopWatch.getNanoTime() / 1.0E9;
            if (time >= 1.0) {
                color = new Color(200, 50, 0, 255).getRGB();
            }
            if (time > 1.5) {
                this.stopWatch.stop();
                this.stopWatch.reset();
                this.stopWatch.start();
            }
            this.entityRenderer.render(37.0f + this.output.modelPosX, 32.0f + this.output.modelPosY, this.output.modelScaleX, this.output.modelScaleY, this.output.modelScaleZ, this.output.modelRotateX, (float)angle + this.output.modelRotateY, this.output.modelRotateZ, color);
            if (time >= 1.0 && time <= 1.5) {
                double x = ((double)this.stopWatch.getNanoTime() / 1.0E9 - 1.0) / 0.5 * 2.6 + 0.7;
                int a = 255 - (int)(((double)this.stopWatch.getNanoTime() / 1.0E9 - 1.0) * 2.0 * 255.0) + 30;
                a = Math.min(a, 255);
                a = Math.max(a, 0);
                RenderUtils.renderText("-" + this.output.damage, 37.0f, 32.0f - (float)(Math.sin(x) * 5.0), 1.0f, new Color(255, 0, 0, a).getRGB(), true);
            }
        }
        RenderUtils.restoreCommonGlStates();
    }
}

