/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ometweaks.integration.jei.category;

import com.tttsaurus.ometweaks.integration.jei.category.CategoryModification;
import com.tttsaurus.ometweaks.integration.jei.category.IDrawableGhostItemHandler;
import java.util.List;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.gui.elements.DrawableBuilder;
import mezz.jei.gui.elements.DrawableIngredient;
import mezz.jei.plugins.vanilla.ingredients.item.ItemStackRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class DynamicCategoryWrapper<T extends IRecipeWrapper>
implements IRecipeCategory<T> {
    private final IRecipeCategory<T> originalCategory;
    private IDrawable newIcon = null;
    private IDrawableGhostItemHandler drawableGhostItemHandler = null;

    public DynamicCategoryWrapper(IRecipeCategory<T> originalCategory, ResourceLocation iconRL) {
        this.originalCategory = originalCategory;
        this.newIcon = new DrawableBuilder(iconRL, 0, 0, 16, 16).setTextureSize(16, 16).build();
    }

    public DynamicCategoryWrapper(IRecipeCategory<T> originalCategory, ItemStack itemStack) {
        this.originalCategory = originalCategory;
        if (itemStack != null) {
            this.newIcon = new DrawableIngredient((Object)itemStack, (IIngredientRenderer)new ItemStackRenderer());
        }
    }

    public void setDrawableGhostItemHandler(CategoryModification categoryMod) {
        this.drawableGhostItemHandler = () -> {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(categoryMod.itemRegistryName));
            if (item == null) {
                return;
            }
            ItemStack itemStack = new ItemStack(item, 1, categoryMod.itemMeta);
            this.newIcon = new DrawableIngredient((Object)itemStack, (IIngredientRenderer)new ItemStackRenderer());
        };
    }

    public String getUid() {
        return this.originalCategory.getUid();
    }

    public String getTitle() {
        return this.originalCategory.getTitle();
    }

    public String getModName() {
        return this.originalCategory.getModName();
    }

    public IDrawable getBackground() {
        return this.originalCategory.getBackground();
    }

    public IDrawable getIcon() {
        if (this.drawableGhostItemHandler != null) {
            this.drawableGhostItemHandler.handle();
            this.drawableGhostItemHandler = null;
        }
        return this.newIcon == null ? this.originalCategory.getIcon() : this.newIcon;
    }

    public void drawExtras(Minecraft minecraft) {
        this.originalCategory.drawExtras(minecraft);
    }

    public void setRecipe(IRecipeLayout recipeLayout, T recipeWrapper, IIngredients ingredients) {
        this.originalCategory.setRecipe(recipeLayout, recipeWrapper, ingredients);
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return this.originalCategory.getTooltipStrings(mouseX, mouseY);
    }
}

