/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ometweaks;

import com.tttsaurus.ometweaks.OMEConfig;
import com.tttsaurus.ometweaks.gui.GuiResources;
import com.tttsaurus.ometweaks.integration.ConfigLoadingData;
import com.tttsaurus.ometweaks.integration.ConfigLoadingStage;
import com.tttsaurus.ometweaks.integration.OMETweaksModule;
import com.tttsaurus.ometweaks.integration.OMETweaksModuleSignature;
import com.tttsaurus.ometweaks.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="ometweaks", version="1.5.4", name="OME-Tweaks", acceptedMinecraftVersions="[1.12.2]", dependencies="required-after:mixinbooter@[10.0,)")
public class OMETweaks {
    public static final Logger LOGGER = LogManager.getLogger((String)"ometweaks");
    public static final Map<OMETweaksModule, OMETweaksModuleSignature> MODULES = new LinkedHashMap<OMETweaksModule, OMETweaksModuleSignature>();
    public static final Map<OMETweaksModule, ConfigLoadingData> MODULE_CONFIGS = new LinkedHashMap<OMETweaksModule, ConfigLoadingData>();

    public static void loadModules(File modulesFile) {
        MODULES.clear();
        MODULE_CONFIGS.clear();
        try {
            RandomAccessFile raf = new RandomAccessFile(modulesFile, "rw");
            String line = raf.readLine();
            while (line != null) {
                if (!line.isEmpty()) {
                    try {
                        Class<?> clazz = Class.forName(line);
                        if (OMETweaksModule.class.isAssignableFrom(clazz)) {
                            Class<OMETweaksModule> moduleClass = clazz.asSubclass(OMETweaksModule.class);
                            OMETweaksModule module = moduleClass.newInstance();
                            OMETweaksModuleSignature annotation = moduleClass.getAnnotation(OMETweaksModuleSignature.class);
                            MODULES.put(module, annotation);
                            Method method = module.getClass().getDeclaredMethod("loadConfig", Configuration.class, String.class);
                            if (method.isAnnotationPresent(ConfigLoadingStage.class)) {
                                ConfigLoadingStage stage = method.getAnnotation(ConfigLoadingStage.class);
                                MODULE_CONFIGS.put(module, new ConfigLoadingData(method, stage.value()));
                            }
                            LOGGER.info("OME-Tweaks module [" + annotation.value() + "] instantiated.");
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                line = raf.readLine();
            }
            raf.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        File modulesFile;
        MinecraftForge.EVENT_BUS.register((Object)this);
        ASMDataTable asmDataTable = event.getAsmData();
        if (OMEConfig.CONFIG == null) {
            OMEConfig.CONFIG = new Configuration(FileUtils.makeFile("ometweaks.cfg", new String[0]));
            OMEConfig.init();
        }
        if (!(modulesFile = FileUtils.getFile("modules.cfg", new String[0])).exists()) {
            FileUtils.makeFile("[NOTICE] ometweaks config will be complete after the next run", new String[0]);
            LOGGER.info("First time of loading OME-Tweaks modules. Config file (/config/ometweaks/ometweaks.cfg) will be complete after the next run.");
        } else {
            File logFile = FileUtils.getFile("[NOTICE] ometweaks config will be complete after the next run", new String[0]);
            if (logFile.exists()) {
                logFile.delete();
            }
        }
        LOGGER.info("OME-Tweaks starts writing module classes to local.");
        try {
            RandomAccessFile raf = new RandomAccessFile(modulesFile, "rw");
            raf.setLength(0L);
            raf.seek(0L);
            ArrayList classes = new ArrayList();
            asmDataTable.getAll(OMETweaksModuleSignature.class.getCanonicalName()).forEach(data -> classes.add(data.getClassName()));
            Collections.sort(classes);
            for (String className : classes) {
                try {
                    Class<?> clazz = Class.forName(className);
                    if (!OMETweaksModule.class.isAssignableFrom(clazz)) continue;
                    Class<OMETweaksModule> moduleClass = clazz.asSubclass(OMETweaksModule.class);
                    try {
                        OMETweaksModule module = moduleClass.newInstance();
                        try {
                            raf.writeBytes(module.getClass().getName() + "\n");
                        }
                        catch (IOException iOException) {}
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        LOGGER.throwing((Throwable)e);
                    }
                }
                catch (ClassNotFoundException e) {
                    LOGGER.throwing((Throwable)e);
                }
            }
            raf.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LOGGER.info("OME-Tweaks finished writing module classes to local.");
        LOGGER.info("Pre Init Stage");
        if (FMLCommonHandler.instance().getSide().isClient()) {
            GuiResources.init();
            LOGGER.info("GUI resources loaded.");
        }
        for (Map.Entry<OMETweaksModule, OMETweaksModuleSignature> entry : MODULES.entrySet()) {
            OMETweaksModule module = entry.getKey();
            OMETweaksModuleSignature annotation = entry.getValue();
            ConfigLoadingData data2 = MODULE_CONFIGS.get(module);
            if (data2 != null && data2.stages.contains((Object)"PRE_INIT")) {
                LOGGER.info("Load configs for OME-Tweaks module [" + annotation.value() + "].");
                OMEConfig.invokeLoadConfig(module, data2.loadConfigMethod, "PRE_INIT");
            }
            try {
                module.getClass().getDeclaredMethod("preInit", FMLPreInitializationEvent.class);
            }
            catch (NoSuchMethodException | SecurityException e) {
                continue;
            }
            LOGGER.info("Invoke preInit() of OME-Tweaks module [" + annotation.value() + "].");
            module.preInit(event);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        LOGGER.info("Init Stage");
        for (Map.Entry<OMETweaksModule, OMETweaksModuleSignature> entry : MODULES.entrySet()) {
            OMETweaksModule module = entry.getKey();
            OMETweaksModuleSignature annotation = entry.getValue();
            ConfigLoadingData data = MODULE_CONFIGS.get(module);
            if (data != null && data.stages.contains((Object)"INIT")) {
                LOGGER.info("Load configs for OME-Tweaks module [" + annotation.value() + "].");
                OMEConfig.invokeLoadConfig(module, data.loadConfigMethod, "INIT");
            }
            try {
                module.getClass().getDeclaredMethod("init", FMLInitializationEvent.class);
            }
            catch (NoSuchMethodException | SecurityException e) {
                continue;
            }
            LOGGER.info("Invoke init() of OME-Tweaks module [" + annotation.value() + "].");
            module.init(event);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        LOGGER.info("Post Init Stage");
        for (Map.Entry<OMETweaksModule, OMETweaksModuleSignature> entry : MODULES.entrySet()) {
            OMETweaksModule module = entry.getKey();
            OMETweaksModuleSignature annotation = entry.getValue();
            ConfigLoadingData data = MODULE_CONFIGS.get(module);
            if (data != null && data.stages.contains((Object)"POST_INIT")) {
                LOGGER.info("Load configs for OME-Tweaks module [" + annotation.value() + "].");
                OMEConfig.invokeLoadConfig(module, data.loadConfigMethod, "POST_INIT");
            }
            try {
                module.getClass().getDeclaredMethod("postInit", FMLPostInitializationEvent.class);
            }
            catch (NoSuchMethodException | SecurityException e) {
                continue;
            }
            LOGGER.info("Invoke postInit() of OME-Tweaks module [" + annotation.value() + "].");
            module.postInit(event);
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        LOGGER.info("Register Items Stage");
        for (Map.Entry<OMETweaksModule, OMETweaksModuleSignature> entry : MODULES.entrySet()) {
            OMETweaksModule module = entry.getKey();
            OMETweaksModuleSignature annotation = entry.getValue();
            try {
                module.getClass().getDeclaredMethod("registerItems", RegistryEvent.Register.class);
            }
            catch (NoSuchMethodException | SecurityException e) {
                continue;
            }
            LOGGER.info("Invoke registerItems() of OME-Tweaks module [" + annotation.value() + "].");
            module.registerItems(event);
        }
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        LOGGER.info("Register Models Stage");
        for (Map.Entry<OMETweaksModule, OMETweaksModuleSignature> entry : MODULES.entrySet()) {
            OMETweaksModule module = entry.getKey();
            OMETweaksModuleSignature annotation = entry.getValue();
            try {
                module.getClass().getDeclaredMethod("registerModels", ModelRegistryEvent.class);
            }
            catch (NoSuchMethodException | SecurityException e) {
                continue;
            }
            LOGGER.info("Invoke registerModels() of OME-Tweaks module [" + annotation.value() + "].");
            module.registerModels(event);
        }
    }
}

