/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ometweaks.integration.industrialforegoing;

import com.tttsaurus.ometweaks.OMEConfig;
import com.tttsaurus.ometweaks.integration.ConfigLoadingStage;
import com.tttsaurus.ometweaks.integration.OMETweaksModule;
import com.tttsaurus.ometweaks.integration.OMETweaksModuleSignature;
import com.tttsaurus.ometweaks.integration.industrialforegoing.infdrill.InfinityDrillBlacklist;
import com.tttsaurus.ometweaks.integration.industrialforegoing.infdrill.InfinityDrillHarvestLevel;
import com.tttsaurus.ometweaks.integration.industrialforegoing.machine.generator.petrified.FuelDef;
import com.tttsaurus.ometweaks.integration.industrialforegoing.machine.worker.animalrancher.AnimalRancherOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@OMETweaksModuleSignature(value="Industrial Foregoing")
public final class IndustrialForegoingModule
extends OMETweaksModule {
    public static final boolean IS_MOD_LOADED = Loader.isModLoaded((String)"industrialforegoing");
    public static boolean ENABLE_IF_MODULE;
    public static boolean ENABLE_IF_MACHINE_JEI_EXCLUSION;
    public static boolean ENABLE_IF_INFINITY_DRILL_BLACKLIST;
    public static final List<ItemStack> IF_INFINITY_DRILL_BLACKLIST;
    public static boolean ENABLE_IF_INFINITY_DRILL_HARVEST_LEVEL;
    public static final Map<String, Integer> IF_INFINITY_DRILL_HARVEST_LEVEL;
    public static boolean ENABLE_IF_PETRIFIED_FUEL_GENERATOR;
    public static final Map<ItemStack, FuelDef> IF_PETRIFIED_FUEL_GENERATOR_FUELS;
    public static boolean IF_PETRIFIED_FUEL_GENERATOR_JEI_OVERHAUL;
    public static String IF_PETRIFIED_FUEL_GENERATOR_JEI_ORDER;
    public static int IF_PETRIFIED_FUEL_GENERATOR_POWER_MAX;
    public static int IF_PETRIFIED_FUEL_GENERATOR_BURN_TIME_MAX;
    public static boolean DISABLE_IF_FLUID_EFFECT_DRINKING_BIOFUEL;
    public static boolean DISABLE_IF_FLUID_EFFECT_DRINKING_SLUDGE;
    public static boolean DISABLE_IF_FLUID_EFFECT_DRINKING_SEWAGE;
    public static boolean DISABLE_IF_FLUID_EFFECT_DRINKING_MEAT;
    public static boolean DISABLE_IF_FLUID_EFFECT_DRINKING_PROTEIN;
    public static boolean DISABLE_IF_FLUID_EFFECT_DRINKING_LATEX;
    public static boolean DISABLE_IF_FLUID_EFFECT_BIOFUEL;
    public static boolean DISABLE_IF_FLUID_EFFECT_SLUDGE;
    public static boolean DISABLE_IF_FLUID_EFFECT_SEWAGE;
    public static boolean DISABLE_IF_FLUID_EFFECT_MEAT;
    public static boolean DISABLE_IF_FLUID_EFFECT_PROTEIN;
    public static boolean DISABLE_IF_FLUID_EFFECT_LATEX;
    public static boolean ENABLE_IF_CUSTOM_ANIMAL_RANCHER;
    public static boolean ENABLE_IF_CUSTOM_ANIMAL_RANCHER_FORTUNE;
    public static boolean ENABLE_IF_CUSTOM_ANIMAL_RANCHER_JEI;
    public static final Map<EntityEntry, AnimalRancherOutput> IF_CUSTOM_ANIMAL_RANCHER_RECIPES;
    public static boolean ENABLE_IF_EIO_CAPACITOR_COMPAT;
    public static boolean ENABLE_IF_EIO_CAPACITOR_ON_REMOVE_CLEAR_ENERGY;
    public static boolean ENABLE_IF_PLANT_SOWER_MOD;
    public static boolean ENABLE_IF_PLANT_SOWER_TEASTORY_COMPAT;
    public static boolean ENABLE_IF_PLANT_SOWER_EXTRA_ACCEPTABLE_CROPS;
    public static final List<ItemStack> IF_PLANT_SOWER_EXTRA_ACCEPTABLE_CROPS;
    private String[] RAW_IF_INFINITY_DRILL_BLACKLIST;
    private String[] RAW_IF_PETRIFIED_FUEL_GENERATOR_FUELS;
    private String[] RAW_IF_CUSTOM_ANIMAL_RANCHER_RECIPES;
    private String[] RAW_IF_PLANT_SOWER_EXTRA_ACCEPTABLE_CROPS;

    @Override
    @ConfigLoadingStage(value={"MIXIN", "POST_INIT"})
    public void loadConfig(Configuration config, String currentStage) {
        if (currentStage.equals("MIXIN")) {
            ENABLE_IF_MODULE = config.getBoolean("Enable", "general.if", false, "Enable Industrial Foregoing Module / Whether mixins will be loaded");
            ENABLE_IF_MACHINE_JEI_EXCLUSION = config.getBoolean("Enable Machine JEI Exclusion", "general.if", true, "Enable JEI Exclusion Compat with Industrial Foregoing Machine GUI");
            ENABLE_IF_INFINITY_DRILL_BLACKLIST = config.getBoolean("Enable", "general.if.infinity_drill.blacklist", false, "Enable Industrial Foregoing Infinity Drill Blacklist");
            this.RAW_IF_INFINITY_DRILL_BLACKLIST = config.getStringList("Infinity Drill Blacklist", "general.if.infinity_drill.blacklist", new String[0], "A list of block registry names that infinity drill cannot harvest (Example: minecraft:dirt@0 or ignore '@' like minecraft:dirt)");
            ENABLE_IF_INFINITY_DRILL_HARVEST_LEVEL = config.getBoolean("Enable", "general.if.infinity_drill.harvest_level", false, "Enable Industrial Foregoing Infinity Drill Harvest Level");
            String[] IF_INFINITY_DRILL_HARVEST_LEVEL = config.getStringList("Infinity Drill Harvest Level", "general.if.infinity_drill.harvest_level", new String[]{"pickaxe:5", "shovel:5"}, "A list of harvest level specifications (Example: pickaxe:3)");
            IndustrialForegoingModule.IF_INFINITY_DRILL_HARVEST_LEVEL.clear();
            String[] stringArray = IF_INFINITY_DRILL_HARVEST_LEVEL;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String arg = stringArray[i];
                String[] args = arg.split(":");
                if (args.length != 2) continue;
                int level = 0;
                try {
                    level = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                IndustrialForegoingModule.IF_INFINITY_DRILL_HARVEST_LEVEL.put(args[0], level);
            }
            ENABLE_IF_PETRIFIED_FUEL_GENERATOR = config.getBoolean("Enable", "general.if.petrified_fuel_generator", false, "Enable Industrial Foregoing Petrified Fuel Generator Overhaul");
            this.RAW_IF_PETRIFIED_FUEL_GENERATOR_FUELS = config.getStringList("Petrified Fuel Generator Fuel Def Override", "general.if.petrified_fuel_generator", new String[]{"minecraft:dirt,100,40"}, "A list of fuel definitions (Example: minecraft:dirt,100,40 so dirt generates 100 RF/tick for 40 ticks)\nConfig option \"burnTimeMultiplier\" from Industrial Foregoing still affects the duration you set\n");
            IF_PETRIFIED_FUEL_GENERATOR_JEI_OVERHAUL = config.getBoolean("Petrified Fuel Generator JEI Overhaul", "general.if.petrified_fuel_generator", false, "Whether to add burn time and i18n to the existing petrified fuel generator JEI page");
            IF_PETRIFIED_FUEL_GENERATOR_JEI_ORDER = config.getString("Petrified Fuel Generator JEI Fuel Order", "general.if.petrified_fuel_generator", "NONE", "Order JEI recipes by fuel burning power\nValid values: NONE, BIGGER_FIRST, SMALLER_FIRST");
            IF_PETRIFIED_FUEL_GENERATOR_POWER_MAX = config.getInt("Petrified Fuel Generator Max Power", "general.if.petrified_fuel_generator", -1, -1, Integer.MAX_VALUE, "-1 for no max limit to all auto-added default fuels");
            IF_PETRIFIED_FUEL_GENERATOR_BURN_TIME_MAX = config.getInt("Petrified Fuel Generator Max Burn Time", "general.if.petrified_fuel_generator", -1, -1, Integer.MAX_VALUE, "-1 for no max limit to all auto-added default fuels");
            DISABLE_IF_FLUID_EFFECT_DRINKING_BIOFUEL = config.getBoolean("Disable Effect On Drink", "general.if.fluid_effect.biofuel", false, "Disable Biofuel Potion Effect");
            DISABLE_IF_FLUID_EFFECT_BIOFUEL = config.getBoolean("Disable Fluid Tile Effect", "general.if.fluid_effect.biofuel", false, "Disable Biofuel Potion Effect");
            DISABLE_IF_FLUID_EFFECT_DRINKING_SLUDGE = config.getBoolean("Disable Effect On Drink", "general.if.fluid_effect.sludge", false, "Disable Sludge Potion Effect");
            DISABLE_IF_FLUID_EFFECT_SLUDGE = config.getBoolean("Disable Fluid Tile Effect", "general.if.fluid_effect.sludge", false, "Disable Sludge Potion Effect");
            DISABLE_IF_FLUID_EFFECT_DRINKING_SEWAGE = config.getBoolean("Disable Effect On Drink", "general.if.fluid_effect.sewage", false, "Disable Sewage Potion Effect");
            DISABLE_IF_FLUID_EFFECT_SEWAGE = config.getBoolean("Disable Fluid Tile Effect", "general.if.fluid_effect.sewage", false, "Disable Sewage Potion Effect");
            DISABLE_IF_FLUID_EFFECT_DRINKING_MEAT = config.getBoolean("Disable Effect On Drink", "general.if.fluid_effect.meat", false, "Disable Meat Potion Effect");
            DISABLE_IF_FLUID_EFFECT_MEAT = config.getBoolean("Disable Fluid Tile Effect", "general.if.fluid_effect.meat", false, "Disable Meat Potion Effect");
            DISABLE_IF_FLUID_EFFECT_DRINKING_PROTEIN = config.getBoolean("Disable Effect On Drink", "general.if.fluid_effect.protein", false, "Disable Protein Potion Effect");
            DISABLE_IF_FLUID_EFFECT_PROTEIN = config.getBoolean("Disable Fluid Tile Effect", "general.if.fluid_effect.protein", false, "Disable Protein Potion Effect");
            DISABLE_IF_FLUID_EFFECT_DRINKING_LATEX = config.getBoolean("Disable Effect On Drink", "general.if.fluid_effect.latex", false, "Disable Latex Potion Effect");
            DISABLE_IF_FLUID_EFFECT_LATEX = config.getBoolean("Disable Fluid Tile Effect", "general.if.fluid_effect.latex", false, "Disable Latex Potion Effect");
            ENABLE_IF_CUSTOM_ANIMAL_RANCHER = config.getBoolean("Enable", "general.if.animal_rancher", false, "Enable Industrial Foregoing Custom Animal Rancher");
            ENABLE_IF_CUSTOM_ANIMAL_RANCHER_FORTUNE = config.getBoolean("Affected By Fortune", "general.if.animal_rancher", true, "Whether fortune addons work on those recipes");
            ENABLE_IF_CUSTOM_ANIMAL_RANCHER_JEI = config.getBoolean("Custom Animal Rancher JEI", "general.if.animal_rancher", true, "Whether to enable its own JEI category");
            this.RAW_IF_CUSTOM_ANIMAL_RANCHER_RECIPES = config.getStringList("Custom Animal Rancher Recipes", "general.if.animal_rancher", new String[]{"minecraft:zombie, water * 100, minecraft:apple * 2, 0.1, 2.0"}, "A list of custom animal rancher recipes (Example: minecraft:zombie, water * 100, minecraft:apple * 2, 0.1, 2.0)\nFormat: <entity_registry_name>,<fluid_output>,<item_output>,<chance>,<damage>\n- <entity_registry_name> is a place to input resource location and optional args\n  - You can use optional args to define model transformation in JEI\n  - Example: rotate_z:180\n- <fluid_output> is a fluid registry name (Optional: * amount) (Put a null is fine)\n- <item_output> is in the form of owner:item_name@optional_meta (Optional: * amount) (Put a null is fine)\n- <chance> is a percentage (e.g. 0.3 = 30%)\n- <damage> is a float (e.g. 2.0)\n\n");
            ENABLE_IF_EIO_CAPACITOR_COMPAT = config.getBoolean("Enable", "general.if.eio_capacitor", false, "Enable Industrial Foregoing Ender IO Capacitor Compat\nA capacitor slot will be added to all CustomElectricMachine subclasses\nAnd machines will be locked without a capacitor");
            ENABLE_IF_EIO_CAPACITOR_ON_REMOVE_CLEAR_ENERGY = config.getBoolean("Enable Energy Removal", "general.if.eio_capacitor", true, "Enable energy storage to clear when removing capacitors (which is Ender IO machine behavior)");
            ENABLE_IF_PLANT_SOWER_MOD = config.getBoolean("Enable", "general.if.plant_sower", false, "Enable Industrial Foregoing Plant Sower Modifications");
            ENABLE_IF_PLANT_SOWER_TEASTORY_COMPAT = config.getBoolean("Enable Tea the Story Compat", "general.if.plant_sower", false, "Allow plant sower to plant Tea the Story crops");
            ENABLE_IF_PLANT_SOWER_EXTRA_ACCEPTABLE_CROPS = config.getBoolean("Enable Extra Acceptable Crops", "general.if.plant_sower", false, "Allow plant sower to accept more crop items");
            this.RAW_IF_PLANT_SOWER_EXTRA_ACCEPTABLE_CROPS = config.getStringList("Extra Acceptable Crops", "general.if.plant_sower", new String[]{"betternether:bone_mushroom"}, "A list of item registry names. Optionally use @meta after the registry name");
        }
        if (currentStage.equals("POST_INIT")) {
            ItemStack itemStack;
            String[] args;
            IF_INFINITY_DRILL_BLACKLIST.clear();
            for (String arg : this.RAW_IF_INFINITY_DRILL_BLACKLIST) {
                Item item;
                args = arg.split("@");
                if (args.length == 0 || args.length > 2) continue;
                int meta = 0;
                if (args.length == 2) {
                    try {
                        meta = Integer.parseInt(args[1]);
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                }
                if ((item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(args[0]))) == null) continue;
                itemStack = new ItemStack(item, 1, meta);
                IF_INFINITY_DRILL_BLACKLIST.add(itemStack);
            }
            IF_PETRIFIED_FUEL_GENERATOR_FUELS.clear();
            for (String arg : this.RAW_IF_PETRIFIED_FUEL_GENERATOR_FUELS) {
                Item item;
                args = arg.split(",");
                if (args.length != 3) continue;
                String key = args[0].trim();
                String rawValue1 = args[1].trim();
                String rawValue2 = args[2].trim();
                String[] itemArgs = key.split("@");
                if (itemArgs.length == 0 || itemArgs.length > 2) continue;
                int meta = 0;
                if (itemArgs.length == 2) {
                    try {
                        meta = Integer.parseInt(itemArgs[1]);
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                }
                if ((item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemArgs[0]))) == null) continue;
                ItemStack itemStack2 = new ItemStack(item, 1, meta);
                int rate = 0;
                try {
                    rate = Integer.parseInt(rawValue1);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                int duration = 0;
                try {
                    duration = Integer.parseInt(rawValue2);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                IF_PETRIFIED_FUEL_GENERATOR_FUELS.put(itemStack2, new FuelDef(rate, duration));
            }
            IF_CUSTOM_ANIMAL_RANCHER_RECIPES.clear();
            for (String arg : this.RAW_IF_CUSTOM_ANIMAL_RANCHER_RECIPES) {
                float damage;
                float chance;
                String[] itemNames;
                args = arg.split(",");
                if (args.length != 5) continue;
                String entityPart = args[0].trim();
                String fluidPart = args[1].trim();
                String itemPart = args[2].trim();
                String chancePart = args[3].trim();
                String damagePart = args[4].trim();
                int index = 1;
                char c = entityPart.charAt(index);
                while (index < entityPart.length() && c != ' ') {
                    c = entityPart.charAt(index++);
                }
                String entityRegistryName = entityPart.substring(0, index).trim();
                ArrayList<String> entityArgs = new ArrayList<String>();
                while (index < entityPart.length()) {
                    while (index < entityPart.length() && c == ' ') {
                        c = entityPart.charAt(index++);
                    }
                    int start = index - 1;
                    while (index < entityPart.length() && c != ' ') {
                        c = entityPart.charAt(index++);
                    }
                    entityArgs.add(entityPart.substring(start, index));
                }
                String[] fluidArgs = fluidPart.split("\\*");
                String[] itemArgs = itemPart.split("\\*");
                if (fluidArgs.length == 0 || fluidArgs.length > 2 || itemArgs.length == 0 || itemArgs.length > 2) continue;
                int fluidAmount = 1;
                if (fluidArgs.length == 2) {
                    try {
                        fluidAmount = Integer.parseInt(fluidArgs[1].trim());
                    }
                    catch (NumberFormatException ignored) {
                        continue;
                    }
                }
                String fluidName = fluidArgs[0].trim();
                int itemCount = 1;
                if (itemArgs.length == 2) {
                    try {
                        itemCount = Integer.parseInt(itemArgs[1].trim());
                    }
                    catch (NumberFormatException ignored) {
                        continue;
                    }
                }
                if ((itemNames = itemArgs[0].trim().split("@")).length == 0 || itemNames.length > 2) continue;
                String itemName = itemNames[0];
                int itemMeta = 0;
                if (itemNames.length == 2) {
                    try {
                        itemMeta = Integer.parseInt(itemNames[1]);
                    }
                    catch (NumberFormatException ignored) {
                        continue;
                    }
                }
                try {
                    chance = Float.parseFloat(chancePart);
                }
                catch (NumberFormatException ignored) {
                    continue;
                }
                try {
                    damage = Float.parseFloat(damagePart);
                }
                catch (NumberFormatException ignored) {
                    continue;
                }
                EntityEntry entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(entityRegistryName));
                if (entry == null) continue;
                AnimalRancherOutput value = new AnimalRancherOutput();
                for (String entityArg : entityArgs) {
                    String[] keyValue = entityArg.split(":");
                    if (keyValue.length != 2) continue;
                    String keyArg = keyValue[0].trim();
                    float valueFloat = 0.0f;
                    try {
                        valueFloat = Float.parseFloat(keyValue[1].trim());
                    }
                    catch (NumberFormatException ignored) {
                        continue;
                    }
                    switch (keyArg) {
                        case "rotate_x": {
                            value.modelRotateX = valueFloat;
                        }
                        case "rotate_y": {
                            value.modelRotateY = valueFloat;
                        }
                        case "rotate_z": {
                            value.modelRotateZ = valueFloat;
                        }
                        case "scale_x": {
                            value.modelScaleX = valueFloat;
                        }
                        case "scale_y": {
                            value.modelScaleY = valueFloat;
                        }
                        case "scale_z": {
                            value.modelScaleZ = valueFloat;
                        }
                        case "pos_x": {
                            value.modelPosX = valueFloat;
                        }
                        case "pos_y": {
                            value.modelPosY = valueFloat;
                        }
                    }
                }
                Fluid fluid = FluidRegistry.getFluid((String)fluidName);
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
                if (fluid == null && item == null) continue;
                if (fluid != null) {
                    value.fluidStack = new FluidStack(fluid, fluidAmount);
                }
                if (item != null) {
                    value.itemStack = new ItemStack(item, itemCount, itemMeta);
                }
                value.chance = chance;
                value.damage = damage;
                IF_CUSTOM_ANIMAL_RANCHER_RECIPES.put(entry, value);
            }
            IF_PLANT_SOWER_EXTRA_ACCEPTABLE_CROPS.clear();
            for (String arg : this.RAW_IF_PLANT_SOWER_EXTRA_ACCEPTABLE_CROPS) {
                Item item;
                String[] itemArgs = arg.split("@");
                if (itemArgs.length == 0 || itemArgs.length > 2) continue;
                int meta = 0;
                if (itemArgs.length == 2) {
                    try {
                        meta = Integer.parseInt(itemArgs[1]);
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                }
                if ((item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemArgs[0]))) == null) continue;
                itemStack = new ItemStack(item, 1, meta);
                IF_PLANT_SOWER_EXTRA_ACCEPTABLE_CROPS.add(itemStack);
            }
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        if (IS_MOD_LOADED) {
            if (OMEConfig.ENABLE && ENABLE_IF_MODULE && ENABLE_IF_INFINITY_DRILL_BLACKLIST) {
                MinecraftForge.EVENT_BUS.register(InfinityDrillBlacklist.class);
            }
            if (OMEConfig.ENABLE && ENABLE_IF_MODULE && ENABLE_IF_INFINITY_DRILL_HARVEST_LEVEL) {
                MinecraftForge.EVENT_BUS.register(InfinityDrillHarvestLevel.class);
            }
        }
    }

    static {
        IF_INFINITY_DRILL_BLACKLIST = new ArrayList<ItemStack>();
        IF_INFINITY_DRILL_HARVEST_LEVEL = new Hashtable<String, Integer>();
        IF_PETRIFIED_FUEL_GENERATOR_FUELS = new HashMap<ItemStack, FuelDef>();
        IF_CUSTOM_ANIMAL_RANCHER_RECIPES = new HashMap<EntityEntry, AnimalRancherOutput>();
        IF_PLANT_SOWER_EXTRA_ACCEPTABLE_CROPS = new ArrayList<ItemStack>();
    }
}

