/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ometweaks.integration.industrialforegoing.machine.capacitor;

import com.tttsaurus.ometweaks.function.IAction_2Param;
import com.tttsaurus.ometweaks.function.IAction_3Param;
import com.tttsaurus.ometweaks.integration.industrialforegoing.IndustrialForegoingModule;
import com.tttsaurus.ometweaks.integration.industrialforegoing.machine.IMachineEnergyStorageProvider;
import com.tttsaurus.ometweaks.integration.industrialforegoing.machine.capacitor.gui.CapacitorIndicatorGuiPiece;
import com.tttsaurus.ometweaks.integration.industrialforegoing.machine.capacitor.gui.CapacitorSideBarGuiPiece;
import crazypants.enderio.api.capacitor.CapabilityCapacitorData;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.containers.BasicTeslaContainer;
import net.ndrei.teslacorelib.containers.FilteredSlot;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.ColoredItemHandler;
import net.ndrei.teslacorelib.inventory.EnergyStorage;
import net.ndrei.teslacorelib.tileentities.ElectricMachine;
import net.ndrei.teslacorelib.tileentities.SidedTileEntity;

public class CapacitorInventoryInjector {
    private static boolean isFuncsInit = false;
    private static IAction_2Param<SidedTileEntity, IItemHandler> addInventory;
    private static IAction_3Param<SidedTileEntity, ItemStackHandler, String> addInventoryToStorage;

    private static void initFuncs() {
        if (!isFuncsInit) {
            MethodHandle handle;
            isFuncsInit = true;
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            try {
                Method addInventory = SidedTileEntity.class.getDeclaredMethod("addInventory", IItemHandler.class);
                addInventory.setAccessible(true);
                handle = lookup.unreflect(addInventory);
                CapacitorInventoryInjector.addInventory = (arg0, arg1) -> {
                    try {
                        handle.invoke((SidedTileEntity)arg0, (IItemHandler)arg1);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                };
            }
            catch (Exception addInventory) {
                // empty catch block
            }
            try {
                Method addInventoryToStorage = SidedTileEntity.class.getDeclaredMethod("addInventoryToStorage", ItemStackHandler.class, String.class);
                addInventoryToStorage.setAccessible(true);
                handle = lookup.unreflect(addInventoryToStorage);
                CapacitorInventoryInjector.addInventoryToStorage = (arg0, arg1, arg2) -> {
                    try {
                        handle.invoke((SidedTileEntity)arg0, (ItemStackHandler)arg1, (String)arg2);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                };
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static ItemStackHandler addCapacitorInventory(final ElectricMachine machine) {
        CapacitorInventoryInjector.initFuncs();
        final ItemStackHandler itemStackHandler = new ItemStackHandler(1){

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                IMachineEnergyStorageProvider provider;
                EnergyStorage energyStorage;
                if (IndustrialForegoingModule.ENABLE_IF_EIO_CAPACITOR_ON_REMOVE_CLEAR_ENERGY && (energyStorage = (provider = (IMachineEnergyStorageProvider)machine).getEnergyStorage()) != null) {
                    energyStorage.takePower(Long.MAX_VALUE);
                }
                return super.extractItem(slot, amount, simulate);
            }

            protected void onContentsChanged(int slot) {
                machine.func_70296_d();
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
        addInventory.invoke((SidedTileEntity)machine, (IItemHandler)new ColoredItemHandler((IItemHandler)itemStackHandler, EnumDyeColor.PURPLE, "capacitor", new BoundingRectangle(-15, 60, 18, 18)){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return stack.hasCapability(CapabilityCapacitorData.getCapNN(), null);
            }

            public boolean canExtractItem(int slot) {
                return true;
            }

            public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
                List pieces = super.getGuiContainerPieces(container);
                BoundingRectangle box = this.getBoundingBox();
                int left = box.getLeft();
                int top = box.getTop();
                pieces.add(new CapacitorSideBarGuiPiece(left, top, 18, 24));
                pieces.add(new CapacitorIndicatorGuiPiece(left, top, itemStackHandler));
                return pieces;
            }

            public List<Slot> getSlots(BasicTeslaContainer container) {
                List slots = super.getSlots(container);
                BoundingRectangle boundingRectangle = this.getBoundingBox();
                for (int y = 0; y < this.getInnerHandler().getSlots(); ++y) {
                    slots.add(new FilteredSlot(this.getItemHandlerForContainer(), y, boundingRectangle.getLeft() + 1, boundingRectangle.getTop() + 1 + y * 18));
                }
                return slots;
            }
        });
        addInventoryToStorage.invoke((SidedTileEntity)machine, itemStackHandler, "capacitor_slot");
        return itemStackHandler;
    }
}

