/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ometweaks.mixins.jei;

import com.tttsaurus.ometweaks.integration.jei.JEIModule;
import com.tttsaurus.ometweaks.integration.jei.category.CategoryModification;
import com.tttsaurus.ometweaks.integration.jei.category.DynamicCategoryWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.ingredients.IngredientRegistry;
import mezz.jei.recipes.RecipeRegistry;
import mezz.jei.startup.ModRegistry;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ModRegistry.class})
public class JEIModRegistryMixin {
    @Final
    @Shadow(remap=false)
    private List<IRecipeCategory> recipeCategories;

    @Inject(method={"createRecipeRegistry"}, at={@At(value="HEAD")}, remap=false)
    public void createRecipeRegistry(IngredientRegistry ingredientRegistry, CallbackInfoReturnable<RecipeRegistry> cir) {
        ArrayList<IRecipeCategory> newRecipeCategories = new ArrayList<IRecipeCategory>();
        newRecipeCategories.addAll(this.recipeCategories);
        if (JEIModule.ENABLE_JEI_CATEGORY_MODIFICATION) {
            HashMap substitutions = new HashMap();
            for (int i = 0; i < newRecipeCategories.size(); ++i) {
                IRecipeCategory category = (IRecipeCategory)newRecipeCategories.get(i);
                for (Map.Entry<String, CategoryModification> entry : JEIModule.JEI_CATEGORY_MODIFICATION.entrySet()) {
                    if (!category.getUid().equals(entry.getKey())) continue;
                    CategoryModification categoryMod = entry.getValue();
                    if (categoryMod.iconRL != null) {
                        substitutions.put(i, new DynamicCategoryWrapper(category, categoryMod.iconRL));
                        continue;
                    }
                    if (categoryMod.iconItem == null && !categoryMod.isGhostItem) continue;
                    DynamicCategoryWrapper dynamicCategoryWrapper = new DynamicCategoryWrapper(category, categoryMod.iconItem);
                    if (categoryMod.isGhostItem) {
                        dynamicCategoryWrapper.setDrawableGhostItemHandler(categoryMod);
                    }
                    substitutions.put(i, dynamicCategoryWrapper);
                }
            }
            for (Map.Entry entry : substitutions.entrySet()) {
                newRecipeCategories.set((Integer)entry.getKey(), (IRecipeCategory)entry.getValue());
            }
        }
        this.recipeCategories.clear();
        this.recipeCategories.addAll(newRecipeCategories);
    }
}

