/*
 * Decompiled with CFR 0.152.
 */
package com.tttsaurus.ometweaks.render;

import com.tttsaurus.ometweaks.render.CommonBuffers;
import com.tttsaurus.ometweaks.render.ImagePrefab;
import com.tttsaurus.ometweaks.render.NinePatchBorder;
import com.tttsaurus.ometweaks.render.Texture2D;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public final class RenderUtils {
    private static int textureID = 0;
    private static float r = 0.0f;
    private static float g = 0.0f;
    private static float b = 0.0f;
    private static float a = 0.0f;
    private static boolean blend = false;
    private static boolean lighting = false;
    private static boolean texture2D = false;
    private static boolean alphaTest = false;
    private static int shadeModel = 0;
    private static boolean depthTest = false;
    private static boolean cullFace = false;
    private static int blendSrcRgb;
    private static int blendDstRgb;
    private static int blendSrcAlpha;
    private static int blendDstAlpha;
    private static int alphaFunc;
    private static float alphaRef;
    public static FontRenderer fontRenderer;
    public static float zLevel;

    public static void storeCommonGlStates() {
        GL11.glGetInteger((int)32873, (IntBuffer)CommonBuffers.INT_BUFFER_16);
        textureID = CommonBuffers.INT_BUFFER_16.get(0);
        GL11.glGetFloat((int)2816, (FloatBuffer)CommonBuffers.FLOAT_BUFFER_16);
        r = CommonBuffers.FLOAT_BUFFER_16.get(0);
        g = CommonBuffers.FLOAT_BUFFER_16.get(1);
        b = CommonBuffers.FLOAT_BUFFER_16.get(2);
        a = CommonBuffers.FLOAT_BUFFER_16.get(3);
        blend = GL11.glIsEnabled((int)3042);
        lighting = GL11.glIsEnabled((int)2896);
        texture2D = GL11.glIsEnabled((int)3553);
        alphaTest = GL11.glIsEnabled((int)3008);
        GL11.glGetInteger((int)2900, (IntBuffer)CommonBuffers.INT_BUFFER_16);
        shadeModel = CommonBuffers.INT_BUFFER_16.get(0);
        depthTest = GL11.glIsEnabled((int)2929);
        cullFace = GL11.glIsEnabled((int)2884);
        GL11.glGetInteger((int)32969, (IntBuffer)CommonBuffers.INT_BUFFER_16);
        blendSrcRgb = CommonBuffers.INT_BUFFER_16.get(0);
        GL11.glGetInteger((int)32968, (IntBuffer)CommonBuffers.INT_BUFFER_16);
        blendDstRgb = CommonBuffers.INT_BUFFER_16.get(0);
        GL11.glGetInteger((int)32971, (IntBuffer)CommonBuffers.INT_BUFFER_16);
        blendSrcAlpha = CommonBuffers.INT_BUFFER_16.get(0);
        GL11.glGetInteger((int)32970, (IntBuffer)CommonBuffers.INT_BUFFER_16);
        blendDstAlpha = CommonBuffers.INT_BUFFER_16.get(0);
        GL11.glGetInteger((int)3009, (IntBuffer)CommonBuffers.INT_BUFFER_16);
        alphaFunc = CommonBuffers.INT_BUFFER_16.get(0);
        GL11.glGetFloat((int)3010, (FloatBuffer)CommonBuffers.FLOAT_BUFFER_16);
        alphaRef = CommonBuffers.FLOAT_BUFFER_16.get(0);
    }

    public static void restoreCommonGlStates() {
        GlStateManager.func_179092_a((int)alphaFunc, (float)alphaRef);
        GlStateManager.func_179120_a((int)blendSrcRgb, (int)blendDstRgb, (int)blendSrcAlpha, (int)blendDstAlpha);
        if (cullFace) {
            GlStateManager.func_179089_o();
        } else {
            GlStateManager.func_179129_p();
        }
        if (depthTest) {
            GlStateManager.func_179126_j();
        } else {
            GlStateManager.func_179097_i();
        }
        GlStateManager.func_179103_j((int)shadeModel);
        if (alphaTest) {
            GlStateManager.func_179141_d();
        } else {
            GlStateManager.func_179118_c();
        }
        if (texture2D) {
            GlStateManager.func_179098_w();
        } else {
            GlStateManager.func_179090_x();
        }
        if (lighting) {
            GlStateManager.func_179145_e();
        } else {
            GlStateManager.func_179140_f();
        }
        if (blend) {
            GlStateManager.func_179147_l();
        } else {
            GlStateManager.func_179084_k();
        }
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
        GlStateManager.func_179144_i((int)textureID);
    }

    private static void addArcVertices(BufferBuilder bufferbuilder, float cx, float cy, float radius, float startAngle, float endAngle, int segments) {
        endAngle -= 90.0f;
        float x = (float)((double)cx + Math.cos(Math.toRadians(startAngle -= 90.0f)) * (double)radius);
        float y = (float)((double)cy + Math.sin(Math.toRadians(startAngle)) * (double)radius);
        for (int i = 1; i <= segments; ++i) {
            float angle = (float)Math.toRadians(startAngle + (endAngle - startAngle) * (float)i / (float)segments);
            float dx = (float)((double)cx + Math.cos(angle) * (double)radius);
            float dy = (float)((double)cy + Math.sin(angle) * (double)radius);
            bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_181675_d();
            bufferbuilder.func_181662_b((double)dx, (double)dy, 0.0).func_181675_d();
            x = dx;
            y = dy;
        }
    }

    public static void renderText(String text, float x, float y, float scale, int color, boolean shadow) {
        GlStateManager.func_179129_p();
        GlStateManager.func_179098_w();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179097_i();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)zLevel);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)0.0f);
        fontRenderer.func_175065_a(text, 0.0f, 0.0f, color, shadow);
        GlStateManager.func_179121_F();
    }

    public static void renderRoundedRect(float x, float y, float width, float height, float radius, int color) {
        int segments = Math.max(5, (int)(radius / 2.0f));
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179129_p();
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)zLevel);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181705_e);
        RenderUtils.addArcVertices(bufferbuilder, x + width - radius, y + radius, radius, 0.0f, 90.0f, segments);
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + radius), 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height - radius), 0.0).func_181675_d();
        RenderUtils.addArcVertices(bufferbuilder, x + width - radius, y + height - radius, radius, 90.0f, 180.0f, segments);
        bufferbuilder.func_181662_b((double)(x + width - radius), (double)(y + height), 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + radius), (double)(y + height), 0.0).func_181675_d();
        RenderUtils.addArcVertices(bufferbuilder, x + radius, y + height - radius, radius, 180.0f, 270.0f, segments);
        bufferbuilder.func_181662_b((double)x, (double)(y + height - radius), 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)(y + radius), 0.0).func_181675_d();
        RenderUtils.addArcVertices(bufferbuilder, x + radius, y + radius, radius, 270.0f, 360.0f, segments);
        bufferbuilder.func_181662_b((double)(x + radius), (double)y, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width - radius), (double)y, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }

    public static void renderRect(float x, float y, float width, float height, int color) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)zLevel);
        GlStateManager.func_179152_a((float)width, (float)height, (float)0.0f);
        Gui.func_73734_a((int)0, (int)0, (int)1, (int)1, (int)color);
        GlStateManager.func_179121_F();
    }

    public static void renderImagePrefab(float x, float y, float width, float height, ImagePrefab imagePrefab) {
        switch (imagePrefab.type) {
            case TEXTURE_2D: {
                RenderUtils.renderTexture2D(x, y, width, height, imagePrefab.texture2D.getGlTextureID(), -1);
                break;
            }
            case NINE_PATCH_BORDER: {
                RenderUtils.renderNinePatchBorder(x, y, width, height, imagePrefab.ninePatchBorder, -1);
            }
        }
    }

    public static void renderImagePrefab(float x, float y, float width, float height, ImagePrefab imagePrefab, int color) {
        switch (imagePrefab.type) {
            case TEXTURE_2D: {
                RenderUtils.renderTexture2D(x, y, width, height, imagePrefab.texture2D.getGlTextureID(), color);
                break;
            }
            case NINE_PATCH_BORDER: {
                RenderUtils.renderNinePatchBorder(x, y, width, height, imagePrefab.ninePatchBorder, color);
            }
        }
    }

    public static void renderNinePatchBorder(float x, float y, float width, float height, NinePatchBorder ninePatchBorder) {
        RenderUtils.renderNinePatchBorder(x, y, width, height, ninePatchBorder, -1);
    }

    public static void renderNinePatchBorder(float x, float y, float width, float height, NinePatchBorder ninePatchBorder, int color) {
        float height5;
        float width5;
        float height4;
        float width4;
        float height2;
        float width2;
        float height1;
        float width1;
        float ppu = 1.0f;
        if (ninePatchBorder.topLeft.sizeDeductionByPixels) {
            width1 = (float)ninePatchBorder.topLeft.tex.getWidth() / ppu;
            height1 = (float)ninePatchBorder.topLeft.tex.getHeight() / ppu;
        } else {
            width1 = ninePatchBorder.topLeft.width;
            height1 = ninePatchBorder.topLeft.height;
        }
        RenderUtils.renderTexture2D(x, y, width1, height1, 1.0f, 1.0f, ninePatchBorder.topLeft.tex.getGlTextureID(), color);
        if (ninePatchBorder.topRight.sizeDeductionByPixels) {
            width2 = (float)ninePatchBorder.topRight.tex.getWidth() / ppu;
            height2 = (float)ninePatchBorder.topRight.tex.getHeight() / ppu;
        } else {
            width2 = ninePatchBorder.topRight.width;
            height2 = ninePatchBorder.topRight.height;
        }
        RenderUtils.renderTexture2D(x + width - width2, y, width2, height2, 1.0f, 1.0f, ninePatchBorder.topRight.tex.getGlTextureID(), color);
        if (width - width1 - width2 > 0.0f) {
            float height3;
            float width3;
            if (ninePatchBorder.topCenter.sizeDeductionByPixels) {
                width3 = (float)ninePatchBorder.topCenter.tex.getWidth() / ppu;
                height3 = (float)ninePatchBorder.topCenter.tex.getHeight() / ppu;
            } else {
                width3 = ninePatchBorder.topCenter.width;
                height3 = ninePatchBorder.topCenter.height;
            }
            if (ninePatchBorder.topCenter.tiling) {
                RenderUtils.renderTexture2D(x + width1, y, width - width1 - width2, height3, (width - width1 - width2) / width3, 1.0f, ninePatchBorder.topCenter.tex.getGlTextureID(), color);
            } else {
                RenderUtils.renderTexture2D(x + width1, y, width - width1 - width2, height3, 1.0f, 1.0f, ninePatchBorder.topCenter.tex.getGlTextureID(), color);
            }
        }
        if (ninePatchBorder.bottomLeft.sizeDeductionByPixels) {
            width4 = (float)ninePatchBorder.bottomLeft.tex.getWidth() / ppu;
            height4 = (float)ninePatchBorder.bottomLeft.tex.getHeight() / ppu;
        } else {
            width4 = ninePatchBorder.bottomLeft.width;
            height4 = ninePatchBorder.bottomLeft.height;
        }
        RenderUtils.renderTexture2D(x, y + height - height4, width4, height4, 1.0f, 1.0f, ninePatchBorder.bottomLeft.tex.getGlTextureID(), color);
        if (ninePatchBorder.bottomRight.sizeDeductionByPixels) {
            width5 = (float)ninePatchBorder.bottomRight.tex.getWidth() / ppu;
            height5 = (float)ninePatchBorder.bottomRight.tex.getHeight() / ppu;
        } else {
            width5 = ninePatchBorder.bottomRight.width;
            height5 = ninePatchBorder.bottomRight.height;
        }
        RenderUtils.renderTexture2D(x + width - width5, y + height - height5, width5, height5, 1.0f, 1.0f, ninePatchBorder.bottomRight.tex.getGlTextureID(), color);
        if (width - width4 - width5 > 0.0f) {
            float height6;
            float width6;
            if (ninePatchBorder.bottomCenter.sizeDeductionByPixels) {
                width6 = (float)ninePatchBorder.bottomCenter.tex.getWidth() / ppu;
                height6 = (float)ninePatchBorder.bottomCenter.tex.getHeight() / ppu;
            } else {
                width6 = ninePatchBorder.bottomCenter.width;
                height6 = ninePatchBorder.bottomCenter.height;
            }
            if (ninePatchBorder.bottomCenter.tiling) {
                RenderUtils.renderTexture2D(x + width4, y + height - height6, width - width4 - width5, height6, (width - width4 - width5) / width6, 1.0f, ninePatchBorder.bottomCenter.tex.getGlTextureID(), color);
            } else {
                RenderUtils.renderTexture2D(x + width4, y + height - height6, width - width4 - width5, height6, 1.0f, 1.0f, ninePatchBorder.bottomCenter.tex.getGlTextureID(), color);
            }
        }
        if (height - height1 - height4 > 0.0f) {
            float height7;
            float width7;
            if (ninePatchBorder.centerLeft.sizeDeductionByPixels) {
                width7 = (float)ninePatchBorder.centerLeft.tex.getWidth() / ppu;
                height7 = (float)ninePatchBorder.centerLeft.tex.getHeight() / ppu;
            } else {
                width7 = ninePatchBorder.centerLeft.width;
                height7 = ninePatchBorder.centerLeft.height;
            }
            if (ninePatchBorder.centerLeft.tiling) {
                RenderUtils.renderTexture2D(x, y + height1, width7, height - height1 - height4, 1.0f, (height - height1 - height4) / height7, ninePatchBorder.centerLeft.tex.getGlTextureID(), color);
            } else {
                RenderUtils.renderTexture2D(x, y + height1, width7, height - height1 - height4, 1.0f, 1.0f, ninePatchBorder.centerLeft.tex.getGlTextureID(), color);
            }
        }
        if (height - height2 - height5 > 0.0f) {
            float height8;
            float width8;
            if (ninePatchBorder.centerRight.sizeDeductionByPixels) {
                width8 = (float)ninePatchBorder.centerRight.tex.getWidth() / ppu;
                height8 = (float)ninePatchBorder.centerRight.tex.getHeight() / ppu;
            } else {
                width8 = ninePatchBorder.centerRight.width;
                height8 = ninePatchBorder.centerRight.height;
            }
            if (ninePatchBorder.centerRight.tiling) {
                RenderUtils.renderTexture2D(x + width - width8, y + height2, width8, height - height2 - height5, 1.0f, (height - height2 - height5) / height8, ninePatchBorder.centerRight.tex.getGlTextureID(), color);
            } else {
                RenderUtils.renderTexture2D(x + width - width8, y + height2, width8, height - height2 - height5, 1.0f, 1.0f, ninePatchBorder.centerRight.tex.getGlTextureID(), color);
            }
        }
        if (width - width1 - width2 > 0.0f && height - height1 - height4 > 0.0f) {
            float height9;
            float width9;
            if (ninePatchBorder.center.sizeDeductionByPixels) {
                width9 = (float)ninePatchBorder.center.tex.getWidth() / ppu;
                height9 = (float)ninePatchBorder.center.tex.getHeight() / ppu;
            } else {
                width9 = ninePatchBorder.center.width;
                height9 = ninePatchBorder.center.height;
            }
            if (ninePatchBorder.center.tiling) {
                RenderUtils.renderTexture2D(x + width1, y + height1, width - width1 - width2, height - height1 - height4, (width - width1 - width2) / width9, (height - height1 - height4) / height9, ninePatchBorder.center.tex.getGlTextureID(), color);
            } else {
                RenderUtils.renderTexture2D(x + width1, y + height1, width - width1 - width2, height - height1 - height4, 1.0f, 1.0f, ninePatchBorder.center.tex.getGlTextureID(), color);
            }
        }
    }

    public static void renderTexture2D(float x, float y, float width, float height, int textureId) {
        RenderUtils.renderTexture2D(x, y, width, height, 1.0f, 1.0f, textureId);
    }

    public static void renderTexture2D(float x, float y, float width, float height, int textureId, int color) {
        RenderUtils.renderTexture2D(x, y, width, height, 1.0f, 1.0f, textureId, color);
    }

    public static void renderTexture2D(float x, float y, float width, float height, float widthTiling, float heightTiling, int textureId) {
        RenderUtils.renderTexture2D(x, y, width, height, widthTiling, heightTiling, textureId, -1);
    }

    public static void renderTexture2D(float x, float y, float width, float height, float widthTiling, float heightTiling, int textureId, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179098_w();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        GlStateManager.func_179097_i();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
        GlStateManager.func_179144_i((int)textureId);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x, (double)(y + height), (double)zLevel).func_187315_a(0.0, (double)heightTiling).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), (double)zLevel).func_187315_a((double)widthTiling, (double)heightTiling).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, (double)zLevel).func_187315_a((double)widthTiling, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, (double)zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void renderTexture2DFullScreen(int textureId) {
        RenderUtils.renderTexture2DFullScreen(textureId, 1.0f, 1.0f);
    }

    public static void renderTexture2DFullScreen(int textureId, int color) {
        RenderUtils.renderTexture2DFullScreen(textureId, 1.0f, 1.0f, color);
    }

    public static void renderTexture2DFullScreen(int textureId, float widthTiling, float heightTiling) {
        RenderUtils.renderTexture2DFullScreen(textureId, widthTiling, heightTiling, -1);
    }

    public static void renderTexture2DFullScreen(int textureId, float widthTiling, float heightTiling, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        ScaledResolution resolution = new ScaledResolution(Minecraft.func_71410_x());
        double width = resolution.func_78327_c();
        double height = resolution.func_78324_d();
        GlStateManager.func_179098_w();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        GlStateManager.func_179097_i();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
        GlStateManager.func_179144_i((int)textureId);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(0.0, height, (double)zLevel).func_187315_a(0.0, (double)heightTiling).func_181675_d();
        buffer.func_181662_b(width, height, (double)zLevel).func_187315_a((double)widthTiling, (double)heightTiling).func_181675_d();
        buffer.func_181662_b(width, 0.0, (double)zLevel).func_187315_a((double)widthTiling, 0.0).func_181675_d();
        buffer.func_181662_b(0.0, 0.0, (double)zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    @Nullable
    public static Texture2D createTexture2D(BufferedImage bufferedImage) {
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        if (width == 0 || height == 0) {
            return null;
        }
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(width * height * 4));
        int[] pixels = new int[width * height];
        bufferedImage.getRGB(0, 0, width, height, pixels, 0, width);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int pixel = pixels[y * width + x];
                buffer.put((byte)(pixel >> 16 & 0xFF));
                buffer.put((byte)(pixel >> 8 & 0xFF));
                buffer.put((byte)(pixel & 0xFF));
                buffer.put((byte)(pixel >> 24 & 0xFF));
            }
        }
        buffer.flip();
        return new Texture2D(width, height, buffer);
    }

    static {
        fontRenderer = Minecraft.func_71410_x().field_71466_p;
        zLevel = 0.0f;
    }
}

