/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.webhooklogger.common.config;

import fi.fabianadrian.webhooklogger.dependency.org.spongepowered.configurate.CommentedConfigurationNode;
import fi.fabianadrian.webhooklogger.dependency.org.spongepowered.configurate.ConfigurateException;
import fi.fabianadrian.webhooklogger.dependency.org.spongepowered.configurate.ConfigurationOptions;
import fi.fabianadrian.webhooklogger.dependency.org.spongepowered.configurate.objectmapping.ObjectMapper;
import fi.fabianadrian.webhooklogger.dependency.org.spongepowered.configurate.serialize.SerializationException;
import fi.fabianadrian.webhooklogger.dependency.org.spongepowered.configurate.yaml.NodeStyle;
import fi.fabianadrian.webhooklogger.dependency.org.spongepowered.configurate.yaml.YamlConfigurationLoader;
import java.nio.file.Path;
import java.util.function.UnaryOperator;

public final class ConfigLoader<C> {
    private final YamlConfigurationLoader loader;
    private final ObjectMapper<C> mapper;

    public ConfigLoader(Class<C> configClass, Path configPath, UnaryOperator<ConfigurationOptions> options) {
        try {
            this.mapper = ObjectMapper.factory().get(configClass);
        }
        catch (SerializationException e) {
            throw new IllegalStateException("Failed to initialize an object mapper for type: " + configClass.getSimpleName(), e);
        }
        this.loader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(configPath)).nodeStyle(NodeStyle.BLOCK).defaultOptions(options)).build();
    }

    public C load() throws ConfigurateException {
        CommentedConfigurationNode node = (CommentedConfigurationNode)this.loader.load();
        return this.mapper.load(node);
    }

    public void save(C config) throws ConfigurateException {
        CommentedConfigurationNode node = (CommentedConfigurationNode)this.loader.createNode();
        this.mapper.save(config, node);
        this.loader.save(node);
    }
}

