/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.webhooklogger.dependency.dev.vankka.mcdiscordreserializer.rules;

import dev.vankka.simpleast.core.node.Node;
import dev.vankka.simpleast.core.node.TextNode;
import java.util.List;

public class StyleNode<RC, T>
extends Node<RC> {
    private final List<T> styles;

    public StyleNode(List<T> styles) {
        this.styles = styles;
    }

    public List<T> getStyles() {
        return this.styles;
    }

    public String toString() {
        return "StyleNode{styles=" + this.styles + ", children=" + this.getChildren() + "}";
    }

    public static <RC> StyleNode<RC, Style> createWithText(String content, List<Style> styles) {
        StyleNode<RC, Style> styleNode = new StyleNode<RC, Style>(styles);
        styleNode.addChild(new TextNode(content));
        return styleNode;
    }

    public static enum Styles implements Style
    {
        BOLD,
        UNDERLINE,
        STRIKETHROUGH,
        CODE_STRING,
        MASKED_LINK,
        LIST;

    }

    public static class ContentStyle
    implements Style {
        private final Type type;
        private final String content;

        public ContentStyle(Type type, String content) {
            this.type = type;
            this.content = content;
        }

        public Type getType() {
            return this.type;
        }

        public String getContent() {
            return this.content;
        }

        @Override
        public String name() {
            return this.type.name();
        }

        public static enum Type {
            QUOTE,
            SPOILER,
            LINK;

        }
    }

    public static class ItalicStyle
    implements Style {
        private final boolean italics;

        public ItalicStyle(boolean italics) {
            this.italics = italics;
        }

        public boolean isItalics() {
            return this.italics;
        }

        @Override
        public String name() {
            return "ITALICS";
        }
    }

    public static class EmojiStyle
    implements Style {
        private final String id;
        private final String name;

        public EmojiStyle(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String name() {
            return "EMOJI_MENTION";
        }
    }

    public static class MentionStyle
    implements Style {
        private final Type type;
        private final String id;

        public MentionStyle(Type type, String id) {
            this.type = type;
            this.id = id;
        }

        public Type getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String name() {
            return this.type.name() + "_NAME";
        }

        public static enum Type {
            CHANNEL,
            USER,
            ROLE;

        }
    }

    public static class CodeBlockStyle
    implements Style {
        private final String language;

        public CodeBlockStyle(String language) {
            this.language = language;
        }

        public String getLanguage() {
            return this.language;
        }

        @Override
        public String name() {
            return "CODE_BLOCK";
        }
    }

    public static interface Style {
        public String name();
    }
}

