/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.webhooklogger.paper;

import fi.fabianadrian.webhooklogger.common.WebhookLogger;
import fi.fabianadrian.webhooklogger.common.dependency.Dependency;
import fi.fabianadrian.webhooklogger.common.listener.ListenerManager;
import fi.fabianadrian.webhooklogger.common.platform.Platform;
import fi.fabianadrian.webhooklogger.dependency.org.bstats.bukkit.Metrics;
import fi.fabianadrian.webhooklogger.dependency.org.incendo.cloud.CommandManager;
import fi.fabianadrian.webhooklogger.dependency.org.incendo.cloud.SenderMapper;
import fi.fabianadrian.webhooklogger.dependency.org.incendo.cloud.execution.ExecutionCoordinator;
import fi.fabianadrian.webhooklogger.dependency.org.incendo.cloud.paper.PaperCommandManager;
import fi.fabianadrian.webhooklogger.dependency.org.spongepowered.configurate.ConfigurateException;
import fi.fabianadrian.webhooklogger.paper.listener.PaperListenerManager;
import fi.fabianadrian.webhooklogger.paper.platform.PaperCommandSender;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.text.PaperComponents;
import java.nio.file.Path;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.slf4j.Logger;

public final class WebhookLoggerPaper
extends JavaPlugin
implements Platform {
    private WebhookLogger webhookLogger;
    private PaperCommandManager<Audience> commandManager;
    private PaperListenerManager listenerManager;

    public void onEnable() {
        this.createCommandManager();
        this.listenerManager = new PaperListenerManager(this);
        this.webhookLogger = new WebhookLogger(this);
        try {
            this.webhookLogger.startup();
        }
        catch (ConfigurateException e) {
            this.getSLF4JLogger().error("Couldn't load configuration", (Throwable)e);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        PluginManager manager = this.getServer().getPluginManager();
        if (manager.isPluginEnabled("MiniPlaceholders")) {
            this.webhookLogger.dependencyManager().markAsPresent(Dependency.MINI_PLACEHOLDERS);
        }
        new Metrics(this, 18436);
    }

    public void onDisable() {
        this.webhookLogger.shutdown();
    }

    @Override
    public Logger logger() {
        return this.getSLF4JLogger();
    }

    @Override
    public Path configPath() {
        return this.getDataFolder().toPath();
    }

    @Override
    public CommandManager<Audience> commandManager() {
        return this.commandManager;
    }

    @Override
    public ListenerManager listenerManager() {
        return this.listenerManager;
    }

    @Override
    public ComponentFlattener componentFlattener() {
        return PaperComponents.flattener();
    }

    public WebhookLogger webhookLogger() {
        return this.webhookLogger;
    }

    private void createCommandManager() {
        SenderMapper<CommandSourceStack, Audience> mapper = SenderMapper.create(PaperCommandSender::new, audience -> ((PaperCommandSender)audience).stack());
        this.commandManager = PaperCommandManager.builder(mapper).executionCoordinator(ExecutionCoordinator.simpleCoordinator()).buildOnEnable((Plugin)this);
    }
}

