/*
 * Decompiled with CFR 0.152.
 */
package fi.fabianadrian.webhooklogger.paper.listener.listeners;

import fi.fabianadrian.webhooklogger.common.WebhookLogger;
import fi.fabianadrian.webhooklogger.common.config.event.DeathEventConfig;
import fi.fabianadrian.webhooklogger.common.event.EventType;
import fi.fabianadrian.webhooklogger.common.listener.AbstractListener;
import fi.fabianadrian.webhooklogger.paper.platform.PaperPlayer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;

public final class DeathListener
extends AbstractListener
implements Listener {
    public DeathListener(WebhookLogger webhookLogger) {
        super(webhookLogger);
    }

    @Override
    public EventType type() {
        return EventType.DEATH;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onDeath(PlayerDeathEvent event) {
        if (this.webhooks.isEmpty()) {
            return;
        }
        DeathEventConfig config = this.webhookLogger.eventsConfig().death();
        if (!config.logCancelled() && event.isCancelled()) {
            return;
        }
        PaperPlayer player = new PaperPlayer(event.getEntity());
        TagResolver.Builder builder = TagResolver.builder().resolvers(new TagResolver[]{this.placeholderFactory.player(player), this.placeholderFactory.cancelled(event.isCancelled()), this.placeholderFactory.message(event.deathMessage())});
        this.queue(config.format(), (Audience)player, builder);
    }
}

