/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.piggyback.mixinClient;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.AvatarRenderer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.faewulf.piggyback.inter.ICustomPlayerRenderState;
import xyz.faewulf.piggyback.util.config.ModConfigs;

@Mixin(value={AvatarRenderer.class})
public abstract class PlayerRendererMixin<AvatarlikeEntity extends Avatar>
extends LivingEntityRenderer<AvatarlikeEntity, AvatarRenderState, PlayerModel> {
    public PlayerRendererMixin(EntityRendererProvider.Context context, PlayerModel model, float shadowRadius) {
        super(context, (EntityModel)model, shadowRadius);
    }

    @Unique
    private static boolean piggyback$containClientPlayer(AbstractClientPlayer localPlayer1, LocalPlayer localPlayer) {
        List entityList = localPlayer1.getPassengers();
        boolean hasLocalPlayer = false;
        for (Entity entity : entityList) {
            LocalPlayer localPlayer2;
            if (!(entity instanceof LocalPlayer) || (localPlayer2 = (LocalPlayer)entity) != localPlayer) continue;
            hasLocalPlayer = true;
            break;
        }
        return hasLocalPlayer;
    }

    @Inject(method={"extractRenderState(Lnet/minecraft/world/entity/Avatar;Lnet/minecraft/client/renderer/entity/state/AvatarRenderState;F)V"}, at={@At(value="TAIL")})
    private void setModelPoseInject(AvatarlikeEntity avatar, AvatarRenderState avatarRenderState, float f, CallbackInfo ci) {
        LocalPlayer localPlayer1;
        ((ICustomPlayerRenderState)avatarRenderState).piggyback$setIsInvisibleWhileRiding(false);
        ((ICustomPlayerRenderState)avatarRenderState).piggyback$setIsInvisibleWhileCarrying(false);
        if (ModConfigs.effect_translucent_carrier == 100 && ModConfigs.effect_translucent == 100) {
            return;
        }
        Entity vehicle = avatar.getVehicle();
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        if (vehicle instanceof LocalPlayer && localPlayer == (localPlayer1 = (LocalPlayer)vehicle) && Minecraft.getInstance().options.getCameraType().isFirstPerson()) {
            ((ICustomPlayerRenderState)avatarRenderState).piggyback$setIsInvisibleWhileRiding(true);
        }
        if (avatar instanceof AbstractClientPlayer && PlayerRendererMixin.piggyback$containClientPlayer((AbstractClientPlayer)(localPlayer1 = (AbstractClientPlayer)avatar), localPlayer) && Minecraft.getInstance().options.getCameraType().isFirstPerson()) {
            ((ICustomPlayerRenderState)avatarRenderState).piggyback$setIsInvisibleWhileCarrying(true);
        }
    }
}

