/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.piggyback.mixin;

import com.mojang.authlib.GameProfile;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.faewulf.piggyback.util.config.ModConfigs;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends Player {
    @Shadow
    public ServerGamePacketListenerImpl connection;

    public ServerPlayerMixin(Level level, GameProfile gameProfile) {
        super(level, gameProfile);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tickInjectApplySlow(CallbackInfo ci) {
        if (!this.getPassengers().isEmpty() && ModConfigs.slow_carry) {
            this.addEffect(new MobEffectInstance(MobEffects.SLOWNESS, 3, 0, false, false));
        }
        if (!this.getPassengers().isEmpty() && ModConfigs.hunger_carry) {
            this.causeFoodExhaustion(0.005f);
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tickInjectRemovePassengerOnInterruption(CallbackInfo callbackInfo) {
        if (!ModConfigs.falling_dismount) {
            return;
        }
        if (this.isVehicle() && !this.isCrouching() && !this.isFallFlying() && this.fallDistance > 2.0 && this.getFirstPassenger() != null) {
            this.getFirstPassenger().stopRiding();
        }
    }

    @ModifyVariable(method={"startRiding"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private Entity startRidingModifyParameter(Entity entity) {
        Player player;
        Entity entity2;
        Entity lastPassenger = entity;
        while (lastPassenger instanceof Player && (entity2 = (player = (Player)lastPassenger).getFirstPassenger()) instanceof Player) {
            Player playerEntity = (Player)entity2;
            lastPassenger = playerEntity;
        }
        if (lastPassenger != null) {
            return lastPassenger;
        }
        return entity;
    }

    @Inject(method={"startRiding"}, at={@At(value="RETURN")})
    private void startRidingInjectSyncPacket(Entity entity, boolean force, CallbackInfoReturnable<Boolean> cir) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer playerEntity = (ServerPlayer)entity;
            if (((Boolean)cir.getReturnValue()).booleanValue()) {
                playerEntity.connection.send((Packet)new ClientboundSetPassengersPacket((Entity)playerEntity));
            }
        }
    }

    @Inject(method={"disconnect"}, at={@At(value="HEAD")})
    private void disconnectInject(CallbackInfo ci) {
        if (this.isPassenger() && this.getVehicle() instanceof Player) {
            this.stopRiding();
        }
    }
}

