package com.boyonk.colorfulbooks.client;

import com.boyonk.colorfulbooks.ColoredBlockEntity;
import com.boyonk.colorfulbooks.ColorfulBooks;
import com.boyonk.colorfulbooks.client.compat.McbvCompat;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.rendering.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1059;
import net.minecraft.class_11515;
import net.minecraft.class_1920;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4730;
import org.jetbrains.annotations.Nullable;

public class ColorfulBooksClient implements ClientModInitializer {

	public static final class_4730 ENTITY_BOOK_SPRITE = new class_4730(class_1059.field_5275, class_2960.method_60655(ColorfulBooks.NAMESPACE, "entity/enchanting_table_book"));
	public static final class_2960 GUI_BOOK_TEXTURE = class_2960.method_60655(ColorfulBooks.NAMESPACE, "textures/gui/book.png");
	public static final class_2960 BOOK_OVERLAY_TEXTURE = class_2960.method_60655(ColorfulBooks.NAMESPACE, "textures/gui/book_overlay.png");
	public static final class_2960 ENTITY_BOOK_TEXTURE = class_2960.method_60655(ColorfulBooks.NAMESPACE, "textures/entity/enchanting_table_book.png");

	@Override
	public void onInitializeClient() {
		ColorProviderRegistry.BLOCK.register(ColorfulBooksClient::getChiseledBookshelfColor, class_2246.field_40276);
		BlockRenderLayerMap.putBlocks(class_11515.field_60925, class_2246.field_40276);

		if (FabricLoader.getInstance().isModLoaded("lolmcbv")) McbvCompat.init();
	}

	//Note that we remove one from tintIndex. Our models have a tintIndex offset of +1, because the block (break) particles always use a tintIndex of 0, and we don't want to change the color of those
	public static int getChiseledBookshelfColor(class_2680 state, @Nullable class_1920 world, @Nullable class_2338 pos, int tintIndex) {
		return world == null || pos == null ? -1 : world.method_35230(pos, class_2591.field_40329).map(blockEntity -> ((ColoredBlockEntity) blockEntity).colorfulBooks$getColor(tintIndex - 1)).orElse(-1);
	}

}
