package com.boyonk.colorfulbooks.client.mixin;

import com.boyonk.colorfulbooks.client.ColoredRenderState;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.class_11251;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_11251.class)
public abstract class BookModelGuiElementRenderStateMixin implements ColoredRenderState {

	@Shadow
	public abstract boolean equals(Object par1);

	@Unique
	private int colorfulBooks$color = -1;

	@Override
	public void color(int color) {
		this.colorfulBooks$color = color;
	}

	@Override
	public int color() {
		return this.colorfulBooks$color;
	}

	@ModifyReturnValue(method = "equals", at = @At("RETURN"))
	boolean colorfulBooks$equals(boolean original, @Local(argsOnly = true) Object object) {
		if (!original) return false;

		return ((BookModelGuiElementRenderStateMixin) object).colorfulBooks$color == this.colorfulBooks$color;
	}

}
