package com.boyonk.colorfulbooks.client.mixin;

import com.boyonk.colorfulbooks.client.ColoredRenderState;
import net.minecraft.class_11964;
import net.minecraft.class_11967;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value = {class_11964.class, class_11967.class})
public abstract class ColoredBlockEntityRenderStateMixin implements ColoredRenderState {

	@Unique
	private int colorfulBooks$color = -1;

	@Override
	public void color(int color) {
		this.colorfulBooks$color = color;
	}

	@Override
	public int color() {
		return this.colorfulBooks$color;
	}


}
