package com.boyonk.colorfulbooks.loot.function;

import com.boyonk.colorfulbooks.ColorfulBooks;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_120;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_47;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import net.minecraft.class_5819;
import net.minecraft.class_6017;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_9282;

public class DyeRandomlyLootFunction extends class_120 {

	private static final Codec<class_6017> AMOUNT_CODEC = class_6017.method_35004(0, 8);
	private static final Codec<class_6885<class_1792>> ENTRY_CODEC = class_7923.field_41178.method_40294()
			.listOf()
			.xmap(class_6885::method_40242, registryEntryList -> registryEntryList.method_40239().toList());

	public static final MapCodec<DyeRandomlyLootFunction> CODEC = RecordCodecBuilder.mapCodec(instance ->
			DyeRandomlyLootFunction.method_53344(instance)
					.and(instance.group(
									AMOUNT_CODEC
											.fieldOf("amount")
											.forGetter(function -> function.amount),
									ENTRY_CODEC
											.optionalFieldOf("dyes")
											.forGetter(function -> function.dyes)
							)
					).apply(instance, DyeRandomlyLootFunction::new)
	);


	private final class_6017 amount;
	private final Optional<class_6885<class_1792>> dyes;

	public DyeRandomlyLootFunction(List<class_5341> conditions, class_6017 amount, Optional<class_6885<class_1792>> dyes) {
		super(conditions);
		this.amount = amount;
		this.dyes = dyes;
	}

	@Override
	public class_5339<DyeRandomlyLootFunction> method_29321() {
		return ColorfulBooks.DYE_RANDOMLY_LOOT_FUNCTION;
	}

	@Override
	protected class_1799 method_522(class_1799 stack, class_47 context) {
		class_5819 random = context.method_294();

		List<class_1769> dyes = new ArrayList<>();
		int iteration = 0;
		int amount = this.amount.method_35008(random);
		while (iteration < amount) {
			class_1769 dye;
			if (this.dyes.isEmpty()) {
				dye = class_1769.method_7803(class_1767.method_7791(random.method_43048(16)));
			} else {
				class_6880<class_1792> entry = this.dyes.get().method_40239().skip(random.method_43048(this.dyes.get().method_40247())).findFirst().orElseThrow();
				if (!(entry.comp_349() instanceof class_1769 dyeItem)) {
					break;
				} else {
					dye = dyeItem;
				}
			}
			dyes.add(dye);
			iteration++;
		}
		if (dyes.isEmpty()) return stack;
		return class_9282.method_57471(stack, dyes);
	}

}
