package com.boyonk.colorfulbooks.mixin;

import com.boyonk.colorfulbooks.ColoredBlockEntity;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_7225;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_2586.class)
public class BlockEntityMixin {


	// We do this in BlockEntity.class rather than it's subclasses to not have to use @Override.
	// @Override causes incompatibilities with other mods trying to send block entity data to the client.
	// This is based on the assumption that any other mods will use BlockEntityUpdateS2CPacket.create
	@ModifyReturnValue(method = "toUpdatePacket", at = @At("RETURN"))
	class_2596<class_2602> colorfulBooks$toUpdatePacket(class_2596<class_2602> original) {
		if (original != null) return original;
		if (this instanceof ColoredBlockEntity) {
			return class_2622.method_38585((class_2586) (Object) this);
		} else return null;
	}

	// We do this in BlockEntity.class rather than it's subclasses to not have to use @Override.
	// @Override causes incompatibilities with other mods trying to send block entity data to the client.
	// This is based on the assumption that any other mods will still call super.toInitialChunkDataNbt
	@ModifyReturnValue(method = "toInitialChunkDataNbt", at = @At("RETURN"))
	class_2487 colorfulBooks$toInitialChunkDataNbt(class_2487 original, @Local(argsOnly = true) class_7225.class_7874 registryLookup) {
		if(this instanceof ColoredBlockEntity coloredBlockEntity) {
			coloredBlockEntity.colorfulBooks$writeInitialChunkDataNbt(registryLookup, original);
		}
		return original;
	}

}
