package com.boyonk.colorfulbooks.mixin;


import com.boyonk.colorfulbooks.ColoredBlockEntity;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1718;
import net.minecraft.class_1937;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_3917;
import net.minecraft.class_9848;
import net.minecraft.screen.*;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1718.class)
public abstract class EnchantmentScreenHandlerMixin extends class_1703 implements ColoredBlockEntity {

	@Unique
	private int[] colorfulBooks$colorProperty;

	protected EnchantmentScreenHandlerMixin(@Nullable class_3917<?> type, int syncId) {
		super(type, syncId);
	}

	@Inject(method = "<init>(ILnet/minecraft/entity/player/PlayerInventory;Lnet/minecraft/screen/ScreenHandlerContext;)V", at = @At("RETURN"))
	void colorfulBooks$init(int syncId, class_1661 playerInventory, class_3914 context, CallbackInfo ci) {
		this.colorfulBooks$colorProperty = new int[]{255, 255, 255};
		this.method_17362(class_3915.method_17406(this.colorfulBooks$colorProperty, 0));
		this.method_17362(class_3915.method_17406(this.colorfulBooks$colorProperty, 1));
		this.method_17362(class_3915.method_17406(this.colorfulBooks$colorProperty, 2));
		context.method_17395(class_1937::method_8321).ifPresent(blockEntity -> {
			if (blockEntity instanceof ColoredBlockEntity coloredBlockEntity) {
				int color = coloredBlockEntity.colorfulBooks$getColor(0);
				this.colorfulBooks$colorProperty[0] = class_9848.method_61327(color);
				this.colorfulBooks$colorProperty[1] = class_9848.method_61329(color);
				this.colorfulBooks$colorProperty[2] = class_9848.method_61331(color);
			}
		});
	}

	@Override
	public int colorfulBooks$getColor(int index) {
		return class_9848.method_61324(255, this.colorfulBooks$colorProperty[0], this.colorfulBooks$colorProperty[1], this.colorfulBooks$colorProperty[2]);
	}

	@Override
	public void colorfulBooks$setColor(int index, int color) {
	}
}
