package com.boyonk.colorfulbooks.recipe;

import com.boyonk.colorfulbooks.ColorfulBooks;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_10295;
import net.minecraft.class_10355;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9334;
import net.minecraft.class_9694;
import net.minecraft.class_9887;

public class DyedRecipe<T extends class_3955> implements class_3955 {

	private final T delegate;
	private final class_1865<DyedRecipe<T>> serializer;

	public DyedRecipe(T delegate, class_1865<DyedRecipe<T>> serializer) {
		this.delegate = delegate;
		this.serializer = serializer;
	}

	@Override
	public class_3956<class_3955> method_17716() {
		return this.delegate.method_17716();
	}

	@Override
	public class_1865<DyedRecipe<T>> method_8119() {
		return this.serializer;
	}

	@Override
	public class_7710 method_45441() {
		return this.delegate.method_45441();
	}

	@Override
	public class_2371<class_1799> method_17704(class_9694 input) {
		return this.delegate.method_17704(input);
	}

	@Override
	public class_10355 method_64668() {
		return this.delegate.method_64668();
	}

	@Override
	public boolean matches(class_9694 input, class_1937 world) {
		return this.delegate.method_8115(input, world);
	}

	@Override
	public class_1799 craft(class_9694 input, class_7225.class_7874 lookup) {
		class_1799 result = this.delegate.method_8116(input, lookup);
		Optional<class_1799> optional = input.method_59989()
				.stream()
				.filter(stack -> stack.method_57826(class_9334.field_49644))
				.findFirst();
		if (optional.isEmpty()) return result;

		class_1799 base = optional.get();
		return ColorfulBooks.config().craftingStrategy(result.method_7909()).apply(result, base);
	}

	@Override
	public boolean method_8118() {
		return this.delegate.method_8118();
	}

	@Override
	public boolean method_49188() {
		return this.delegate.method_49188();
	}

	@Override
	public String method_8112() {
		return this.delegate.method_8112();
	}

	@Override
	public class_9887 method_61671() {
		return this.delegate.method_61671();
	}

	@Override
	public List<class_10295> method_64664() {
		return this.delegate.method_64664();
	}

	public static class Serializer<T extends class_3955> implements class_1865<DyedRecipe<T>> {

		private final MapCodec<DyedRecipe<T>> codec;
		private final class_9139<class_9129, DyedRecipe<T>> packetCodec;

		public Serializer(class_1865<T> delegate) {
			this.codec = delegate.method_53736().xmap(recipe -> new DyedRecipe<>(recipe, this), recipe -> recipe.delegate);
			this.packetCodec = delegate.method_56104().method_56432(recipe -> new DyedRecipe<>(recipe, this), recipe -> recipe.delegate);
		}

		@Override
		public MapCodec<DyedRecipe<T>> method_53736() {
			return this.codec;
		}

		@Override
		public class_9139<class_9129, DyedRecipe<T>> method_56104() {
			return this.packetCodec;
		}
	}

}
