/*
 * Decompiled with CFR 0.152.
 */
package com.boyonk.colorfulbooks;

import com.boyonk.colorfulbooks.ColorfulBooks;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9282;
import net.minecraft.class_9334;

public class ColorfulBooksConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Codec<class_1769> DYE_CODEC = class_7923.field_41178.method_39673().comapFlatMap(item -> item instanceof class_1769 ? DataResult.success((Object)((class_1769)item)) : DataResult.error(() -> "Item must be a dye"), Function.identity());
    private static final Codec<List<class_1769>> DYE_LIST_CODEC = Codec.either((Codec)DYE_CODEC.listOf(), DYE_CODEC).xmap(either -> (List)either.map(entries -> entries, List::of), list -> list.size() == 1 ? Either.right((Object)((class_1769)list.get(0))) : Either.left((Object)list));
    public static final Codec<ColorfulBooksConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Glints.CODEC.fieldOf("glints").forGetter(config -> config.glints), (App)CopyStrategies.CODEC.fieldOf("copy_strategies").forGetter(config -> config.copyStrategies), (App)Codec.unboundedMap((Codec)class_5321.method_39154((class_5321)class_7924.field_41265), DYE_LIST_CODEC).fieldOf("enchantment_dyes").forGetter(config -> config.enchantmentDyes)).apply((Applicative)instance, ColorfulBooksConfig::new));
    private final Glints glints;
    private final CopyStrategies copyStrategies;
    private final Map<class_5321<class_1887>, List<class_1769>> enchantmentDyes;

    private ColorfulBooksConfig(Glints glints, CopyStrategies copyStrategies, Map<class_5321<class_1887>, List<class_1769>> enchantmentDyes) {
        this.glints = glints;
        this.copyStrategies = copyStrategies;
        this.enchantmentDyes = enchantmentDyes;
    }

    private static ColorfulBooksConfig createDefault() {
        return new ColorfulBooksConfig(new Glints(true, true), new CopyStrategies(Map.of("writable_book", CopyStrategies.Type.DYE, "enchanting_table", CopyStrategies.Type.DYE), CopyStrategies.Type.NONE, CopyStrategies.Type.DYE), (Map<class_5321<class_1887>, List<class_1769>>)ImmutableMap.builder().put((Object)class_1893.field_9111, List.of((class_1769)class_1802.field_8492)).put((Object)class_1893.field_9095, List.of((class_1769)class_1802.field_8492)).put((Object)class_1893.field_9129, List.of((class_1769)class_1802.field_8446)).put((Object)class_1893.field_9107, List.of((class_1769)class_1802.field_8492)).put((Object)class_1893.field_9096, List.of((class_1769)class_1802.field_8492)).put((Object)class_1893.field_9127, List.of((class_1769)class_1802.field_8273)).put((Object)class_1893.field_9105, List.of((class_1769)class_1802.field_8345)).put((Object)class_1893.field_9097, List.of((class_1769)class_1802.field_8408)).put((Object)class_1893.field_9128, List.of((class_1769)class_1802.field_8851)).put((Object)class_1893.field_9122, List.of((class_1769)class_1802.field_8851)).put((Object)class_1893.field_9113, List.of((class_1769)class_1802.field_8226)).put((Object)class_1893.field_23071, List.of((class_1769)class_1802.field_8632)).put((Object)class_1893.field_38223, List.of((class_1769)class_1802.field_8632)).put((Object)class_1893.field_9118, List.of((class_1769)class_1802.field_8298)).put((Object)class_1893.field_9123, List.of((class_1769)class_1802.field_8298)).put((Object)class_1893.field_9112, List.of((class_1769)class_1802.field_8298)).put((Object)class_1893.field_9121, List.of((class_1769)class_1802.field_8330)).put((Object)class_1893.field_9124, List.of((class_1769)class_1802.field_8264)).put((Object)class_1893.field_9110, List.of((class_1769)class_1802.field_8192)).put((Object)class_1893.field_9115, List.of((class_1769)class_1802.field_8446)).put((Object)class_1893.field_9131, List.of((class_1769)class_1802.field_8632)).put((Object)class_1893.field_9099, List.of((class_1769)class_1802.field_8192)).put((Object)class_1893.field_9119, List.of((class_1769)class_1802.field_8345)).put((Object)class_1893.field_9130, List.of((class_1769)class_1802.field_8192)).put((Object)class_1893.field_9103, List.of((class_1769)class_1802.field_8296)).put((Object)class_1893.field_9116, List.of((class_1769)class_1802.field_8330)).put((Object)class_1893.field_9126, List.of((class_1769)class_1802.field_8264)).put((Object)class_1893.field_9125, List.of((class_1769)class_1802.field_8131)).put((Object)class_1893.field_9114, List.of((class_1769)class_1802.field_8408)).put((Object)class_1893.field_9100, List.of((class_1769)class_1802.field_8330)).put((Object)class_1893.field_9120, List.of((class_1769)class_1802.field_8669)).put((Object)class_1893.field_9106, List.of((class_1769)class_1802.field_8296)).put((Object)class_1893.field_9104, List.of((class_1769)class_1802.field_8669)).put((Object)class_1893.field_9117, List.of((class_1769)class_1802.field_8273)).put((Object)class_1893.field_9108, List.of((class_1769)class_1802.field_8099)).put((Object)class_1893.field_9098, List.of((class_1769)class_1802.field_8632)).put((Object)class_1893.field_9132, List.of((class_1769)class_1802.field_8099)).put((Object)class_1893.field_50157, List.of((class_1769)class_1802.field_8298)).put((Object)class_1893.field_50158, List.of((class_1769)class_1802.field_8298)).put((Object)class_1893.field_50159, List.of((class_1769)class_1802.field_8446)).put((Object)class_1893.field_9101, List.of((class_1769)class_1802.field_8131)).put((Object)class_1893.field_9109, List.of((class_1769)class_1802.field_8226)).build());
    }

    public static ColorfulBooksConfig load() {
        Path path = FabricLoader.getInstance().getConfigDir().resolve("colorful_books.json");
        if (Files.isRegularFile(path, new LinkOption[0])) {
            block17: {
                ColorfulBooksConfig colorfulBooksConfig;
                JsonReader reader = new JsonReader((Reader)Files.newBufferedReader(path, StandardCharsets.UTF_8));
                try {
                    reader.setLenient(false);
                    JsonElement json = Streams.parse((JsonReader)reader);
                    colorfulBooksConfig = (ColorfulBooksConfig)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(JsonParseException::new);
                }
                catch (Throwable json) {
                    try {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            json.addSuppressed(throwable);
                        }
                        throw json;
                    }
                    catch (JsonParseException exception) {
                        ColorfulBooks.LOGGER.error("Couldn't parse config {}", (Object)path.getFileName(), (Object)exception);
                        break block17;
                    }
                    catch (IOException exception) {
                        ColorfulBooks.LOGGER.error("Couldn't access config {}", (Object)path.getFileName(), (Object)exception);
                    }
                }
                reader.close();
                return colorfulBooksConfig;
            }
            return ColorfulBooksConfig.createDefault();
        }
        ColorfulBooksConfig config = ColorfulBooksConfig.createDefault();
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
                GSON.toJson((JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)config).getOrThrow(IOException::new), (Appendable)writer);
            }
        }
        catch (IOException exception) {
            ColorfulBooks.LOGGER.error("Failed to save config {}", (Object)path, (Object)exception);
        }
        return config;
    }

    public boolean writtenBookGlint() {
        return this.glints.writtenBook();
    }

    public boolean enchantedBookGlint() {
        return this.glints.enchantedBook();
    }

    public CopyStrategies.Type craftingStrategy(class_1792 item) {
        CopyStrategies.Type type = this.copyStrategies.crafting().get(class_7923.field_41178.method_10221((Object)item).method_12832());
        return type == null ? CopyStrategies.Type.DYE : type;
    }

    public CopyStrategies.Type bookCloningStrategy() {
        return this.copyStrategies.bookCloning();
    }

    public CopyStrategies.Type villagerTradeStrategy() {
        return this.copyStrategies.villagerTrade();
    }

    public Optional<List<class_1769>> enchantmentDyes(class_5321<class_1887> enchantment) {
        return Optional.ofNullable(this.enchantmentDyes.get(enchantment));
    }

    record Glints(boolean writtenBook, boolean enchantedBook) {
        private static final Codec<Glints> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("written_book").forGetter(Glints::writtenBook), (App)Codec.BOOL.fieldOf("enchanted_book").forGetter(Glints::enchantedBook)).apply((Applicative)instance, Glints::new));
    }

    private record CopyStrategies(Map<String, Type> crafting, Type bookCloning, Type villagerTrade) {
        private static final String CRAFTING_PREFIX = "crafting_";
        private static final Codec<String> KEY_CODEC = Codec.STRING.validate(raw -> class_2960.method_20208((String)raw) ? DataResult.success((Object)raw) : DataResult.error(() -> "Non [a-z0-9/._-] character in path: " + raw));
        private static final Codec<Map<String, Type>> CRAFTING_CODEC = Codec.unboundedMap((Codec)KEY_CODEC.xmap(raw -> raw.substring(CRAFTING_PREFIX.length()), str -> CRAFTING_PREFIX + str), Type.CODEC);
        private static final Codec<Pair<Type, Type>> OTHER_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Type.CODEC.fieldOf("book_cloning").forGetter(Pair::getFirst), (App)Type.CODEC.fieldOf("villager_trade").forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of));
        private static final Codec<CopyStrategies> CODEC = Codec.pair(CRAFTING_CODEC, OTHER_CODEC).xmap(pair -> new CopyStrategies((Map)pair.getFirst(), (Type)((Object)((Object)((Pair)pair.getSecond()).getFirst())), (Type)((Object)((Object)((Pair)pair.getSecond()).getSecond()))), strategies -> Pair.of(strategies.crafting(), (Object)Pair.of((Object)((Object)strategies.bookCloning()), (Object)((Object)strategies.villagerTrade()))));

        public static enum Type implements class_3542
        {
            ALL,
            DYE,
            NONE;

            public static final Codec<Type> CODEC;

            public String method_15434() {
                return switch (this.ordinal()) {
                    default -> throw new IncompatibleClassChangeError();
                    case 0 -> "all";
                    case 1 -> "dye";
                    case 2 -> "none";
                };
            }

            public class_1799 apply(class_1799 output, class_1799 input) {
                return switch (this.ordinal()) {
                    default -> throw new IncompatibleClassChangeError();
                    case 0 -> (class_1799)class_156.method_654((Object)input.method_56701((class_1935)output.method_7909(), output.method_7947()), s -> s.method_59692(((class_1799)class_156.method_654((Object)output, sx -> sx.method_57381(class_9334.field_49644))).method_57380()));
                    case 1 -> (class_1799)class_156.method_654((Object)output, s -> s.method_57379(class_9334.field_49644, (Object)((class_9282)input.method_58694(class_9334.field_49644))));
                    case 2 -> output;
                };
            }

            static {
                CODEC = class_3542.method_28140(Type::values);
            }
        }
    }
}

