package com.boyonk.colorfulbooks.client;

import com.boyonk.colorfulbooks.ColoredBlockEntity;
import com.boyonk.colorfulbooks.ColorfulBooks;
import com.boyonk.colorfulbooks.client.compat.McbvCompat;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1059;
import net.minecraft.class_1802;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4730;
import net.minecraft.class_9282;
import org.jetbrains.annotations.Nullable;

public class ColorfulBooksClient implements ClientModInitializer {

	public static final class_4730 ENTITY_BOOK_TEXTURE = new class_4730(class_1059.field_5275, new class_2960(ColorfulBooks.NAMESPACE, "entity/enchanting_table_book"));
	public static final class_2960 GUI_BOOK_TEXTURE = new class_2960(ColorfulBooks.NAMESPACE, "textures/gui/book.png");
	public static final class_2960 BOOK_OVERLAY_TEXTURE = new class_2960(ColorfulBooks.NAMESPACE, "textures/gui/book_overlay.png");

	@Override
	public void onInitializeClient() {
		ColorProviderRegistry.ITEM.register((stack, tintIndex) -> tintIndex == 0 ? class_9282.method_57470(stack, class_9282.field_49314) : -1, class_1802.field_8529, class_1802.field_8360, class_1802.field_8674, class_1802.field_8598);

		ColorProviderRegistry.BLOCK.register(ColorfulBooksClient::getChiseledBookshelfColor, class_2246.field_40276);
		BlockRenderLayerMap.INSTANCE.putBlocks(class_1921.method_23581(), class_2246.field_40276);

		if (FabricLoader.getInstance().isModLoaded("lolmcbv")) McbvCompat.init();
	}

	//Note that we remove one from tintIndex. Our models have a tintIndex offset of +1, because the block (break) particles always use a tintIndex of 0, and we don't want to change the color of those
	public static int getChiseledBookshelfColor(class_2680 state, @Nullable class_1920 world, @Nullable class_2338 pos, int tintIndex) {
		return world == null || pos == null ? -1 : world.method_35230(pos, class_2591.field_40329).map(blockEntity -> ((ColoredBlockEntity) blockEntity).colorfulBooks$getColor(tintIndex - 1)).orElse(-1);
	}

}
