package com.boyonk.colorfulbooks.client.mixin;

import com.boyonk.colorfulbooks.client.ColoredBookScreen;
import com.boyonk.colorfulbooks.client.ColorfulBooksClient;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3872;
import net.minecraft.class_437;
import net.minecraft.class_5253;
import net.minecraft.class_9282;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_3872.class)
public abstract class BookScreenMixin extends class_437 implements ColoredBookScreen {

	@Unique
	int colorfulBooks$color = class_9282.field_49314;

	protected BookScreenMixin(class_2561 title) {
		super(title);
	}

	@WrapWithCondition(method = "renderBackground", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawTexture(Lnet/minecraft/util/Identifier;IIIIII)V"))
	boolean colorfulBooks$renderBackground(class_332 context, class_2960 texture, int x, int y, int u, int v, int width, int height) {
		float red = class_5253.class_5254.method_27765(this.colorfulBooks$color) / 255f;
		float blue = class_5253.class_5254.method_27767(this.colorfulBooks$color) / 255f;
		float green = class_5253.class_5254.method_27766(this.colorfulBooks$color) / 255f;

		context.method_48466(ColorfulBooksClient.GUI_BOOK_TEXTURE, x, x + width, y, y + width, 0, (u + 0.0F) / (float) 256, (u + (float) width) / (float) 256, (v + 0.0F) / (float) 256, (v + (float) height) / (float) 256, red, green, blue, 1f);
		context.method_25302(ColorfulBooksClient.BOOK_OVERLAY_TEXTURE, x, y, u, v, width, height);
		return false;
	}

	@Override
	public void colorfulBooks$setColor(int color) {
		this.colorfulBooks$color = color;
	}
}
