package com.boyonk.colorfulbooks.mixin;

import com.boyonk.colorfulbooks.ColoredBlockEntity;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3722;
import net.minecraft.class_7225;
import net.minecraft.class_9282;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3722.class)
public abstract class LecternBlockEntityMixin extends class_2586 implements ColoredBlockEntity {

	@Shadow
	public abstract class_1799 getBook();

	@Unique
	private int colorfulBooks$color = class_9282.field_49314;

	public LecternBlockEntityMixin(class_2591<?> type, class_2338 pos, class_2680 state) {
		super(type, pos, state);
	}

	@Override
	public int colorfulBooks$getColor(int index) {
		return this.colorfulBooks$color;
	}

	@Override
	public void colorfulBooks$setColor(int index, int color) {
		this.colorfulBooks$color = color;
	}

	@Override
	public void colorfulBooks$writeInitialChunkDataNbt(class_7225.class_7874 registryLookup, class_2487 nbt) {
		nbt.method_10569("colorful_books:color", this.colorfulBooks$color);

	}

	@Inject(method = "readNbt", at = @At("RETURN"))
	void colorfulBooks$readNbt(class_2487 nbt, class_7225.class_7874 registryLookup, CallbackInfo ci) {
		if (this.field_11863 != null && this.field_11863.field_9236 && nbt.method_10573("colorful_books:color", class_2520.field_33253)) {
			this.colorfulBooks$color = nbt.method_10550("colorful_books:color");
		} else {
			this.colorfulBooks$setColor(0, class_9282.method_57470(this.getBook(), class_9282.field_49314));
		}
	}

	@Inject(method = "setBook(Lnet/minecraft/item/ItemStack;Lnet/minecraft/entity/player/PlayerEntity;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/block/entity/LecternBlockEntity;markDirty()V"))
	void colorfulBooks$setBook(class_1799 book, class_1657 player, CallbackInfo ci) {
		this.colorfulBooks$setColor(0, class_9282.method_57470(book, class_9282.field_49314));
	}

	@Inject(method = "onBookRemoved", at = @At("HEAD"))
	void colorfulBooks$onBookRemoved(CallbackInfo ci) {
		this.colorfulBooks$setColor(0, class_9282.field_49314);
	}


}
