/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.block.custom;

import java.util.List;
import net.migueel26.faunaandorchestra.block.ModBlocks;
import net.migueel26.faunaandorchestra.block.custom.AltarBlock;
import net.migueel26.faunaandorchestra.entity.ModEntities;
import net.migueel26.faunaandorchestra.entity.custom.ButterflyEntity;
import net.migueel26.faunaandorchestra.entity.custom.MadameButterflyEntity;
import net.migueel26.faunaandorchestra.item.ModItems;
import net.migueel26.faunaandorchestra.particles.ModParticleTypes;
import net.migueel26.faunaandorchestra.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class AltarOfTheButterfliesBlock
extends AltarBlock {
    public static final BooleanProperty OFFERING = BooleanProperty.create((String)"offering");

    public AltarOfTheButterfliesBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)OFFERING, (Comparable)Boolean.valueOf(false)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(ModItems.OFFERING) && !((Boolean)state.getValue((Property)OFFERING)).booleanValue() && level.getBlockState(pos.above()).isAir()) {
            stack.consume(1, (LivingEntity)player);
            level.setBlock(pos, (BlockState)state.setValue((Property)OFFERING, (Comparable)Boolean.valueOf(true)), 3);
            if (!level.isClientSide()) {
                ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.WAX_OFF, pos.getCenter().x, (double)pos.above().getY(), pos.getCenter().z, 20, 0.2, 0.2, 0.2, 0.05);
            }
            level.playSound(player, pos.above(), (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.NEUTRAL, 2.0f, 1.5f);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        List butterflies;
        float size;
        if (((Boolean)state.getValue((Property)OFFERING)).booleanValue() && (size = (float)(butterflies = level.getEntitiesOfClass(ButterflyEntity.class, AABB.ofSize((Vec3)pos.getCenter(), (double)10.0, (double)10.0, (double)10.0))).size()) >= 5.0f && level.random.nextFloat() <= size / 80.0f) {
            MadameButterflyEntity madameButterfly = new MadameButterflyEntity(ModEntities.MADAME_BUTTERFLY.get(), (Level)level);
            madameButterfly.setMusical();
            madameButterfly.setOrderedToSit(true);
            madameButterfly.moveTo(pos.above().getCenter());
            madameButterfly.setYHeadRot(this.getYRot((Direction)state.getValue((Property)FACING)));
            madameButterfly.setYBodyRot(madameButterfly.getYRot());
            level.playSound(null, pos, ModSounds.SPROUTLING_TWINKLE.get(), SoundSource.NEUTRAL);
            level.sendParticles((ParticleOptions)ModParticleTypes.STAR.get(), pos.getCenter().x, (double)((float)pos.above().getY() + 0.25f), pos.getCenter().z, 10, (double)0.1f, (double)0.1f, (double)0.1f, (double)0.025f);
            level.setBlock(pos, (BlockState)state.setValue((Property)OFFERING, (Comparable)Boolean.valueOf(false)), 3);
            level.addFreshEntity((Entity)madameButterfly);
        }
        super.randomTick(state, level, pos, random);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (((Boolean)state.getValue((Property)OFFERING)).booleanValue() && !newState.is(ModBlocks.ALTAR_OF_THE_BUTTERFLIES)) {
            AltarOfTheButterfliesBlock.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)Direction.UP, (ItemStack)new ItemStack((ItemLike)ModItems.OFFERING.get()));
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, OFFERING});
    }
}

