/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.client.entity;

import net.migueel26.faunaandorchestra.entity.custom.AbstractCanonEntity;
import net.migueel26.faunaandorchestra.entity.custom.PlayerCanonEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class CanonEntityModel
extends GeoModel<AbstractCanonEntity> {
    private static final ResourceLocation DEFAULT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"textures/entity/anya_ghost.png");
    private static final ResourceLocation ANIMATIONS = ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"animations/entity/player_canon.animation.json");
    private static final ResourceLocation ANYA_MODEL = ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"geo/entity/anya_ghost.geo.json");
    private static final ResourceLocation PLAYER_CANON_MODEL = ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)"geo/entity/player_canon.geo.json");

    public ResourceLocation getModelResource(AbstractCanonEntity animatable) {
        return animatable instanceof PlayerCanonEntity ? PLAYER_CANON_MODEL : ANYA_MODEL;
    }

    public ResourceLocation getTextureResource(AbstractCanonEntity animatable) {
        return animatable.getSkin() == null ? DEFAULT_TEXTURE : animatable.getSkin();
    }

    public ResourceLocation getAnimationResource(AbstractCanonEntity animatable) {
        return ANIMATIONS;
    }

    public void setCustomAnimations(AbstractCanonEntity anya, long instanceId, AnimationState<AbstractCanonEntity> animationState) {
        GeoBone head = this.getAnimationProcessor().getBone("Head");
        if (head != null) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(entityData.headPitch() * ((float)Math.PI / 180));
            head.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
        }
    }
}

