/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.client.entity.projectile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.migueel26.faunaandorchestra.entity.custom.WanderingNoteEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class WanderingNoteRenderer
extends EntityRenderer<WanderingNoteEntity> {
    public WanderingNoteRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(WanderingNoteEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        poseStack.scale(2.0f, 2.0f, 2.0f);
        poseStack.translate(-0.2, -0.2, 0.0);
        poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        int alpha = Math.round(Math.clamp(WanderingNoteRenderer.getValue(entity), 0.0f, 255.0f));
        PoseStack.Pose posestack$pose = poseStack.last();
        VertexConsumer vertexconsumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(entity)));
        WanderingNoteRenderer.vertex(vertexconsumer, posestack$pose, packedLight, 0.0f, 0, 0, 1, alpha);
        WanderingNoteRenderer.vertex(vertexconsumer, posestack$pose, packedLight, 1.0f, 0, 1, 1, alpha);
        WanderingNoteRenderer.vertex(vertexconsumer, posestack$pose, packedLight, 1.0f, 1, 1, 0, alpha);
        WanderingNoteRenderer.vertex(vertexconsumer, posestack$pose, packedLight, 0.0f, 1, 0, 0, alpha);
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    private static float getValue(WanderingNoteEntity entity) {
        return (float)(255.0 * Math.pow(1.0f - (float)entity.getLifetime() / 255.0f, 0.3333333432674408));
    }

    private static void vertex(VertexConsumer consumer, PoseStack.Pose pose, int packedLight, float x, int y, int u, int v, int alpha) {
        consumer.addVertex(pose, x - 0.5f, (float)y - 0.25f, 0.0f).setColor(255, 255, 255, alpha).setUv((float)u, (float)v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }

    public ResourceLocation getTextureLocation(WanderingNoteEntity entity) {
        int index = entity.getTextureIndex();
        return ResourceLocation.fromNamespaceAndPath((String)"faunaandorchestra", (String)("textures/particle/fauna_note_" + index + ".png"));
    }
}

