/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.effect;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;

public class BoogieEffect
extends MobEffect {
    private int tick;

    protected BoogieEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        if (livingEntity instanceof Player) {
            float i = (float)(8.0 * BoogieEffect.asymmetricSine((double)this.tick * 0.1, 0.5, 6.0, 4.0));
            livingEntity.setXRot(livingEntity.getXRot() + i);
        } else if (livingEntity instanceof PathfinderMob) {
            PathfinderMob mob = (PathfinderMob)livingEntity;
            float i = (float)(100.0 * BoogieEffect.asymmetricSine((double)this.tick * 0.2, 0.5, 6.0));
            mob.setXRot(i - 40.0f);
            mob.setNoAi(true);
        }
        ++this.tick;
        return super.applyEffectTick(livingEntity, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public static double asymmetricSine(double tick, double up, double down) {
        double y;
        double t = tick % Math.PI;
        if (t < 0.0) {
            t += Math.PI;
        }
        if (t < 1.5707963267948966) {
            double u = t / 1.5707963267948966;
            double angleUp = 1.5707963267948966 * Math.pow(u, up);
            y = Math.sin(angleUp);
        } else {
            double s = (t - 1.5707963267948966) / 1.5707963267948966;
            double angleDown = 1.5707963267948966 + 1.5707963267948966 * (1.0 - Math.pow(1.0 - s, down));
            y = Math.sin(angleDown);
        }
        return y;
    }

    public static double asymmetricSine(double x, double p, double r, double frequency) {
        double y;
        double t = x * frequency % (Math.PI * 2);
        if (t < 0.0) {
            t += Math.PI * 2;
        }
        if (t < Math.PI) {
            if (t < 1.5707963267948966) {
                double u = t / 1.5707963267948966;
                double angleUp = 1.5707963267948966 * Math.pow(u, p);
                y = Math.sin(angleUp);
            } else {
                double s = (t - 1.5707963267948966) / 1.5707963267948966;
                double angleDown = 1.5707963267948966 + 1.5707963267948966 * (1.0 - Math.pow(1.0 - s, r));
                y = Math.sin(angleDown);
            }
        } else {
            double t2 = t - Math.PI;
            if (t2 < 1.5707963267948966) {
                double u = t2 / 1.5707963267948966;
                double angleUp = 1.5707963267948966 * Math.pow(u, p);
                y = -Math.sin(angleUp);
            } else {
                double s = (t2 - 1.5707963267948966) / 1.5707963267948966;
                double angleDown = 1.5707963267948966 + 1.5707963267948966 * (1.0 - Math.pow(1.0 - s, r));
                y = -Math.sin(angleDown);
            }
        }
        return y;
    }
}

