/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.entity.custom;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import net.migueel26.faunaandorchestra.entity.goals.FaunaRandomLookAroundGoal;
import net.migueel26.faunaandorchestra.entity.goals.KoalaRandomChangeStanceGoal;
import net.migueel26.faunaandorchestra.entity.goals.LookAtTradingPlayerGoal;
import net.migueel26.faunaandorchestra.entity.goals.TradeWithPlayerGoal;
import net.migueel26.faunaandorchestra.entity.trades.KoalaTrades;
import net.migueel26.faunaandorchestra.item.ModItems;
import net.migueel26.faunaandorchestra.particles.ModParticleTypes;
import net.minecraft.Util;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class KoalaEntity
extends AgeableMob
implements Merchant,
Npc,
GeoEntity {
    private static final RawAnimation SLEEP = RawAnimation.begin().thenPlay("sleep");
    private static final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private static final RawAnimation SIT = RawAnimation.begin().thenPlay("sit");
    private static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private static final RawAnimation WAKE_UP = RawAnimation.begin().thenPlay("wake_up");
    private static final RawAnimation STAND_UP = RawAnimation.begin().thenPlay("stand_up");
    private static final RawAnimation SIT_DOWN = RawAnimation.begin().thenPlay("sit_down");
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.defineId(KoalaEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SLEEPING = SynchedEntityData.defineId(KoalaEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    @Nullable
    private Player tradingPlayer;
    @Nullable
    protected MerchantOffers offers;
    private static final Logger LOGGER = LogUtils.getLogger();
    protected boolean isSleeping = false;
    protected boolean isSitting = false;
    private int wakeUpTick = -1;
    protected int tick = 0;
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public KoalaEntity(EntityType<? extends AgeableMob> entityType, Level level) {
        super(entityType, level);
        this.addOverridenGoals();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(SITTING, (Object)false);
        builder.define(SLEEPING, (Object)false);
        super.defineSynchedData(builder);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new TradeWithPlayerGoal(this));
        this.goalSelector.addGoal(1, (Goal)new LookAtTradingPlayerGoal(this));
        this.goalSelector.addGoal(4, (Goal)new KoalaRandomChangeStanceGoal(this, 0.05f));
        this.goalSelector.addGoal(5, (Goal)new FaunaRandomLookAroundGoal((Mob)this));
    }

    private void addOverridenGoals() {
        this.goalSelector.addGoal(2, (Goal)new LookAtPlayerGoal(this, (Mob)this, Player.class, 8.0f){

            public boolean canUse() {
                return super.canUse() && !((KoalaEntity)this.mob).isKoalaSleeping();
            }

            public boolean canContinueToUse() {
                return super.canContinueToUse() && !((KoalaEntity)this.mob).isKoalaSleeping();
            }
        });
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal(this, (PathfinderMob)this, 0.75){

            public boolean canUse() {
                return super.canUse() && !((KoalaEntity)this.mob).isSitting();
            }

            public boolean canContinueToUse() {
                return super.canContinueToUse() && !((KoalaEntity)this.mob).isSitting();
            }
        });
        this.goalSelector.addGoal(1, (Goal)new PanicGoal(this, (PathfinderMob)this, 1.5){

            public boolean canUse() {
                return super.canUse() && !((KoalaEntity)this.mob).isKoalaSleeping();
            }

            public void start() {
                KoalaEntity koala;
                PathfinderMob pathfinderMob = this.mob;
                if (pathfinderMob instanceof KoalaEntity && !(koala = (KoalaEntity)pathfinderMob).isKoalaSleeping()) {
                    koala.setSitting(false);
                }
                super.start();
            }
        });
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        float prob = level.getRandom().nextFloat();
        if ((double)prob > 0.5) {
            this.setSleeping(true);
        }
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    private <E extends GeoAnimatable> PlayState koalaState(AnimationState<E> state) {
        if (this.isKoalaSleeping()) {
            state.getController().setAnimation(SLEEP);
        } else if (this.isSitting()) {
            state.getController().setAnimation(SIT);
        } else if (state.isMoving()) {
            state.getController().setAnimation(WALK);
        } else {
            state.getController().setAnimation(IDLE);
        }
        return PlayState.CONTINUE;
    }

    public void tick() {
        if (this.wakeUpTick > 0) {
            --this.wakeUpTick;
        } else if (this.wakeUpTick == 0) {
            this.setSleeping(false);
            this.wakeUpTick = -1;
        }
        if (!this.level().isClientSide() && this.isSitting() && !this.isKoalaSleeping() && this.getRandom().nextInt(5000) == 1) {
            this.setSleeping(true);
        }
        if (this.isKoalaSleeping() && !this.level().isClientSide() && this.tick % 35 == 0) {
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)ModParticleTypes.SLEEP.get(), this.position().x, this.getY() + 1.2, this.position().z, 1, 0.2, 0.05, 0.2, 0.025);
        }
        ++this.tick;
        super.tick();
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (key.equals(SITTING)) {
            this.isSitting = (Boolean)this.entityData.get(SITTING);
        } else if (key.equals(SLEEPING)) {
            this.isSleeping = (Boolean)this.entityData.get(SLEEPING);
        }
        super.onSyncedDataUpdated(key);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 15.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.FOLLOW_RANGE, 24.0);
    }

    public MerchantOffers getOffers() {
        if (this.level().isClientSide) {
            throw new IllegalStateException("Cannot load Villager offers on the client");
        }
        if (this.offers == null) {
            this.offers = new MerchantOffers();
            this.updateTrades();
        }
        return this.offers;
    }

    private void updateTrades() {
        VillagerTrades.ItemListing[] sheets = (VillagerTrades.ItemListing[])KoalaTrades.WANDERING_KOALA_TRADES.get(1);
        VillagerTrades.ItemListing[] instruments = (VillagerTrades.ItemListing[])KoalaTrades.WANDERING_KOALA_TRADES.get(2);
        VillagerTrades.ItemListing[] panFlutes = (VillagerTrades.ItemListing[])KoalaTrades.WANDERING_KOALA_TRADES.get(3);
        VillagerTrades.ItemListing[] gingkoBilobas = (VillagerTrades.ItemListing[])KoalaTrades.WANDERING_KOALA_TRADES.get(4);
        if (sheets != null && instruments != null) {
            MerchantOffers merchantOffers = this.getOffers();
            this.addOffersFromItemListings(merchantOffers, sheets, instruments, panFlutes, gingkoBilobas, 6);
        }
    }

    private void addOffersFromItemListings(MerchantOffers givenMerchantOffers, VillagerTrades.ItemListing[] sheets, VillagerTrades.ItemListing[] instruments, VillagerTrades.ItemListing[] panFlutes, VillagerTrades.ItemListing[] gingkoBilobas, int maxNumbers) {
        ArrayList sheetsList = Lists.newArrayList((Object[])sheets);
        ArrayList instrumentsList = Lists.newArrayList((Object[])instruments);
        ArrayList panFluteList = Lists.newArrayList((Object[])panFlutes);
        ArrayList gingkoBilobaList = Lists.newArrayList((Object[])gingkoBilobas);
        int i = 0;
        while (i < maxNumbers && !sheetsList.isEmpty()) {
            MerchantOffer merchantoffer = null;
            if (i <= 1) {
                merchantoffer = ((VillagerTrades.ItemListing)sheetsList.remove(this.random.nextInt(sheetsList.size()))).getOffer((Entity)this, this.random);
            }
            if (i > 1 && i <= 3) {
                merchantoffer = ((VillagerTrades.ItemListing)instrumentsList.remove(this.random.nextInt(instrumentsList.size()))).getOffer((Entity)this, this.random);
            }
            if (i == 4) {
                merchantoffer = ((VillagerTrades.ItemListing)panFluteList.remove(this.random.nextInt(panFluteList.size()))).getOffer((Entity)this, this.random);
            }
            if (i == 5) {
                merchantoffer = ((VillagerTrades.ItemListing)gingkoBilobaList.remove(this.random.nextInt(gingkoBilobaList.size()))).getOffer((Entity)this, this.random);
            }
            if (merchantoffer == null) continue;
            givenMerchantOffers.add((Object)merchantoffer);
            ++i;
        }
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (this.isAlive() && !this.isTrading() && !this.isBaby() && !this.isKoalaSleeping()) {
            if (!this.level().isClientSide) {
                if (this.getOffers().isEmpty()) {
                    return InteractionResult.CONSUME;
                }
                if (player.getInventory().contains(item -> item.is(ModItems.BOOGIE_FRUIT)) && this.offers != null && !this.offers.contains((Object)((VillagerTrades.ItemListing[])KoalaTrades.WANDERING_KOALA_TRADES.get(5))[0].getOffer((Entity)player, this.random))) {
                    this.offers.add((Object)((VillagerTrades.ItemListing[])KoalaTrades.WANDERING_KOALA_TRADES.get(5))[0].getOffer((Entity)player, this.random));
                }
                this.setTradingPlayer(player);
                this.openTradingScreen(player, this.getDisplayName(), 1);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        if (this.isKoalaSleeping()) {
            if (this.level().isClientSide()) {
                player.displayClientMessage((Component)Component.translatable((String)"text.faunaandorchestra.sleeping_wandering_koala"), true);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return super.mobInteract(player, hand);
    }

    public boolean hurt(DamageSource source, float amount) {
        Entity entity = source.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.isKoalaSleeping()) {
                player.displayClientMessage((Component)Component.translatable((String)"text.faunaandorchestra.dont_hurt_koala"), true);
            }
        }
        return super.hurt(source, amount);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Offers")) {
            MerchantOffers.CODEC.parse((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compound.get("Offers")).resultOrPartial(Util.prefix((String)"Failed to load offers: ", arg_0 -> ((Logger)LOGGER).warn(arg_0))).ifPresent(p_323775_ -> {
                this.offers = p_323775_;
            });
        }
        this.entityData.set(SITTING, (Object)compound.getBoolean("IsSitting"));
        this.entityData.set(SLEEPING, (Object)compound.getBoolean("IsSleeping"));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        MerchantOffers merchantoffers;
        super.addAdditionalSaveData(compound);
        if (!this.level().isClientSide && !(merchantoffers = this.getOffers()).isEmpty()) {
            compound.put("Offers", (Tag)MerchantOffers.CODEC.encodeStart((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)merchantoffers).getOrThrow());
        }
        compound.putBoolean("IsSitting", this.isSitting());
        compound.putBoolean("IsSleeping", this.isKoalaSleeping());
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        return null;
    }

    public void setTradingPlayer(@Nullable Player tradingPlayer) {
        this.tradingPlayer = tradingPlayer;
    }

    @Nullable
    public Player getTradingPlayer() {
        return this.tradingPlayer;
    }

    public boolean isTrading() {
        return this.tradingPlayer != null;
    }

    public void overrideOffers(MerchantOffers offers) {
        this.offers = offers;
    }

    public void notifyTrade(MerchantOffer offer) {
        offer.increaseUses();
        this.ambientSoundTime = -this.getAmbientSoundInterval();
        this.rewardTradeXp(offer);
        if (this.tradingPlayer instanceof ServerPlayer) {
            // empty if block
        }
    }

    protected void rewardTradeXp(MerchantOffer offer) {
        if (offer.shouldRewardExp()) {
            int i = 3 + this.random.nextInt(4);
            this.level().addFreshEntity((Entity)new ExperienceOrb(this.level(), this.getX(), this.getY() + 0.5, this.getZ(), i));
        }
    }

    public void notifyTradeUpdated(ItemStack stack) {
        if (!this.level().isClientSide && this.ambientSoundTime > -this.getAmbientSoundInterval() + 20) {
            this.ambientSoundTime = -this.getAmbientSoundInterval();
            this.makeSound(this.getTradeUpdatedSound(!stack.isEmpty()));
        }
    }

    protected SoundEvent getTradeUpdatedSound(boolean getYesSound) {
        return getYesSound ? SoundEvents.WANDERING_TRADER_YES : SoundEvents.WANDERING_TRADER_NO;
    }

    public int getVillagerXp() {
        return 0;
    }

    public void overrideXp(int xp) {
    }

    public boolean showProgressBar() {
        return false;
    }

    public SoundEvent getNotifyTradeSound() {
        return SoundEvents.VILLAGER_YES;
    }

    public boolean isClientSide() {
        return this.level().isClientSide();
    }

    public boolean isKoalaSleeping() {
        return this.isSleeping;
    }

    public void setSleeping(boolean sleeping) {
        if (!this.isSitting()) {
            this.setSitting(true);
        }
        this.entityData.set(SLEEPING, (Object)sleeping);
    }

    public void wakeUp() {
        this.triggerAnim("koala_controller", "wake_up");
        this.wakeUpTick = 200;
    }

    public void sitDown() {
        this.triggerAnim("koala_controller", "sit_down");
        this.setSitting(true);
    }

    public void standUp() {
        this.triggerAnim("koala_controller", "stand_up");
        this.setSitting(false);
    }

    public boolean isSitting() {
        return this.isSitting;
    }

    public void setSitting(boolean sitting) {
        if (this.isKoalaSleeping() && !sitting) {
            LOGGER.error("Koala tried to stand up while sleeping");
        }
        this.entityData.set(SITTING, (Object)sitting);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "koala_controller", 5, this::koalaState).triggerableAnim("stand_up", STAND_UP).triggerableAnim("sit_down", SIT_DOWN).triggerableAnim("wake_up", WAKE_UP));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

