/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.entity.custom.projectile;

import net.migueel26.faunaandorchestra.entity.ModEntities;
import net.migueel26.faunaandorchestra.entity.custom.boss.TheGreatComposer;
import net.migueel26.faunaandorchestra.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;

public class MusicNoteProjectileEntity
extends AbstractHurtingProjectile {
    protected float inertia = 0.7f;

    public MusicNoteProjectileEntity(EntityType<? extends AbstractHurtingProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public MusicNoteProjectileEntity(LivingEntity owner, Vec3 movement, Level level) {
        super(ModEntities.MUSIC_NOTE_PROJECTILE.get(), owner, movement, level);
    }

    protected void onHit(HitResult result) {
        EntityHitResult hitResult;
        boolean isComposer;
        boolean bl = isComposer = result instanceof EntityHitResult && (hitResult = (EntityHitResult)result).getEntity() instanceof TheGreatComposer;
        if (isComposer) {
            ((TheGreatComposer)((EntityHitResult)result).getEntity()).decreaseRepels();
        }
        super.onHit(result);
        if (!this.level().isClientSide && !isComposer) {
            boolean flag = EventHooks.canEntityGrief((Level)this.level(), (Entity)this.getOwner());
            this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 1.0f, flag, Level.ExplosionInteraction.MOB);
            for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)new BlockPos(this.getBlockX() + 2, this.getBlockY() + 1, this.getBlockZ() + 2), (BlockPos)new BlockPos(this.getBlockX() - 2, this.getBlockY() - 1, this.getBlockZ() - 2))) {
                if (!this.level().getBlockState(blockPos).is(Blocks.FIRE)) continue;
                this.level().setBlock(blockPos, Blocks.SOUL_FIRE.defaultBlockState(), 3);
            }
            this.discard();
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Entity entity = result.getEntity();
        if (entity instanceof TheGreatComposer) {
            TheGreatComposer greatComposer = (TheGreatComposer)entity;
            if (greatComposer.getRepels() > 0) {
                greatComposer.composerController.transitionLength(1);
                greatComposer.trigger("repel", true);
                this.level().playSound(null, this.blockPosition(), ModSounds.REPEL.get(), SoundSource.NEUTRAL);
                if (this.getOwner() != null) {
                    this.deflect(ProjectileDeflection.REVERSE, (Entity)this, (Entity)greatComposer, false);
                    this.inertia += 0.06f;
                }
            } else {
                this.discard();
            }
        } else {
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                Entity entity1 = result.getEntity();
                Entity owner = this.getOwner();
                DamageSource source = this.damageSources().magic();
                entity1.hurt(source, 8.0f);
                EnchantmentHelper.doPostAttackEffects((ServerLevel)serverlevel, (Entity)entity1, (DamageSource)source);
            }
        }
    }

    protected boolean shouldBurn() {
        return false;
    }

    @Nullable
    protected ParticleOptions getTrailParticle() {
        return ParticleTypes.SOUL_FIRE_FLAME;
    }

    protected float getInertia() {
        return this.inertia;
    }
}

