/*
 * Decompiled with CFR 0.152.
 */
package net.migueel26.faunaandorchestra.entity.goals;

import net.migueel26.faunaandorchestra.entity.custom.QuirkyFrogEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Path;

public class QuirkyFrogSingGoal
extends Goal {
    private final QuirkyFrogEntity chorister;
    private QuirkyFrogEntity conductor;
    private int ticksUntilNextPath;

    public QuirkyFrogSingGoal(QuirkyFrogEntity chorister) {
        this.chorister = chorister;
    }

    public boolean canUse() {
        return !this.chorister.isTame() && this.chorister.isSinging() && this.chorister.getFrogConductor() != null;
    }

    public boolean canContinueToUse() {
        return !this.chorister.isDeadOrDying() && this.conductor.isAlive() && this.canUse();
    }

    public void start() {
        this.conductor = this.chorister.getFrogConductor();
        this.ticksUntilNextPath = 20;
        super.start();
    }

    public void stop() {
        this.chorister.setSinging(false);
        this.chorister.setReady(false);
        this.chorister.getFrogChoir().remove((Object)this.chorister);
        this.chorister.setFrogConductor(null);
        super.stop();
    }

    public void tick() {
        if (this.ticksUntilNextPath <= 0) {
            float distance = this.chorister.distanceTo((Entity)this.conductor);
            if (distance > 5.0f) {
                Path path = this.chorister.getNavigation().createPath((Entity)this.conductor, 0);
                this.chorister.getNavigation().moveTo(path, 1.0);
                this.chorister.setReady(false);
            } else if (this.chorister.getNavigation().isDone()) {
                this.chorister.setReady(true);
            }
            this.ticksUntilNextPath = 20;
        } else {
            --this.ticksUntilNextPath;
        }
        this.chorister.getLookControl().setLookAt((Entity)this.conductor);
    }
}

